/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.gradle.PluginEffectiveConfiguration;
import com.vaadin.gradle.PrepareFrontendInputProperties;
import com.vaadin.gradle.VaadinUtilsKt;
import java.io.File;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0007J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0007J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0007J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/vaadin/gradle/PrepareFrontendInputProperties;", "", "config", "Lcom/vaadin/gradle/PluginEffectiveConfiguration;", "(Lcom/vaadin/gradle/PluginEffectiveConfiguration;)V", "tools", "Lorg/gradle/api/provider/Provider;", "Lcom/vaadin/flow/server/frontend/FrontendTools;", "getApplicationProperties", "Ljava/io/File;", "getCiBuild", "", "getEagerServerLoad", "getFeatureFlagsFile", "getForceProductionBuild", "getFrontendDirectory", "", "getFrontendHotdeploy", "getFrontendResourcesDirectory", "getGenerateBundle", "getGenerateEmbeddableWebComponent", "getGeneratedTsFolder", "getJavaResourceFolder", "getJavaSourceFolder", "getNodeAutoUpdate", "getNodeDownloadRoot", "getNodeExecutablePath", "getNodeVersion", "getNpmExecutablePath", "getNpmFolder", "getOpenApiJsonFile", "getOptimizeBundle", "getPnpmEnable", "getPnpmExecutablePath", "getPostInstallPackages", "Lorg/gradle/api/provider/ListProperty;", "getProductionMode", "getProjectBuildDir", "getRequireHomeNodeExec", "getRunNpmInstall", "getSkipDevBundleBuild", "getUseGlobalPnpm", "getWebpackOutputDirectory", "initialiseFrontendToolsSettings", "vaadin-gradle-plugin"})
public final class PrepareFrontendInputProperties {
    @NotNull
    private final PluginEffectiveConfiguration config;
    @NotNull
    private final Provider<FrontendTools> tools;

    public PrepareFrontendInputProperties(@NotNull PluginEffectiveConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.tools = this.initialiseFrontendToolsSettings();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getProductionMode() {
        return this.config.getProductionMode();
    }

    @Input
    @Optional
    @NotNull
    public final Provider<String> getWebpackOutputDirectory() {
        return VaadinUtilsKt.getAbsolutePath(VaadinUtilsKt.filterExists(this.config.getWebpackOutputDirectory()));
    }

    @Input
    @NotNull
    public final Provider<String> getNpmFolder() {
        return VaadinUtilsKt.getAbsolutePath(this.config.getNpmFolder());
    }

    @Input
    @NotNull
    public final Provider<String> getFrontendDirectory() {
        return VaadinUtilsKt.getAbsolutePath(this.config.getFrontendDirectory());
    }

    @Input
    @NotNull
    public final Provider<Boolean> getGenerateBundle() {
        return this.config.getGenerateBundle();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getRunNpmInstall() {
        return this.config.getRunNpmInstall();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getGenerateEmbeddableWebComponent() {
        return this.config.getGenerateEmbeddableWebComponents();
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final Provider<File> getFrontendResourcesDirectory() {
        return VaadinUtilsKt.filterExists((Provider<File>)((Provider)this.config.getFrontendResourcesDirectory()));
    }

    @Input
    @NotNull
    public final Provider<Boolean> getOptimizeBundle() {
        return (Provider)this.config.getOptimizeBundle();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getPnpmEnable() {
        return this.config.getPnpmEnable();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getUseGlobalPnpm() {
        return this.config.getUseGlobalPnpm();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getRequireHomeNodeExec() {
        return (Provider)this.config.getRequireHomeNodeExec();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getEagerServerLoad() {
        return this.config.getEagerServerLoad();
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final Provider<File> getApplicationProperties() {
        return VaadinUtilsKt.filterExists((Provider<File>)((Provider)this.config.getApplicationProperties()));
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final Provider<File> getOpenApiJsonFile() {
        return VaadinUtilsKt.filterExists((Provider<File>)((Provider)this.config.getOpenApiJsonFile()));
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final Provider<File> getFeatureFlagsFile() {
        Provider provider = this.config.getJavaResourceFolder().map(arg_0 -> PrepareFrontendInputProperties.getFeatureFlagsFile$lambda$0(getFeatureFlagsFile.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map(...)");
        return VaadinUtilsKt.filterExists((Provider<File>)provider);
    }

    @Input
    @NotNull
    public final Provider<String> getJavaSourceFolder() {
        return VaadinUtilsKt.getAbsolutePath((Provider<File>)((Provider)this.config.getJavaSourceFolder()));
    }

    @Input
    @NotNull
    public final Provider<String> getJavaResourceFolder() {
        return VaadinUtilsKt.getAbsolutePath((Provider<File>)((Provider)this.config.getJavaResourceFolder()));
    }

    @Input
    @NotNull
    public final Provider<String> getGeneratedTsFolder() {
        return VaadinUtilsKt.getAbsolutePath((Provider<File>)((Provider)this.config.getGeneratedTsFolder()));
    }

    @Input
    @NotNull
    public final Provider<String> getNodeVersion() {
        return (Provider)this.config.getNodeVersion();
    }

    @Input
    @NotNull
    public final Provider<String> getNodeDownloadRoot() {
        return (Provider)this.config.getNodeDownloadRoot();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getNodeAutoUpdate() {
        return (Provider)this.config.getNodeAutoUpdate();
    }

    @Input
    @NotNull
    public final Provider<String> getProjectBuildDir() {
        return (Provider)this.config.getProjectBuildDir();
    }

    @Input
    @NotNull
    public final ListProperty<String> getPostInstallPackages() {
        return this.config.getPostinstallPackages();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getFrontendHotdeploy() {
        return this.config.getFrontendHotdeploy();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getCiBuild() {
        return this.config.getCiBuild();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getSkipDevBundleBuild() {
        return (Provider)this.config.getSkipDevBundleBuild();
    }

    @Input
    @NotNull
    public final Provider<Boolean> getForceProductionBuild() {
        return this.config.getForceProductionBuild();
    }

    @Input
    @Optional
    @NotNull
    public final Provider<String> getNodeExecutablePath() {
        return VaadinUtilsKt.filterExistsString(VaadinUtilsKt.mapOrNull(this.tools, getNodeExecutablePath.1.INSTANCE));
    }

    @Input
    @Optional
    @NotNull
    public final Provider<String> getNpmExecutablePath() {
        Provider provider = this.tools.map(arg_0 -> PrepareFrontendInputProperties.getNpmExecutablePath$lambda$1(getNpmExecutablePath.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map(...)");
        return provider;
    }

    @Input
    @Optional
    @NotNull
    public final Provider<String> getPnpmExecutablePath() {
        Provider provider = this.config.getPnpmEnable().map(arg_0 -> PrepareFrontendInputProperties.getPnpmExecutablePath$lambda$2((Function1)new Function1<Boolean, String>(this){
            final /* synthetic */ PrepareFrontendInputProperties this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(Boolean pnpmEnable) {
                if (!pnpmEnable.booleanValue()) {
                    return "";
                }
                List list = ((FrontendTools)PrepareFrontendInputProperties.access$getTools$p(this.this$0).get()).getPnpmExecutable();
                List pnpmExecutable = list == null ? CollectionsKt.emptyList() : list;
                return CollectionsKt.joinToString$default((Iterable)pnpmExecutable, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map(...)");
        return provider;
    }

    private final Provider<FrontendTools> initialiseFrontendToolsSettings() {
        Provider provider = this.config.getNpmFolder().map(arg_0 -> PrepareFrontendInputProperties.initialiseFrontendToolsSettings$lambda$3((Function1)new Function1<File, FrontendTools>(this){
            final /* synthetic */ PrepareFrontendInputProperties this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final FrontendTools invoke(File npmFolder) {
                FrontendToolsSettings settings = new FrontendToolsSettings(npmFolder.getAbsolutePath(), initialiseFrontendToolsSettings.1::invoke$lambda$0);
                settings.setNodeDownloadRoot(new URI((String)PrepareFrontendInputProperties.access$getConfig$p(this.this$0).getNodeDownloadRoot().get()));
                Object object = PrepareFrontendInputProperties.access$getConfig$p(this.this$0).getRequireHomeNodeExec().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                settings.setForceAlternativeNode(((Boolean)object).booleanValue());
                Object object2 = PrepareFrontendInputProperties.access$getConfig$p(this.this$0).getUseGlobalPnpm().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                settings.setUseGlobalPnpm(((Boolean)object2).booleanValue());
                Object object3 = PrepareFrontendInputProperties.access$getConfig$p(this.this$0).getNodeAutoUpdate().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                settings.setAutoUpdate(((Boolean)object3).booleanValue());
                return new FrontendTools(settings);
            }

            private static final String invoke$lambda$0() {
                return FrontendUtils.getVaadinHomeDirectory().getAbsolutePath();
            }

            private static final /* synthetic */ Object $deserializeLambda$(SerializedLambda lambda) {
                if (Intrinsics.areEqual((Object)lambda.getImplMethodName(), (Object)"invoke$lambda$0") && lambda.getImplMethodKind() == 6 && lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableSupplier") && lambda.getFunctionalInterfaceMethodName().equals("get") && lambda.getFunctionalInterfaceMethodSignature().equals("()Ljava/lang/Object;") && lambda.getImplClass().equals("com/vaadin/gradle/PrepareFrontendInputProperties$initialiseFrontendToolsSettings$1") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return initialiseFrontendToolsSettings.1::invoke$lambda$0;
                }
                throw (Throwable)new IllegalArgumentException("Invalid lambda deserialization");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map(...)");
        return provider;
    }

    private static final File getFeatureFlagsFile$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(in);
    }

    private static final String getNpmExecutablePath$lambda$1(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final String getPnpmExecutablePath$lambda$2(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final FrontendTools initialiseFrontendToolsSettings$lambda$3(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FrontendTools)$tmp0.invoke(in);
    }

    public static final /* synthetic */ Provider access$getTools$p(PrepareFrontendInputProperties $this) {
        return $this.tools;
    }

    public static final /* synthetic */ PluginEffectiveConfiguration access$getConfig$p(PrepareFrontendInputProperties $this) {
        return $this.config;
    }
}

