/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.gradle.PluginEffectiveConfiguration;
import com.vaadin.gradle.VaadinBuildFrontendTask;
import com.vaadin.gradle.VaadinCleanTask;
import com.vaadin.gradle.VaadinConvertPolymerTask;
import com.vaadin.gradle.VaadinFlowPluginExtension;
import com.vaadin.gradle.VaadinPlugin;
import com.vaadin.gradle.VaadinPrepareFrontendTask;
import com.vaadin.gradle.VaadinUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lcom/vaadin/gradle/VaadinPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "verifyGradleVersion", "Companion", "vaadin-gradle-plugin"})
public final class VaadinPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GRADLE_MINIMUM_SUPPORTED_VERSION = "7.6";

    public void apply(@NotNull Project project) {
        TaskContainer taskContainer;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.verifyGradleVersion();
        project.getPluginManager().apply(JavaPlugin.class);
        String extensionName = "vaadin";
        if (project.getExtensions().findByName(extensionName) != null) {
            extensionName = "vaadinPlatform";
        }
        project.getExtensions().create(extensionName, VaadinFlowPluginExtension.class, new Object[0]);
        TaskContainer $this$apply_u24lambda_u240 = taskContainer = project.getTasks();
        boolean bl = false;
        $this$apply_u24lambda_u240.register("vaadinClean", VaadinCleanTask.class);
        $this$apply_u24lambda_u240.register("vaadinPrepareFrontend", VaadinPrepareFrontendTask.class);
        $this$apply_u24lambda_u240.register("vaadinBuildFrontend", VaadinBuildFrontendTask.class);
        $this$apply_u24lambda_u240.register("vaadinConvertPolymer", VaadinConvertPolymerTask.class);
        project.afterEvaluate(arg_0 -> VaadinPlugin.apply$lambda$1((Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                Intrinsics.checkNotNull((Object)it);
                PluginEffectiveConfiguration config = PluginEffectiveConfiguration.Companion.get$vaadin_gradle_plugin(it);
                Object object = config.getSourceSetName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Object[] objectArray = new Object[]{config.getResourceOutputDirectory()};
                VaadinUtilsKt.getSourceSet(it, (String)object).getResources().srcDirs(objectArray);
                objectArray = new Object[]{"vaadinPrepareFrontend"};
                this.$project.getTasks().getByPath((String)config.getProcessResourcesTaskName().get()).dependsOn(objectArray);
                Object object2 = config.getProductionMode().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                if (((Boolean)object2).booleanValue()) {
                    this.$project.getTasks().withType(Jar.class, arg_0 -> apply.2.invoke$lambda$0(apply.1.INSTANCE, arg_0));
                }
                Task task = this.$project.getTasks().getByName("vaadinPrepareFrontend");
                objectArray = new Object[1];
                Configuration configuration = this.$project.getConfigurations().getByName((String)config.getDependencyScope().get());
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
                objectArray[0] = VaadinUtilsKt.getJars(configuration);
                task.dependsOn(objectArray);
                Object object3 = config.getAlwaysExecutePrepareFrontend().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                if (((Boolean)object3).booleanValue()) {
                    this.$project.getTasks().getByName("vaadinPrepareFrontend").doNotTrackState("State tracking is disabled. Use the 'alwaysExecutePrepareFrontend' plugin setting to enable the feature");
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void verifyGradleVersion() {
        GradleVersion supportedVersion;
        GradleVersion currentVersion = GradleVersion.current();
        if (currentVersion.compareTo(supportedVersion = GradleVersion.version((String)GRADLE_MINIMUM_SUPPORTED_VERSION)) < 0) {
            throw new GradleException("Vaadin plugin requires Gradle 7.6 or later. The current version is " + currentVersion.getVersion() + ".");
        }
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vaadin/gradle/VaadinPlugin$Companion;", "", "()V", "GRADLE_MINIMUM_SUPPORTED_VERSION", "", "vaadin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

