/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.formlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.JsonSerializable;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

@Tag(value="vaadin-form-layout")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.4.0"), @NpmPackage(value="@vaadin/form-layout", version="24.4.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/form-layout/src/vaadin-form-layout.js")})
public class FormLayout
extends Component
implements HasSize,
HasStyle,
HasComponents,
ClickNotifier<FormLayout> {
    public FormLayout() {
    }

    public FormLayout(Component ... components) {
        this.add(components);
    }

    public void setColspan(Component component, int colspan) {
        Objects.requireNonNull(component, "component cannot be null");
        String strColspan = "";
        strColspan = colspan < 1 ? "1" : String.valueOf(colspan);
        component.getElement().setAttribute("colspan", strColspan);
    }

    public void add(Component component, int colspan) {
        this.add(new Component[]{component});
        this.setColspan(component, colspan);
    }

    public int getColspan(Component component) {
        String strColspan = component.getElement().getAttribute("colspan");
        if (strColspan == null) {
            return 1;
        }
        if (strColspan.matches("\\d+")) {
            return Integer.parseInt(strColspan);
        }
        return 1;
    }

    public List<ResponsiveStep> getResponsiveSteps() {
        JsonArray stepsJsonArray = (JsonArray)this.getElement().getPropertyRaw("responsiveSteps");
        if (stepsJsonArray == null) {
            return Collections.emptyList();
        }
        ArrayList<ResponsiveStep> steps = new ArrayList<ResponsiveStep>();
        for (int i = 0; i < stepsJsonArray.length(); ++i) {
            steps.add((ResponsiveStep)stepsJsonArray.get(i));
        }
        return steps;
    }

    public void setResponsiveSteps(List<ResponsiveStep> steps) {
        AtomicInteger index = new AtomicInteger();
        this.getElement().setPropertyJson("responsiveSteps", (JsonValue)steps.stream().map(ResponsiveStep::toJson).collect(Json::createArray, (arr, value) -> arr.set(index.getAndIncrement(), (JsonValue)value), (arr, arrOther) -> {
            int startIndex = arr.length();
            for (int i = 0; i < arrOther.length(); ++i) {
                JsonValue value = arrOther.get(i);
                arr.set(startIndex + i, value);
            }
        }));
    }

    public void setResponsiveSteps(ResponsiveStep ... steps) {
        this.setResponsiveSteps(Arrays.asList(steps));
    }

    public FormItem addFormItem(Component field, String label) {
        return this.addFormItem(field, (Component)new Label(label));
    }

    public FormItem addFormItem(Component field, Component label) {
        FormItem formItem = new FormItem(field);
        formItem.addToLabel(label);
        this.add(new Component[]{formItem});
        return formItem;
    }

    public static class ResponsiveStep
    implements JsonSerializable {
        private static final String MIN_WIDTH_JSON_KEY = "minWidth";
        private static final String COLUMNS_JSON_KEY = "columns";
        private static final String LABELS_POSITION_JSON_KEY = "labelsPosition";
        private String minWidth;
        private int columns;
        private LabelsPosition labelsPosition;

        public ResponsiveStep(String minWidth, int columns) {
            this.minWidth = minWidth;
            this.columns = columns;
        }

        public ResponsiveStep(String minWidth, int columns, LabelsPosition labelsPosition) {
            this.minWidth = minWidth;
            this.columns = columns;
            this.labelsPosition = labelsPosition;
        }

        public JsonObject toJson() {
            JsonObject json = Json.createObject();
            if (this.minWidth != null && !this.minWidth.chars().allMatch(Character::isWhitespace)) {
                json.put(MIN_WIDTH_JSON_KEY, this.minWidth);
            }
            json.put(COLUMNS_JSON_KEY, (double)this.columns);
            if (this.labelsPosition != null) {
                json.put(LABELS_POSITION_JSON_KEY, this.labelsPosition.toString());
            }
            return json;
        }

        public ResponsiveStep readJson(JsonObject value) {
            this.minWidth = value.getString(MIN_WIDTH_JSON_KEY);
            this.columns = (int)value.getNumber(COLUMNS_JSON_KEY);
            String labelsPositionString = value.getString(LABELS_POSITION_JSON_KEY);
            this.labelsPosition = "aside".equals(labelsPositionString) ? LabelsPosition.ASIDE : ("top".equals(labelsPositionString) ? LabelsPosition.TOP : null);
            return this;
        }

        public static enum LabelsPosition {
            ASIDE,
            TOP;


            public String toString() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }
        }
    }

    @Tag(value="vaadin-form-item")
    @NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.4.0"), @NpmPackage(value="@vaadin/form-layout", version="24.4.0")})
    @JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/form-layout/src/vaadin-form-item.js")})
    public static class FormItem
    extends Component
    implements HasComponents,
    HasStyle,
    ClickNotifier<FormItem> {
        public FormItem() {
        }

        public FormItem(Component ... components) {
            this.add(components);
        }

        protected void addToLabel(Component ... components) {
            SlotUtils.addToSlot((HasElement)this, (String)"label", (Component[])components);
        }

        public void removeAll() {
            this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
            this.getElement().removeAllChildren();
        }

        public void remove(Component ... components) {
            for (Component component : components) {
                if (!this.getElement().equals((Object)component.getElement().getParent())) {
                    throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
                }
                component.getElement().removeAttribute("slot");
                this.getElement().removeChild(new Element[]{component.getElement()});
            }
        }
    }
}

