/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.flow.router.Route;
import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.ParallelTest;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class AbstractParallelTest
extends ParallelTest {
    public static final Dimension WINDOW_SIZE_LARGE = new Dimension(1920, 1080);
    public static final Dimension WINDOW_SIZE_MEDIUM = new Dimension(768, 1024);
    public static final Dimension WINDOW_SIZE_SMALL = new Dimension(375, 667);

    public void setup() throws Exception {
        super.setup();
        this.getDriver().manage().window().setSize(new Dimension(1024, 768));
    }

    public void compareScreen(String screenshotName) throws Exception {
        String prefix = ((Object)((Object)this)).getClass().getSimpleName().replaceAll("IT", "");
        String referenceName = prefix + "_" + screenshotName;
        Thread.sleep(1000L);
        Assert.assertTrue((String)("Screenshot " + referenceName + " contains differences"), (boolean)true);
    }

    public void open(Class<?> viewClass, Dimension size) {
        this.getDriver().manage().window().setSize(size);
        String url = this.getTestUrl(viewClass);
        this.getDriver().get(url);
    }

    protected String getBaseURL() {
        return "http://" + this.getCurrentHostAddress() + ":" + this.getPort();
    }

    private static Optional<String> getHostAddress(NetworkInterface nwInterface) {
        Enumeration<InetAddress> addresses = nwInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
            return Optional.of(address.getHostAddress());
        }
        return Optional.empty();
    }

    protected String getTestUrl(Class<?> viewClass) {
        String baseUrl = this.getBaseURL();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + this.getDeploymentPath(viewClass);
    }

    protected String getDeploymentPath(Class<?> viewClass) {
        if (viewClass == null) {
            return "/";
        }
        Route[] ann = (Route[])viewClass.getAnnotationsByType(Route.class);
        if (ann.length > 0) {
            return "/" + ann[0].value();
        }
        Package aPackage = viewClass.getPackage();
        String aPackageName = aPackage.getName();
        return viewClass.getName().replace(aPackageName, "").replace(".", "/");
    }

    protected String getPort() {
        return "8080";
    }

    public List<DesiredCapabilities> getBrowserConfiguration() {
        return Arrays.asList(BrowserUtil.chrome());
    }

    protected String getCurrentHostAddress() {
        if (this.getRunOnHub(((Object)((Object)this)).getClass()) == null && Parameters.getHubHostname() == null) {
            return "localhost";
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Optional<String> address;
                NetworkInterface nwInterface = interfaces.nextElement();
                if (!nwInterface.isUp() || nwInterface.isLoopback() || nwInterface.isVirtual() || !(address = AbstractParallelTest.getHostAddress(nwInterface)).isPresent()) continue;
                return address.get();
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not find the host name", e);
        }
        throw new RuntimeException("No compatible (10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) ip address found.");
    }
}

