/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared.internal;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.dependency.JsModule;
import java.io.Serializable;
import java.util.Objects;

@JsModule(value="./disableOnClickFunctions.js")
public class DisableOnClickController<C extends Component>
implements Serializable {
    private final C component;
    private boolean disableOnClick = false;
    private boolean disableOnClickInitialized;

    public DisableOnClickController(C component) {
        this.component = (Component)Objects.requireNonNull(component);
        ComponentUtil.addListener(component, ClickEvent.class, (ComponentEventListener & Serializable)event -> {
            if (this.isDisableOnClick()) {
                ((HasEnabled)component).setEnabled(false);
            }
        });
    }

    public void setDisableOnClick(boolean disableOnClick) {
        this.disableOnClick = disableOnClick;
        if (disableOnClick) {
            this.component.getElement().setProperty("disableOnClick", "true");
            this.ensureDisableOnClickInitialized();
        } else {
            this.component.getElement().removeProperty("disableOnClick");
        }
    }

    public boolean isDisableOnClick() {
        return this.disableOnClick;
    }

    public void onSetEnabled(boolean enabled) {
        this.component.getElement().executeJs("this.disabled = $0", new Serializable[]{Boolean.valueOf(!enabled)});
    }

    private void ensureDisableOnClickInitialized() {
        if (this.disableOnClickInitialized) {
            return;
        }
        this.disableOnClickInitialized = true;
        if (this.component.isAttached()) {
            this.initDisableOnClick();
        }
        this.component.addAttachListener((ComponentEventListener & Serializable)event -> this.initDisableOnClick());
    }

    private void initDisableOnClick() {
        this.component.getElement().executeJs("window.Vaadin.Flow.disableOnClick.initDisableOnClick(this);", new Serializable[0]);
    }
}

