/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dialog;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dialog.GeneratedVaadinDialog;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;

@JsModule(value="./flow-component-renderer.js")
@HtmlImport(value="flow-component-renderer.html")
public class Dialog
extends GeneratedVaadinDialog<Dialog>
implements HasComponents,
HasSize {
    private Element template = new Element("template");
    private Element container;
    private boolean autoAddedToTheUi;
    private int onCloseConfigured;
    private String width;
    private String minWidth;
    private String maxWidth;
    private String height;
    private String minHeight;
    private String maxHeight;

    public Dialog() {
        this.getElement().appendChild(new Element[]{this.template});
        this.container = new Element("div");
        this.container.getClassList().add((Object)"draggable");
        this.container.getClassList().add((Object)"draggable-leaf-only");
        this.container.getStyle().set("width", "100%");
        this.container.getStyle().set("height", "100%");
        this.getElement().appendVirtualChild(new Element[]{this.container});
        this.getElement().getNode().addAttachListener(this::attachComponentRenderer);
        this.setOpened(false);
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
        this.addListener(DialogResizeEvent.class, (ComponentEventListener & Serializable)event -> {
            this.width = event.getWidth();
            this.height = event.getHeight();
        });
    }

    public void setWidth(String value) {
        this.width = value;
        this.setDimension("width", value);
    }

    public void setMinWidth(String value) {
        this.minWidth = value;
        this.setDimension("min-width", value);
    }

    public void setMaxWidth(String value) {
        this.maxWidth = value;
        this.setDimension("max-width", value);
    }

    public void setHeight(String value) {
        this.height = value;
        this.setDimension("height", value);
    }

    public void setMinHeight(String value) {
        this.minHeight = value;
        this.setDimension("min-height", value);
    }

    public void setMaxHeight(String value) {
        this.maxHeight = value;
        this.setDimension("max-height", value);
    }

    public String getWidth() {
        return this.width;
    }

    public String getMinWidth() {
        return this.minWidth;
    }

    public String getMaxWidth() {
        return this.maxWidth;
    }

    public String getHeight() {
        return this.height;
    }

    public String getMinHeight() {
        return this.minHeight;
    }

    public String getMaxHeight() {
        return this.maxHeight;
    }

    public Registration addDialogCloseActionListener(ComponentEventListener<DialogCloseActionEvent> listener) {
        if (this.isOpened()) {
            this.ensureOnCloseConfigured();
        }
        Registration openedRegistration = this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> {
            if (this.isOpened()) {
                this.ensureOnCloseConfigured();
            } else {
                this.onCloseConfigured = 0;
            }
        });
        Registration registration = this.addListener(DialogCloseActionEvent.class, listener);
        return (Registration & Serializable)() -> {
            if (this.isOpened()) {
                --this.onCloseConfigured;
            }
            openedRegistration.remove();
            registration.remove();
        };
    }

    public Registration addResizeListener(ComponentEventListener<DialogResizeEvent> listener) {
        return this.addListener(DialogResizeEvent.class, listener);
    }

    public Dialog(Component ... components) {
        this();
        this.add(components);
    }

    public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.container.appendChild(new Element[]{component.getElement()});
        }
    }

    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            if (!this.container.equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.container.removeChild(new Element[]{component.getElement()});
        }
    }

    public void removeAll() {
        this.container.removeAllChildren();
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        this.container.insertChild(index, new Element[]{component.getElement()});
    }

    public boolean isCloseOnEsc() {
        return !this.getElement().getProperty("noCloseOnEsc", false);
    }

    public void setCloseOnEsc(boolean closeOnEsc) {
        this.getElement().setProperty("noCloseOnEsc", !closeOnEsc);
    }

    public boolean isCloseOnOutsideClick() {
        return !this.getElement().getProperty("noCloseOnOutsideClick", false);
    }

    public void setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.getElement().setProperty("noCloseOnOutsideClick", !closeOnOutsideClick);
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    public void setModal(boolean modal) {
        this.getElement().setProperty("modeless", !modal);
    }

    public boolean isModal() {
        return !this.getElement().getProperty("modeless", false);
    }

    public void setDraggable(boolean draggable) {
        this.getElement().setProperty("draggable", draggable);
    }

    public boolean isDraggable() {
        return this.getElement().getProperty("draggable", false);
    }

    public void setResizable(boolean resizable) {
        this.getElement().setProperty("resizable", resizable);
    }

    public boolean isResizable() {
        return this.getElement().getProperty("resizable", false);
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitely set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void ensureAttached() {
        UI ui = this.getCurrentUI();
        ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
            if (this.getElement().getNode().getParent() == null) {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            }
        });
    }

    private void ensureOnCloseConfigured() {
        if (this.onCloseConfigured == 0) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.doEnsureOnCloseConfigured((UI)ui)));
        }
        ++this.onCloseConfigured;
    }

    private void doEnsureOnCloseConfigured(UI ui) {
        if (this.onCloseConfigured > 0) {
            ui.getPage().executeJs("var f = function(e) {  if (e.type == 'vaadin-overlay-escape-press' && !$0.noCloseOnEsc ||      e.type == 'vaadin-overlay-outside-click' && !$0.noCloseOnOutsideClick) {    e.preventDefault();    $0.dispatchEvent(new CustomEvent('vaadin-dialog-close-action'));  }};$0.$.overlay.addEventListener('vaadin-overlay-outside-click', f);$0.$.overlay.addEventListener('vaadin-overlay-escape-press', f);$0.addEventListener('opened-changed', function(){ if (!$0.opened) { $0.$.overlay.removeEventListener('vaadin-overlay-outside-click',f);$0.$.overlay.removeEventListener('vaadin-overlay-escape-press', f);} });", new Serializable[]{this.getElement()});
        }
    }

    @Override
    public void setOpened(boolean opened) {
        if (opened) {
            this.ensureAttached();
        }
        super.setOpened(opened);
    }

    public boolean isOpened() {
        return super.isOpenedBoolean();
    }

    public Stream<Component> getChildren() {
        Stream.Builder childComponents = Stream.builder();
        this.container.getChildren().forEach(childElement -> ComponentUtil.findComponents((Element)childElement, childComponents::add));
        return childComponents.build();
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinDialog.OpenedChangeEvent<Dialog>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    public Registration addAttachListener(ComponentEventListener<AttachEvent> listener) {
        return super.addAttachListener(listener);
    }

    public Registration addDetachListener(ComponentEventListener<DetachEvent> listener) {
        return super.addDetachListener(listener);
    }

    private void setDimension(String dimension, String value) {
        this.getElement().executeJs("this.$.overlay.$.overlay.style[$0]=$1", new Serializable[]{dimension, value});
    }

    private void attachComponentRenderer() {
        String appId = UI.getCurrent().getInternals().getAppId();
        int nodeId = this.container.getNode().getId();
        String renderer = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"%s\" style=\"display: flex; height: 100%%;\"></flow-component-renderer>", appId, nodeId);
        this.template.setProperty("innerHTML", renderer);
        this.setDimension("width", this.width);
        this.setDimension("min-width", this.minWidth);
        this.setDimension("max-width", this.maxWidth);
        this.setDimension("height", this.height);
        this.setDimension("min-height", this.minHeight);
        this.setDimension("max-height", this.maxHeight);
    }

    @DomEvent(value="resize")
    public static class DialogResizeEvent
    extends ComponentEvent<Dialog> {
        private final String width;
        private final String height;

        public DialogResizeEvent(Dialog source, boolean fromClient, @EventData(value="event.detail.width") String width, @EventData(value="event.detail.height") String height) {
            super((Component)source, fromClient);
            this.width = width;
            this.height = height;
        }

        public String getWidth() {
            return this.width;
        }

        public String getHeight() {
            return this.height;
        }
    }

    @DomEvent(value="vaadin-dialog-close-action")
    public static class DialogCloseActionEvent
    extends ComponentEvent<Dialog> {
        public DialogCloseActionEvent(Dialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

