/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import com.vaadin.base.devserver.ViteHandler;
import com.vaadin.base.devserver.viteproxy.ViteSessionTracker;
import com.vaadin.base.devserver.viteproxy.ViteWebsocketProxy;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.shared.Registration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViteWebsocketEndpoint
extends Endpoint {
    public static final String VITE_HANDLER = "viteServer";
    static final String TRACKER_KEY = "viteSessionTracker";
    private static final String HTTP_SESSION_ID = "httpSessionId";
    private ViteWebsocketProxy proxy;
    private Registration listenerRegistration;

    public static void init(VaadinContext context, ViteHandler viteHandler) {
        ServletContext servletContext = ((VaadinServletContext)context).getContext();
        ServerContainer container = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            ViteWebsocketEndpoint.getLogger().error("Unable to deploy Vite websocket endpoint, no container value is available");
            return;
        }
        try {
            List<String> subProtocols = List.of("vite-hmr", "vite-ping");
            ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(ViteWebsocketEndpoint.class, (String)viteHandler.getPathToVaadinInContext()).subprotocols(subProtocols).configurator((ServerEndpointConfig.Configurator)new HttpSessionConfigurator()).build();
            endpointConfig.getUserProperties().put(VITE_HANDLER, viteHandler);
            ViteSessionTracker tracker = (ViteSessionTracker)servletContext.getAttribute(ViteSessionTracker.class.getName());
            if (tracker != null) {
                endpointConfig.getUserProperties().put(TRACKER_KEY, tracker);
            }
            container.addEndpoint(endpointConfig);
        }
        catch (DeploymentException e) {
            ViteWebsocketEndpoint.getLogger().error("Error deploying Vite websocket proxy endpoint", (Throwable)e);
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        ViteWebsocketEndpoint.getLogger().debug("Browser ({}) connected to Vite proxy", (Object)session.getId());
        session.setMaxIdleTimeout(0L);
        ViteHandler viteHandler = (ViteHandler)config.getUserProperties().get(VITE_HANDLER);
        String httpSessionId = (String)config.getUserProperties().get(HTTP_SESSION_ID);
        ViteSessionTracker tracker = (ViteSessionTracker)config.getUserProperties().get(TRACKER_KEY);
        if (tracker != null && httpSessionId != null) {
            this.listenerRegistration = tracker.addListener((sessionId, closeCode, closeMessage) -> {
                if (sessionId.equals(httpSessionId)) {
                    try {
                        if (session.isOpen()) {
                            session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)closeCode), closeMessage));
                        }
                    }
                    catch (IOException e) {
                        ViteWebsocketEndpoint.getLogger().debug("Error closing session", (Throwable)e);
                    }
                }
            });
        }
        try {
            this.proxy = new ViteWebsocketProxy(session, viteHandler.getPort(), viteHandler.getPathToVaadin());
            session.addMessageHandler((MessageHandler)this.proxy);
        }
        catch (Exception e) {
            ViteWebsocketEndpoint.getLogger().error("Error creating Vite proxy connection", (Throwable)e);
            try {
                session.close();
            }
            catch (IOException e1) {
                ViteWebsocketEndpoint.getLogger().debug("Error closing connection", (Throwable)e1);
            }
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        ViteWebsocketEndpoint.getLogger().debug("Browser ({}) closed the connection", (Object)session.getId());
        if (this.listenerRegistration != null) {
            this.listenerRegistration.remove();
        }
        if (this.proxy != null) {
            this.proxy.close();
        }
        super.onClose(session, closeReason);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ViteWebsocketEndpoint.class);
    }

    public static class HttpSessionConfigurator
    extends ServerEndpointConfig.Configurator {
        public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
            Object httpSessionObject = request.getHttpSession();
            if (httpSessionObject instanceof HttpSession) {
                HttpSession httpSession = (HttpSession)httpSessionObject;
                config.getUserProperties().put(ViteWebsocketEndpoint.HTTP_SESSION_ID, httpSession.getId());
            }
        }
    }
}

