/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ViteSessionTracker {
    private final List<SessionCloseListener> listeners = new CopyOnWriteArrayList<SessionCloseListener>();

    public Registration addListener(SessionCloseListener listener) {
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    public void close(String httpSessionId, int closeCode, String closeMessage) {
        for (SessionCloseListener listener : this.listeners) {
            listener.onSessionClose(httpSessionId, closeCode, closeMessage);
        }
    }

    @FunctionalInterface
    public static interface SessionCloseListener {
        public void onSessionClose(String var1, int var2, String var3);
    }
}

