/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker.testbench;

import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.time.LocalDate;

@Element(value="vaadin-date-picker")
public class DatePickerElement
extends TestBenchElement
implements HasLabel,
HasHelper {
    public void clear() {
        this.setDate(null);
    }

    public void setDate(LocalDate date) {
        if (date == null) {
            this.setValue("");
        } else {
            this.setValue(date.toString());
        }
    }

    public LocalDate getDate() {
        String value = this.getValue();
        if (value.isEmpty()) {
            return null;
        }
        return LocalDate.parse(value);
    }

    protected void setValue(String value) {
        this.setProperty("value", value);
    }

    protected String getValue() {
        return this.getPropertyString(new String[]{"value"});
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }
}

