/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.ModalityMode;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.MenuItemsArrayGenerator;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.component.shared.internal.OverlayAutoAddController;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-context-menu")
@NpmPackage(value="@vaadin/context-menu", version="25.0.0-beta7")
@JsModule.Container(value={@JsModule(value="@vaadin/context-menu/src/vaadin-context-menu.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./contextMenuConnector.js"), @JsModule(value="./contextMenuTargetConnector.js")})
public abstract class ContextMenuBase<C extends ContextMenuBase<C, I, S>, I extends MenuItemBase<C, I, S>, S extends SubMenuBase<C, I, S>>
extends Component
implements HasStyle {
    public static final String EVENT_DETAIL = "event.detail";
    private Component target;
    private MenuManager<C, I, S> menuManager;
    private MenuItemsArrayGenerator<I> menuItemsArrayGenerator;
    private String openOnEventName = "vaadin-contextmenu";
    private Registration targetBeforeOpenRegistration;
    private Registration targetAttachRegistration;
    private Registration targetDetachRegistration;
    private PendingJavaScriptResult targetJsRegistration;
    private OverlayAutoAddController<ContextMenuBase<C, I, S>> overlayAutoAddController;

    public ContextMenuBase() {
        this.getElement().setProperty("opened", false);
        this.getElement().setProperty("openOn", "none");
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent<ContextMenuBase>(this, event.isUserOriginated())));
        this.menuItemsArrayGenerator = new MenuItemsArrayGenerator(this);
        this.addAttachListener((ComponentEventListener & Serializable)event -> {
            String appId = event.getUI().getInternals().getAppId();
            this.initConnector(appId);
            this.resetContent();
            this.updateListenOn();
        });
        this.overlayAutoAddController = new OverlayAutoAddController((Component)this, (SerializableSupplier & Serializable)() -> ModalityMode.MODELESS);
    }

    public void setTarget(Component target) {
        if (this.getTarget() != null) {
            this.targetBeforeOpenRegistration.remove();
            this.targetAttachRegistration.remove();
            this.targetDetachRegistration.remove();
            this.getTarget().getElement().executeJs("if (this.$contextMenuTargetConnector) { this.$contextMenuTargetConnector.removeConnector() }", new Object[0]);
            this.cancelTargetJavascriptExecution();
        }
        this.target = target;
        this.updateListenOn();
        if (target == null) {
            return;
        }
        target.getUI().ifPresent(this::onTargetAttach);
        this.targetAttachRegistration = target.addAttachListener((ComponentEventListener & Serializable)e -> this.onTargetAttach(e.getUI()));
        this.targetDetachRegistration = target.addDetachListener((ComponentEventListener & Serializable)e -> this.cancelTargetJavascriptExecution());
        this.targetBeforeOpenRegistration = target.getElement().addEventListener("vaadin-context-menu-before-open", this::beforeOpenHandler).addEventData(EVENT_DETAIL);
    }

    private void updateListenOn() {
        Component target = this.getTarget();
        this.getElement().executeJs("this.listenOn=$0;", new Object[]{target == null ? this : target});
    }

    public Component getTarget() {
        return this.target;
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnEventName = openOnClick ? "click" : "vaadin-contextmenu";
        this.requestTargetJsExecutions();
    }

    public boolean isOpenOnClick() {
        return "click".equals(this.openOnEventName);
    }

    public void close() {
        this.getElement().setProperty("opened", false);
        this.getElement().callJsFunction("close", new Object[0]);
    }

    public I addItem(String text) {
        return this.getMenuManager().addItem(text);
    }

    public I addItem(Component component) {
        return this.getMenuManager().addItem(component);
    }

    public void addComponent(Component ... components) {
        this.getMenuManager().addComponent(components);
    }

    public void addComponent(Collection<Component> components) {
        if (components == null) {
            return;
        }
        this.getMenuManager().addComponent((Component[])components.toArray(Component[]::new));
    }

    public void remove(Component ... components) {
        this.getMenuManager().remove(components);
    }

    public void removeAll() {
        this.getMenuManager().removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.getMenuManager().addComponentAtIndex(index, component);
    }

    public void addComponentAsFirst(Component component) {
        this.getMenuManager().addComponentAtIndex(0, component);
    }

    public void addSeparator() {
        this.getMenuManager().addSeparator();
    }

    public Stream<Component> getChildren() {
        return this.getMenuManager().getChildren();
    }

    public List<I> getItems() {
        return this.getMenuManager().getItems();
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<C>> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    protected MenuManager<C, I, S> getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = this.createMenuManager(this::resetContent);
        }
        return this.menuManager;
    }

    protected abstract MenuManager<C, I, S> createMenuManager(SerializableRunnable var1);

    protected boolean onBeforeOpenMenu(ObjectNode eventDetail) {
        return true;
    }

    private void resetContent() {
        this.menuItemsArrayGenerator.generate();
    }

    private void onTargetAttach(UI ui) {
        ui.getInternals().addComponentDependencies(ContextMenu.class);
        this.requestTargetJsExecutions();
        this.updateListenOn();
    }

    private void requestTargetJsExecutions() {
        if (this.target != null) {
            this.cancelTargetJavascriptExecution();
            this.targetJsRegistration = this.target.getElement().executeJs("window.Vaadin.Flow.contextMenuTargetConnector.init(this);this.$contextMenuTargetConnector.updateOpenOn($0);", new Object[]{this.openOnEventName});
        }
    }

    private void cancelTargetJavascriptExecution() {
        if (this.targetJsRegistration != null && !this.targetJsRegistration.isSentToBrowser()) {
            this.targetJsRegistration.cancelExecution();
        }
        this.targetJsRegistration = null;
    }

    private void beforeOpenHandler(DomEvent event) {
        ObjectNode eventDetail = (ObjectNode)event.getEventData().get(EVENT_DETAIL);
        boolean shouldOpenMenu = this.onBeforeOpenMenu(eventDetail);
        if (shouldOpenMenu) {
            this.overlayAutoAddController.add();
            this.target.getElement().callJsFunction("$contextMenuTargetConnector.openMenu", new Object[]{this.getElement()});
        }
    }

    private void initConnector(String appId) {
        this.getElement().executeJs("window.Vaadin.Flow.contextMenuConnector.initLazy(this, $0)", new Object[]{appId});
    }

    public static class OpenedChangeEvent<TComponent extends ContextMenuBase<TComponent, ?, ?>>
    extends ComponentEvent<TComponent> {
        private final boolean opened;

        public OpenedChangeEvent(TComponent source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((ContextMenuBase)((Object)source)).isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

