/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MenuManager<C extends Component, I extends MenuItemBase<?, I, S>, S extends SubMenuBase<?, I, S>>
implements Serializable {
    private final C menu;
    private final SerializableBiFunction<C, SerializableRunnable, I> itemGenerator;
    private final Class<I> itemType;
    private final I parentMenuItem;
    private final SerializableRunnable contentReset;
    private final List<Component> children = new ArrayList<Component>();

    public MenuManager(C menu, SerializableRunnable contentReset, SerializableBiFunction<C, SerializableRunnable, I> itemGenerator, Class<I> itemType, I parentMenuItem) {
        this.menu = menu;
        this.contentReset = contentReset;
        this.itemGenerator = itemGenerator;
        this.itemType = itemType;
        this.parentMenuItem = parentMenuItem;
    }

    public I addItem(String text) {
        MenuItemBase menuItem = (MenuItemBase)((Object)this.itemGenerator.apply(this.menu, (Object)this.contentReset));
        menuItem.setText(text);
        this.add(menuItem);
        return (I)((Object)menuItem);
    }

    public I addItem(Component component) {
        MenuItemBase menuItem = (MenuItemBase)((Object)this.itemGenerator.apply(this.menu, (Object)this.contentReset));
        this.add(menuItem);
        menuItem.add(new Component[]{component});
        return (I)((Object)menuItem);
    }

    public I addItem(String text, ComponentEventListener<ClickEvent<I>> clickListener) {
        I menuItem = this.addItem(text);
        if (clickListener != null) {
            ComponentUtil.addListener(menuItem, ClickEvent.class, clickListener);
        }
        return menuItem;
    }

    public I addItem(Component component, ComponentEventListener<ClickEvent<I>> clickListener) {
        I menuItem = this.addItem(component);
        if (clickListener != null) {
            ComponentUtil.addListener(menuItem, ClickEvent.class, clickListener);
        }
        return menuItem;
    }

    public void add(Component ... components) {
        if (this.parentMenuItem != null && ((MenuItemBase)((Object)this.parentMenuItem)).isCheckable()) {
            throw new IllegalStateException("A checkable item cannot have a sub menu");
        }
        Objects.requireNonNull(components, "Components to add cannot be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.children.add(component);
        }
        if (components.length > 0) {
            this.updateChildren();
        }
    }

    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components to remove cannot be null");
        boolean needUpdate = false;
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            if (!this.children.remove(component)) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            needUpdate = true;
        }
        if (needUpdate) {
            this.updateChildren();
        }
    }

    public void removeAll() {
        this.children.clear();
        this.updateChildren();
    }

    public void addComponentAtIndex(int index, Component component) {
        if (this.parentMenuItem != null && ((MenuItemBase)((Object)this.parentMenuItem)).isCheckable()) {
            throw new IllegalStateException("A checkable item cannot have a sub menu");
        }
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        this.children.add(index, component);
        this.updateChildren();
    }

    public Stream<Component> getChildren() {
        return this.children.stream();
    }

    public List<I> getItems() {
        return this.getChildren().filter(this.itemType::isInstance).map(this.itemType::cast).collect(Collectors.toList());
    }

    private void updateChildren() {
        this.contentReset.run();
    }
}

