/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.MenuItemsArrayGenerator;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;

@Tag(value="vaadin-context-menu")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.6"), @NpmPackage(value="@vaadin/context-menu", version="24.1.6")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/context-menu/src/vaadin-context-menu.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./contextMenuConnector.js"), @JsModule(value="./contextMenuTargetConnector.js")})
public abstract class ContextMenuBase<C extends ContextMenuBase<C, I, S>, I extends MenuItemBase<C, I, S>, S extends SubMenuBase<C, I, S>>
extends Component
implements HasComponents,
HasStyle {
    public static final String EVENT_DETAIL = "event.detail";
    private Component target;
    private MenuManager<C, I, S> menuManager;
    private MenuItemsArrayGenerator<I> menuItemsArrayGenerator;
    private String openOnEventName = "vaadin-contextmenu";
    private Registration targetBeforeOpenRegistration;
    private Registration targetAttachRegistration;
    private PendingJavaScriptResult targetJsRegistration;
    private boolean autoAddedToTheUi;

    public ContextMenuBase() {
        this.getElement().setProperty("opened", false);
        this.getElement().setProperty("openOn", "none");
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent<ContextMenuBase>(this, event.isUserOriginated())));
        this.menuItemsArrayGenerator = new MenuItemsArrayGenerator(this);
        this.addAttachListener((ComponentEventListener & Serializable)event -> {
            String appId = event.getUI().getInternals().getAppId();
            this.initConnector(appId);
            this.resetContent();
        });
    }

    public void setTarget(Component target) {
        if (this.getTarget() != null) {
            this.targetBeforeOpenRegistration.remove();
            this.targetAttachRegistration.remove();
            this.getTarget().getElement().callJsFunction("$contextMenuTargetConnector.removeConnector", new Serializable[0]);
            if (this.isTargetJsPending()) {
                this.targetJsRegistration.cancelExecution();
                this.targetJsRegistration = null;
            }
        }
        this.target = target;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJs("$0.listenOn=$1", new Serializable[]{this, target})));
        if (target == null) {
            return;
        }
        target.getUI().ifPresent(this::onTargetAttach);
        this.targetAttachRegistration = target.addAttachListener((ComponentEventListener & Serializable)e -> this.onTargetAttach(e.getUI()));
        this.targetBeforeOpenRegistration = target.getElement().addEventListener("vaadin-context-menu-before-open", this::beforeOpenHandler).addEventData(EVENT_DETAIL);
    }

    public Component getTarget() {
        return this.target;
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnEventName = openOnClick ? "click" : "vaadin-contextmenu";
        this.requestTargetJsExecutions();
    }

    public boolean isOpenOnClick() {
        return "click".equals(this.openOnEventName);
    }

    public void close() {
        this.getElement().callJsFunction("close", new Serializable[0]);
    }

    public I addItem(String text) {
        return this.getMenuManager().addItem(text);
    }

    public I addItem(Component component) {
        return this.getMenuManager().addItem(component);
    }

    public void add(Component ... components) {
        this.getMenuManager().add(components);
    }

    public void remove(Component ... components) {
        this.getMenuManager().remove(components);
    }

    public void removeAll() {
        this.getMenuManager().removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.getMenuManager().addComponentAtIndex(index, component);
    }

    public Stream<Component> getChildren() {
        return this.getMenuManager().getChildren();
    }

    public List<I> getItems() {
        return this.getMenuManager().getItems();
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<C>> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    protected MenuManager<C, I, S> getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = this.createMenuManager(this::resetContent);
        }
        return this.menuManager;
    }

    protected abstract MenuManager<C, I, S> createMenuManager(SerializableRunnable var1);

    protected boolean onBeforeOpenMenu(JsonObject eventDetail) {
        return true;
    }

    private void resetContent() {
        this.menuItemsArrayGenerator.generate();
    }

    private void onTargetAttach(UI ui) {
        ui.getInternals().addComponentDependencies(ContextMenu.class);
        this.requestTargetJsExecutions();
    }

    private void requestTargetJsExecutions() {
        if (this.target != null) {
            if (this.isTargetJsPending()) {
                this.targetJsRegistration.cancelExecution();
            }
            this.targetJsRegistration = this.target.getElement().executeJs("window.Vaadin.Flow.contextMenuTargetConnector.init(this);this.$contextMenuTargetConnector.updateOpenOn($0);", new Serializable[]{this.openOnEventName});
        }
    }

    private boolean isTargetJsPending() {
        return this.targetJsRegistration != null && !this.targetJsRegistration.isSentToBrowser();
    }

    private void beforeOpenHandler(DomEvent event) {
        JsonObject eventDetail = event.getEventData().getObject(EVENT_DETAIL);
        boolean shouldOpenMenu = this.onBeforeOpenMenu(eventDetail);
        if (shouldOpenMenu) {
            this.addContextMenuToUi();
            this.target.getElement().callJsFunction("$contextMenuTargetConnector.openMenu", new Serializable[]{this.getElement()});
        }
    }

    private void addContextMenuToUi() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.addToModalComponent((Component)this);
                this.autoAddedToTheUi = true;
            });
        }
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void initConnector(String appId) {
        this.getElement().executeJs("window.Vaadin.Flow.contextMenuConnector.initLazy(this, $0)", new Serializable[]{appId});
    }

    public static class OpenedChangeEvent<TComponent extends ContextMenuBase<TComponent, ?, ?>>
    extends ComponentEvent<TComponent> {
        private final boolean opened;

        public OpenedChangeEvent(TComponent source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((ContextMenuBase)((Object)source)).isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

