/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.GeneratedVaadinContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@HtmlImport.Container(value={@HtmlImport(value="flow-component-renderer.html"), @HtmlImport(value="frontend://bower_components/vaadin-list-box/src/vaadin-list-box.html")})
@JavaScript(value="frontend://contextMenuConnector.js")
public class ContextMenuBase<C extends ContextMenuBase<C>>
extends GeneratedVaadinContextMenu<C>
implements HasComponents {
    private Component target;
    private Element template = new Element("template");
    private Element container;
    private String openOnEventName = "vaadin-contextmenu";
    private Registration targetBeforeOpenRegistration;
    private boolean autoAddedToTheUi;

    public ContextMenuBase() {
        this.getElement().appendChild(new Element[]{this.template});
        this.container = new Element("vaadin-list-box");
        this.getElement().appendVirtualChild(new Element[]{this.container});
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.attachComponentRenderer()));
        this.getElement().setProperty("opened", false);
        this.setOpenOn("none");
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
    }

    public void setTarget(Component target) {
        if (this.getTarget() != null) {
            this.targetBeforeOpenRegistration.remove();
            this.getTarget().getElement().callFunction("$contextMenuConnector.removeConnector", new Serializable[0]);
        }
        this.target = target;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJavaScript("$0.listenOn=$1", new Serializable[]{this, target})));
        if (target == null) {
            return;
        }
        target.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(target, (SerializableConsumer & Serializable)context -> {
            ui.getInternals().addComponentDependencies(ContextMenuBase.class);
            ui.getPage().executeJavaScript("window.Vaadin.Flow.contextMenuConnector.init($0)", new Serializable[]{target.getElement()});
        }));
        this.updateOpenOn();
        this.targetBeforeOpenRegistration = target.getElement().addEventListener("vaadin-context-menu-before-open", (DomEventListener & Serializable)event -> {
            this.beforeOpen();
            target.getElement().callFunction("$contextMenuConnector.openMenu", new Serializable[]{this.getElement()});
        });
    }

    private void updateOpenOn() {
        if (this.target != null) {
            this.target.getElement().callFunction("$contextMenuConnector.updateOpenOn", new Serializable[]{this.openOnEventName});
        }
    }

    private void beforeOpen() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            });
        }
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    public Component getTarget() {
        return this.target;
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnEventName = openOnClick ? "click" : "vaadin-contextmenu";
        this.updateOpenOn();
    }

    public boolean isOpenOnClick() {
        return "click".equals(this.openOnEventName);
    }

    @Override
    public void close() {
        super.close();
    }

    public void add(Component ... components) {
        Objects.requireNonNull(components, "Components to add cannot be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.container.appendChild(new Element[]{component.getElement()});
        }
    }

    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components to remove cannot be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            if (!this.container.equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.container.removeChild(new Element[]{component.getElement()});
        }
    }

    public void removeAll() {
        this.container.removeAllChildren();
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        this.container.insertChild(index, new Element[]{component.getElement()});
    }

    public Stream<Component> getChildren() {
        Stream.Builder childComponents = Stream.builder();
        this.container.getChildren().forEach(childElement -> ComponentUtil.findComponents((Element)childElement, childComponents::add));
        return childComponents.build();
    }

    public List<MenuItem> getItems() {
        return this.getChildren().filter(MenuItem.class::isInstance).map(child -> (MenuItem)((Object)child)).collect(Collectors.toList());
    }

    public boolean isOpened() {
        return super.isOpenedBoolean();
    }

    protected MenuItem addItem(String text) {
        MenuItem menuItem = new MenuItem(this);
        this.add(menuItem);
        menuItem.setText(text);
        return menuItem;
    }

    protected MenuItem addItem(Component component) {
        MenuItem menuItem = new MenuItem(this);
        this.add(menuItem);
        menuItem.add(new Component[]{component});
        return menuItem;
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinContextMenu.OpenedChangeEvent<C>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    private void attachComponentRenderer() {
        String appId = UI.getCurrent().getInternals().getAppId();
        int nodeId = this.container.getNode().getId();
        String renderer = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"%s\"></flow-component-renderer>", appId, nodeId);
        this.template.setProperty("innerHTML", renderer);
    }
}

