/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.server.NoInputStreamException;
import com.vaadin.server.NoOutputStreamException;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.StreamVariable;
import com.vaadin.server.VariableOwner;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.ui.Component;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.shared.ui.upload.UploadClientRpc;
import com.vaadin.v7.shared.ui.upload.UploadServerRpc;
import com.vaadin.v7.shared.ui.upload.UploadState;
import com.vaadin.v7.ui.AbstractLegacyComponent;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;

@Deprecated
public class Upload
extends AbstractLegacyComponent
implements Component.Focusable,
LegacyComponent {
    private final boolean focus = false;
    private int tabIndex = 0;
    private Receiver receiver;
    private boolean isUploading;
    private long contentLength = -1L;
    private int totalBytes;
    private String buttonCaption = "Upload";
    private LinkedHashSet<ProgressListener> progressListeners;
    private boolean interrupted = false;
    private boolean notStarted;
    private int nextid;
    private static final Method UPLOAD_FINISHED_METHOD;
    private static final Method UPLOAD_FAILED_METHOD;
    private static final Method UPLOAD_SUCCEEDED_METHOD;
    private static final Method UPLOAD_STARTED_METHOD;
    private StreamVariable streamVariable;

    public Upload() {
        this.registerRpc((ServerRpc)new UploadServerRpc(){

            public void change(String filename) {
                Upload.this.fireEvent((EventObject)((Object)new ChangeEvent(Upload.this, filename)));
            }

            public void poll() {
            }
        });
    }

    public Upload(String caption, Receiver uploadReceiver) {
        this();
        this.setCaption(caption);
        this.receiver = uploadReceiver;
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        if (variables.containsKey("pollForStart")) {
            int id = (Integer)variables.get("pollForStart");
            if (!this.isUploading && id == this.nextid) {
                this.notStarted = true;
                this.markAsDirty();
            }
        }
    }

    public void paintContent(PaintTarget target) throws PaintException {
        if (this.notStarted) {
            target.addAttribute("notStarted", true);
            this.notStarted = false;
            return;
        }
        if (this.tabIndex >= 0) {
            target.addAttribute("tabindex", this.tabIndex);
        }
        target.addAttribute("state", this.isUploading);
        if (this.buttonCaption != null) {
            target.addAttribute("buttoncaption", this.buttonCaption);
        }
        target.addAttribute("nextid", this.nextid);
        target.addVariable((VariableOwner)this, "action", this.getStreamVariable());
    }

    public void addStartedListener(StartedListener listener) {
        this.addListener(StartedEvent.class, listener, UPLOAD_STARTED_METHOD);
    }

    @Deprecated
    public void addListener(StartedListener listener) {
        this.addStartedListener(listener);
    }

    public void removeStartedListener(StartedListener listener) {
        this.removeListener(StartedEvent.class, listener, UPLOAD_STARTED_METHOD);
    }

    @Deprecated
    public void removeListener(StartedListener listener) {
        this.removeStartedListener(listener);
    }

    public void addFinishedListener(FinishedListener listener) {
        this.addListener(FinishedEvent.class, listener, UPLOAD_FINISHED_METHOD);
    }

    @Deprecated
    public void addListener(FinishedListener listener) {
        this.addFinishedListener(listener);
    }

    public void removeFinishedListener(FinishedListener listener) {
        this.removeListener(FinishedEvent.class, listener, UPLOAD_FINISHED_METHOD);
    }

    @Deprecated
    public void removeListener(FinishedListener listener) {
        this.removeFinishedListener(listener);
    }

    public void addFailedListener(FailedListener listener) {
        this.addListener(FailedEvent.class, listener, UPLOAD_FAILED_METHOD);
    }

    @Deprecated
    public void addListener(FailedListener listener) {
        this.addFailedListener(listener);
    }

    public void removeFailedListener(FailedListener listener) {
        this.removeListener(FailedEvent.class, listener, UPLOAD_FAILED_METHOD);
    }

    @Deprecated
    public void removeListener(FailedListener listener) {
        this.removeFailedListener(listener);
    }

    public void addSucceededListener(SucceededListener listener) {
        this.addListener(SucceededEvent.class, listener, UPLOAD_SUCCEEDED_METHOD);
    }

    @Deprecated
    public void addListener(SucceededListener listener) {
        this.addSucceededListener(listener);
    }

    public void removeSucceededListener(SucceededListener listener) {
        this.removeListener(SucceededEvent.class, listener, UPLOAD_SUCCEEDED_METHOD);
    }

    @Deprecated
    public void removeListener(SucceededListener listener) {
        this.removeSucceededListener(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new LinkedHashSet();
        }
        this.progressListeners.add(listener);
    }

    @Deprecated
    public void addListener(ProgressListener listener) {
        this.addProgressListener(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (this.progressListeners != null) {
            this.progressListeners.remove(listener);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        super.addListener("change", ChangeEvent.class, (Object)listener, ChangeListener.FILENAME_CHANGED);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeListener("change", ChangeEvent.class, (Object)listener);
    }

    @Deprecated
    public void removeListener(ProgressListener listener) {
        this.removeProgressListener(listener);
    }

    protected void fireStarted(String filename, String mimeType) {
        this.fireEvent((EventObject)((Object)new StartedEvent(this, filename, mimeType, this.contentLength)));
    }

    protected void fireUploadInterrupted(String filename, String mimeType, long length) {
        this.fireEvent((EventObject)((Object)new FailedEvent(this, filename, mimeType, length)));
    }

    protected void fireNoInputStream(String filename, String mimeType, long length) {
        this.fireEvent((EventObject)((Object)new NoInputStreamEvent(this, filename, mimeType, length)));
    }

    protected void fireNoOutputStream(String filename, String mimeType, long length) {
        this.fireEvent((EventObject)((Object)new NoOutputStreamEvent(this, filename, mimeType, length)));
    }

    protected void fireUploadInterrupted(String filename, String mimeType, long length, Exception e) {
        this.fireEvent((EventObject)((Object)new FailedEvent(this, filename, mimeType, length, e)));
    }

    protected void fireUploadSuccess(String filename, String mimeType, long length) {
        this.fireEvent((EventObject)((Object)new SucceededEvent(this, filename, mimeType, length)));
    }

    protected void fireUpdateProgress(long totalBytes, long contentLength) {
        if (this.progressListeners != null) {
            for (ProgressListener l : this.progressListeners) {
                l.updateProgress(totalBytes, contentLength);
            }
        }
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void focus() {
        super.focus();
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public void startUpload() {
        if (this.isUploading) {
            throw new IllegalStateException("uploading already started");
        }
        this.isUploading = true;
        ++this.nextid;
    }

    public void interruptUpload() {
        if (this.isUploading) {
            this.interrupted = true;
        }
    }

    private void endUpload() {
        this.isUploading = false;
        this.contentLength = -1L;
        this.interrupted = false;
        this.markAsDirty();
    }

    public boolean isUploading() {
        return this.isUploading;
    }

    public long getBytesRead() {
        return this.totalBytes;
    }

    public long getUploadSize() {
        return this.contentLength;
    }

    public String getButtonCaption() {
        return this.buttonCaption;
    }

    public void setButtonCaption(String buttonCaption) {
        this.buttonCaption = buttonCaption;
        this.markAsDirty();
    }

    public void submitUpload() {
        this.markAsDirty();
        ((UploadClientRpc)this.getRpcProxy(UploadClientRpc.class)).submitUpload();
    }

    public void markAsDirty() {
        super.markAsDirty();
    }

    protected StreamVariable getStreamVariable() {
        if (this.streamVariable == null) {
            this.streamVariable = new StreamVariable(){
                private StreamVariable.StreamingStartEvent lastStartedEvent;

                public boolean listenProgress() {
                    return Upload.this.progressListeners != null && !Upload.this.progressListeners.isEmpty();
                }

                public void onProgress(StreamVariable.StreamingProgressEvent event) {
                    Upload.this.fireUpdateProgress(event.getBytesReceived(), event.getContentLength());
                }

                public boolean isInterrupted() {
                    return Upload.this.interrupted;
                }

                public OutputStream getOutputStream() {
                    if (Upload.this.getReceiver() == null) {
                        throw new IllegalStateException("Upload cannot be performed without a receiver set");
                    }
                    OutputStream receiveUpload = Upload.this.getReceiver().receiveUpload(this.lastStartedEvent.getFileName(), this.lastStartedEvent.getMimeType());
                    this.lastStartedEvent = null;
                    return receiveUpload;
                }

                public void streamingStarted(StreamVariable.StreamingStartEvent event) {
                    Upload.this.startUpload();
                    Upload.this.contentLength = event.getContentLength();
                    Upload.this.fireStarted(event.getFileName(), event.getMimeType());
                    this.lastStartedEvent = event;
                }

                public void streamingFinished(StreamVariable.StreamingEndEvent event) {
                    Upload.this.fireUploadSuccess(event.getFileName(), event.getMimeType(), event.getContentLength());
                    Upload.this.endUpload();
                }

                public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
                    try {
                        Exception exception = event.getException();
                        if (exception instanceof NoInputStreamException) {
                            Upload.this.fireNoInputStream(event.getFileName(), event.getMimeType(), 0L);
                        } else if (exception instanceof NoOutputStreamException) {
                            Upload.this.fireNoOutputStream(event.getFileName(), event.getMimeType(), 0L);
                        } else {
                            Upload.this.fireUploadInterrupted(event.getFileName(), event.getMimeType(), 0L, exception);
                        }
                    }
                    finally {
                        Upload.this.endUpload();
                    }
                }
            };
        }
        return this.streamVariable;
    }

    public Collection<?> getListeners(Class<?> eventType) {
        if (StreamVariable.StreamingProgressEvent.class.isAssignableFrom(eventType)) {
            if (this.progressListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.progressListeners);
        }
        return super.getListeners(eventType);
    }

    @Override
    public boolean isImmediate() {
        if (this.getExplicitImmediateValue() != null) {
            return this.getExplicitImmediateValue();
        }
        return false;
    }

    protected UploadState getState() {
        return (UploadState)super.getState();
    }

    static {
        try {
            UPLOAD_FINISHED_METHOD = FinishedListener.class.getDeclaredMethod("uploadFinished", FinishedEvent.class);
            UPLOAD_FAILED_METHOD = FailedListener.class.getDeclaredMethod("uploadFailed", FailedEvent.class);
            UPLOAD_STARTED_METHOD = StartedListener.class.getDeclaredMethod("uploadStarted", StartedEvent.class);
            UPLOAD_SUCCEEDED_METHOD = SucceededListener.class.getDeclaredMethod("uploadSucceeded", SucceededEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in Upload");
        }
    }

    @Deprecated
    public static interface ProgressListener
    extends Serializable {
        public void updateProgress(long var1, long var3);
    }

    @Deprecated
    public static interface ChangeListener
    extends Serializable {
        public static final Method FILENAME_CHANGED = ReflectTools.findMethod(ChangeListener.class, (String)"filenameChanged", (Class[])new Class[]{ChangeEvent.class});

        public void filenameChanged(ChangeEvent var1);
    }

    @Deprecated
    public static interface SucceededListener
    extends Serializable {
        public void uploadSucceeded(SucceededEvent var1);
    }

    @Deprecated
    public static interface FailedListener
    extends Serializable {
        public void uploadFailed(FailedEvent var1);
    }

    @Deprecated
    public static interface FinishedListener
    extends Serializable {
        public void uploadFinished(FinishedEvent var1);
    }

    @Deprecated
    public static interface StartedListener
    extends Serializable {
        public void uploadStarted(StartedEvent var1);
    }

    @Deprecated
    public static class ChangeEvent
    extends Component.Event {
        private final String filename;

        public ChangeEvent(Upload source, String filename) {
            super((Component)source);
            this.filename = filename;
        }

        public Upload getSource() {
            return (Upload)((Object)super.getSource());
        }

        public String getFilename() {
            return this.filename;
        }
    }

    @Deprecated
    public static class StartedEvent
    extends Component.Event {
        private final String filename;
        private final String type;
        private final long length;

        public StartedEvent(Upload source, String filename, String mimeType, long contentLength) {
            super((Component)source);
            this.filename = filename;
            this.type = mimeType;
            this.length = contentLength;
        }

        public Upload getUpload() {
            return (Upload)((Object)this.getSource());
        }

        public String getFilename() {
            return this.filename;
        }

        public String getMIMEType() {
            return this.type;
        }

        public long getContentLength() {
            return this.length;
        }
    }

    @Deprecated
    public static class SucceededEvent
    extends FinishedEvent {
        public SucceededEvent(Upload source, String filename, String mimeType, long length) {
            super(source, filename, mimeType, length);
        }
    }

    @Deprecated
    public static class NoInputStreamEvent
    extends FailedEvent {
        public NoInputStreamEvent(Upload source, String filename, String mimeType, long length) {
            super(source, filename, mimeType, length);
        }
    }

    @Deprecated
    public static class NoOutputStreamEvent
    extends FailedEvent {
        public NoOutputStreamEvent(Upload source, String filename, String mimeType, long length) {
            super(source, filename, mimeType, length);
        }
    }

    @Deprecated
    public static class FailedEvent
    extends FinishedEvent {
        private Exception reason = null;

        public FailedEvent(Upload source, String filename, String mimeType, long length, Exception reason) {
            this(source, filename, mimeType, length);
            this.reason = reason;
        }

        public FailedEvent(Upload source, String filename, String mimeType, long length) {
            super(source, filename, mimeType, length);
        }

        public Exception getReason() {
            return this.reason;
        }
    }

    @Deprecated
    public static class FinishedEvent
    extends Component.Event {
        private final long length;
        private final String type;
        private final String filename;

        public FinishedEvent(Upload source, String filename, String mimeType, long length) {
            super((Component)source);
            this.type = mimeType;
            this.filename = filename;
            this.length = length;
        }

        public Upload getUpload() {
            return (Upload)((Object)this.getSource());
        }

        public String getFilename() {
            return this.filename;
        }

        public String getMIMEType() {
            return this.type;
        }

        public long getLength() {
            return this.length;
        }
    }

    @Deprecated
    public static interface Receiver
    extends Serializable {
        public OutputStream receiveUpload(String var1, String var2);
    }
}

