/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.Action;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.DropTarget;
import com.vaadin.event.dd.TargetDetails;
import com.vaadin.server.KeyMapper;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.ui.LegacyComponent;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.shared.ui.calendar.CalendarServerRpc;
import com.vaadin.v7.shared.ui.calendar.CalendarState;
import com.vaadin.v7.ui.AbstractLegacyComponent;
import com.vaadin.v7.ui.components.calendar.CalendarComponentEvents;
import com.vaadin.v7.ui.components.calendar.CalendarDateRange;
import com.vaadin.v7.ui.components.calendar.CalendarTargetDetails;
import com.vaadin.v7.ui.components.calendar.ContainerEventProvider;
import com.vaadin.v7.ui.components.calendar.event.BasicEventProvider;
import com.vaadin.v7.ui.components.calendar.event.CalendarEditableEventProvider;
import com.vaadin.v7.ui.components.calendar.event.CalendarEvent;
import com.vaadin.v7.ui.components.calendar.event.CalendarEventProvider;
import com.vaadin.v7.ui.components.calendar.handler.BasicBackwardHandler;
import com.vaadin.v7.ui.components.calendar.handler.BasicDateClickHandler;
import com.vaadin.v7.ui.components.calendar.handler.BasicEventMoveHandler;
import com.vaadin.v7.ui.components.calendar.handler.BasicEventResizeHandler;
import com.vaadin.v7.ui.components.calendar.handler.BasicForwardHandler;
import com.vaadin.v7.ui.components.calendar.handler.BasicWeekClickHandler;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public class Calendar
extends AbstractLegacyComponent
implements CalendarComponentEvents.NavigationNotifier,
CalendarComponentEvents.EventMoveNotifier,
CalendarComponentEvents.RangeSelectNotifier,
CalendarComponentEvents.EventResizeNotifier,
CalendarEventProvider.EventSetChangeListener,
DropTarget,
CalendarEditableEventProvider,
Action.Container,
LegacyComponent {
    protected TimeFormat currentTimeFormat;
    protected java.util.Calendar currentCalendar = java.util.Calendar.getInstance();
    protected TimeZone timezone;
    protected Date startDate = null;
    protected Date endDate = null;
    private CalendarEventProvider calendarEventProvider;
    protected List<CalendarEvent> events;
    protected DateFormat df_date = new SimpleDateFormat("yyyy-MM-dd");
    protected DateFormat df_time = new SimpleDateFormat("HH:mm:ss");
    protected DateFormat df_date_time = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    private int scrollTop = 0;
    private String weeklyCaptionFormat = null;
    private final Map<String, EventListener> handlers;
    private DropHandler dropHandler;
    private int firstDay = 1;
    private int lastDay = 7;
    private int firstHour = 0;
    private int lastHour = 23;
    private LinkedList<Action.Handler> actionHandlers = null;
    private KeyMapper<Action> actionMapper = null;
    private CalendarServerRpcImpl rpc = new CalendarServerRpcImpl();
    private Integer minTimeInMinutes;
    private Integer maxTimeInMinutes;
    private Integer customFirstDayOfWeek;

    protected Logger getLogger() {
        return Logger.getLogger(Calendar.class.getName());
    }

    public Calendar() {
        this(null, new BasicEventProvider());
    }

    public Calendar(String caption) {
        this(caption, new BasicEventProvider());
    }

    public Calendar(CalendarEventProvider eventProvider) {
        this(null, eventProvider);
    }

    public Calendar(String caption, CalendarEventProvider eventProvider) {
        this.registerRpc((ServerRpc)this.rpc);
        this.setCaption(caption);
        this.handlers = new HashMap<String, EventListener>();
        this.setDefaultHandlers();
        this.currentCalendar.setTime(new Date());
        this.setEventProvider(eventProvider);
        this.getState().firstDayOfWeek = this.firstDay;
        this.getState().lastVisibleDayOfWeek = this.lastDay;
        this.getState().firstHourOfDay = this.firstHour;
        this.getState().lastHourOfDay = this.lastHour;
        this.setTimeFormat(null);
    }

    public CalendarState getState() {
        return (CalendarState)super.getState();
    }

    protected CalendarState getState(boolean markAsDirty) {
        return (CalendarState)super.getState(markAsDirty);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        this.initCalendarWithLocale();
        this.getState().format24H = TimeFormat.Format24H == this.getTimeFormat();
        this.setupDaysAndActions();
        this.setupCalendarEvents();
        this.rpc.scroll(this.scrollTop);
    }

    protected void setDefaultHandlers() {
        this.setHandler(new BasicBackwardHandler());
        this.setHandler(new BasicForwardHandler());
        this.setHandler(new BasicWeekClickHandler());
        this.setHandler(new BasicDateClickHandler());
        this.setHandler(new BasicEventMoveHandler());
        this.setHandler(new BasicEventResizeHandler());
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            this.currentCalendar.set(14, 0);
            this.currentCalendar.set(13, 0);
            this.currentCalendar.set(12, 0);
            this.currentCalendar.set(11, 0);
            this.currentCalendar.set(7, this.currentCalendar.getFirstDayOfWeek());
            return this.currentCalendar.getTime();
        }
        return this.startDate;
    }

    public void setStartDate(Date date) {
        if (!date.equals(this.startDate)) {
            this.startDate = date;
            this.markAsDirty();
        }
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            this.currentCalendar.set(14, 0);
            this.currentCalendar.set(13, 59);
            this.currentCalendar.set(12, 59);
            this.currentCalendar.set(11, 23);
            this.currentCalendar.set(7, this.currentCalendar.getFirstDayOfWeek() + 6);
            return this.currentCalendar.getTime();
        }
        return this.endDate;
    }

    public void setEndDate(Date date) {
        if (this.startDate != null && this.startDate.after(date)) {
            this.startDate = (Date)date.clone();
            this.markAsDirty();
        } else if (!date.equals(this.endDate)) {
            this.endDate = date;
            this.markAsDirty();
        }
    }

    public void setLocale(Locale newLocale) {
        super.setLocale(newLocale);
        this.initCalendarWithLocale();
    }

    private void initCalendarWithLocale() {
        this.currentCalendar = this.timezone != null ? java.util.Calendar.getInstance(this.timezone, this.getLocale()) : java.util.Calendar.getInstance(this.getLocale());
        if (this.customFirstDayOfWeek != null) {
            this.currentCalendar.setFirstDayOfWeek(this.customFirstDayOfWeek);
        }
    }

    private void setupCalendarEvents() {
        int durationInDays = (int)((this.endDate.getTime() - this.startDate.getTime()) / 86400000L);
        if (++durationInDays > 60) {
            throw new RuntimeException("Daterange is too big (max 60) = " + durationInDays);
        }
        Date firstDateToShow = this.expandStartDate(this.startDate, durationInDays > 7);
        Date lastDateToShow = this.expandEndDate(this.endDate, durationInDays > 7);
        this.currentCalendar.setTime(firstDateToShow);
        this.events = this.getEventProvider().getEvents(firstDateToShow, lastDateToShow);
        this.cacheMinMaxTimeOfDay(this.events);
        ArrayList<CalendarState.Event> calendarStateEvents = new ArrayList<CalendarState.Event>();
        if (this.events != null) {
            for (int i = 0; i < this.events.size(); ++i) {
                CalendarEvent e = this.events.get(i);
                CalendarState.Event event = new CalendarState.Event();
                event.index = i;
                event.caption = e.getCaption() == null ? "" : e.getCaption();
                event.dateFrom = this.df_date.format(e.getStart());
                event.dateTo = this.df_date.format(e.getEnd());
                event.timeFrom = this.df_time.format(e.getStart());
                event.timeTo = this.df_time.format(e.getEnd());
                event.description = e.getDescription() == null ? "" : e.getDescription();
                event.styleName = e.getStyleName() == null ? "" : e.getStyleName();
                event.allDay = e.isAllDay();
                calendarStateEvents.add(event);
            }
        }
        this.getState().events = calendarStateEvents;
    }

    private void cacheMinMaxTimeOfDay(List<CalendarEvent> events) {
        this.minTimeInMinutes = null;
        this.maxTimeInMinutes = null;
        if (events != null) {
            for (CalendarEvent event : events) {
                int minuteOfDayStart = Calendar.getMinuteOfDay(event.getStart());
                int minuteOfDayEnd = Calendar.getMinuteOfDay(event.getEnd());
                if (this.minTimeInMinutes == null) {
                    this.minTimeInMinutes = minuteOfDayStart;
                    this.maxTimeInMinutes = minuteOfDayEnd;
                    continue;
                }
                if (minuteOfDayStart < this.minTimeInMinutes) {
                    this.minTimeInMinutes = minuteOfDayStart;
                }
                if (minuteOfDayEnd <= this.maxTimeInMinutes) continue;
                this.maxTimeInMinutes = minuteOfDayEnd;
            }
        }
    }

    private static int getMinuteOfDay(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11) * 60 + calendar.get(12);
    }

    public void autoScaleVisibleHoursOfDay() {
        if (this.minTimeInMinutes != null) {
            this.setFirstVisibleHourOfDay(this.minTimeInMinutes / 60);
            this.setLastVisibleHourOfDay((this.maxTimeInMinutes - 1) / 60);
        }
    }

    public void resetVisibleHoursOfDay() {
        this.setFirstVisibleHourOfDay(0);
        this.setLastVisibleHourOfDay(23);
    }

    private void setupDaysAndActions() {
        this.initCalendarWithLocale();
        CalendarState state = this.getState();
        state.firstDayOfWeek = this.currentCalendar.getFirstDayOfWeek();
        if (this.startDate == null ^ this.endDate == null) {
            String message = "Schedule cannot be painted without a proper date range.\n";
            if (this.startDate == null) {
                throw new IllegalStateException(message + "You must set a start date using setStartDate(Date).");
            }
            throw new IllegalStateException(message + "You must set an end date using setEndDate(Date).");
        }
        if (this.startDate == null && this.endDate == null) {
            this.startDate = this.getStartDate();
            this.endDate = this.getEndDate();
        }
        int durationInDays = (int)((this.endDate.getTime() - this.startDate.getTime()) / 86400000L);
        if (++durationInDays > 60) {
            throw new RuntimeException("Daterange is too big (max 60) = " + durationInDays);
        }
        state.dayNames = this.getDayNamesShort();
        state.monthNames = this.getMonthNamesShort();
        Date now = new Date();
        this.currentCalendar.setTime(now);
        now = this.currentCalendar.getTime();
        this.df_date.setTimeZone(this.currentCalendar.getTimeZone());
        this.df_time.setTimeZone(this.currentCalendar.getTimeZone());
        state.now = this.df_date.format(now) + " " + this.df_time.format(now);
        Date firstDateToShow = this.expandStartDate(this.startDate, durationInDays > 7);
        Date lastDateToShow = this.expandEndDate(this.endDate, durationInDays > 7);
        this.currentCalendar.setTime(firstDateToShow);
        DateFormat weeklyCaptionFormatter = this.getWeeklyCaptionFormatter();
        weeklyCaptionFormatter.setTimeZone(this.currentCalendar.getTimeZone());
        HashMap<CalendarDateRange, Set<Action>> actionMap = new HashMap<CalendarDateRange, Set<Action>>();
        ArrayList<CalendarState.Day> days = new ArrayList<CalendarState.Day>();
        while (this.currentCalendar.getTime().compareTo(lastDateToShow) < 1) {
            Date date = this.currentCalendar.getTime();
            CalendarState.Day day = new CalendarState.Day();
            day.date = this.df_date.format(date);
            day.localizedDateFormat = weeklyCaptionFormatter.format(date);
            day.dayOfWeek = Calendar.getDowByLocale(this.currentCalendar);
            day.week = this.getWeek(this.currentCalendar);
            day.yearOfWeek = this.getYearOfWeek(this.currentCalendar);
            days.add(day);
            if (this.actionHandlers != null) {
                for (Action.Handler actionHandler : this.actionHandlers) {
                    boolean monthView;
                    GregorianCalendar cal = new GregorianCalendar(this.getTimeZone(), this.getLocale());
                    cal.clear();
                    cal.set(this.currentCalendar.get(1), this.currentCalendar.get(2), this.currentCalendar.get(5));
                    Date start = cal.getTime();
                    cal.add(5, 1);
                    cal.add(13, -1);
                    Date end = cal.getTime();
                    boolean bl = monthView = durationInDays > 7;
                    if (monthView) {
                        this.setActionsForDay(actionMap, start, end, actionHandler);
                        continue;
                    }
                    this.setActionsForEachHalfHour(actionMap, start, end, actionHandler);
                }
            }
            this.currentCalendar.add(5, 1);
        }
        state.days = days;
        state.actions = this.createActionsList(actionMap);
    }

    private int getWeek(java.util.Calendar calendar) {
        return calendar.get(3);
    }

    private int getYearOfWeek(java.util.Calendar calendar) {
        int week = this.getWeek(calendar);
        int month = calendar.get(2);
        int year = calendar.get(1);
        if (week == 1 && month == 11) {
            return year + 1;
        }
        return year;
    }

    private void setActionsForEachHalfHour(Map<CalendarDateRange, Set<Action>> actionMap, Date start, Date end, Action.Handler actionHandler) {
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone(), this.getLocale());
        cal.setTime(start);
        while (cal.getTime().before(end)) {
            Date s = cal.getTime();
            cal.add(12, 30);
            Date e = cal.getTime();
            CalendarDateRange range = new CalendarDateRange(s, e, this.getTimeZone());
            Action[] actions = actionHandler.getActions((Object)range, (Object)this);
            if (actions == null) continue;
            LinkedHashSet<Action> actionSet = new LinkedHashSet<Action>(Arrays.asList(actions));
            actionMap.put(range, actionSet);
        }
    }

    private void setActionsForDay(Map<CalendarDateRange, Set<Action>> actionMap, Date start, Date end, Action.Handler actionHandler) {
        CalendarDateRange range = new CalendarDateRange(start, end, this.getTimeZone());
        Action[] actions = actionHandler.getActions((Object)range, (Object)this);
        if (actions != null) {
            LinkedHashSet<Action> actionSet = new LinkedHashSet<Action>(Arrays.asList(actions));
            actionMap.put(range, actionSet);
        }
    }

    private List<CalendarState.Action> createActionsList(Map<CalendarDateRange, Set<Action>> actionMap) {
        if (actionMap.isEmpty()) {
            return null;
        }
        ArrayList<CalendarState.Action> calendarActions = new ArrayList<CalendarState.Action>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(this.getTimeZone());
        for (Map.Entry<CalendarDateRange, Set<Action>> entry : actionMap.entrySet()) {
            CalendarDateRange range = entry.getKey();
            Set<Action> actions = entry.getValue();
            for (Action action : actions) {
                String key = this.actionMapper.key((Object)action);
                CalendarState.Action calendarAction = new CalendarState.Action();
                calendarAction.actionKey = key;
                calendarAction.caption = action.getCaption();
                this.setResource(key, action.getIcon());
                calendarAction.iconKey = key;
                calendarAction.startDate = formatter.format(range.getStart());
                calendarAction.endDate = formatter.format(range.getEnd());
                calendarActions.add(calendarAction);
            }
        }
        return calendarActions;
    }

    public TimeFormat getTimeFormat() {
        if (this.currentTimeFormat == null) {
            SimpleDateFormat f = this.getLocale() == null ? (SimpleDateFormat)SimpleDateFormat.getTimeInstance(3) : (SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, this.getLocale());
            String p = f.toPattern();
            if (p.indexOf("HH") != -1 || p.indexOf("H") != -1) {
                return TimeFormat.Format24H;
            }
            return TimeFormat.Format12H;
        }
        return this.currentTimeFormat;
    }

    public void setTimeFormat(TimeFormat format) {
        this.currentTimeFormat = format;
        this.markAsDirty();
    }

    public TimeZone getTimeZone() {
        if (this.timezone == null) {
            return this.currentCalendar.getTimeZone();
        }
        return this.timezone;
    }

    public void setTimeZone(TimeZone zone) {
        this.timezone = zone;
        if (!this.currentCalendar.getTimeZone().equals(zone)) {
            if (zone == null) {
                zone = TimeZone.getDefault();
            }
            this.currentCalendar.setTimeZone(zone);
            this.df_date_time.setTimeZone(zone);
            this.markAsDirty();
        }
    }

    public java.util.Calendar getInternalCalendar() {
        return this.currentCalendar;
    }

    public void setFirstVisibleDayOfWeek(int firstDay) {
        if (this.firstDay != firstDay && firstDay >= 1 && firstDay <= 7 && this.getLastVisibleDayOfWeek() >= firstDay) {
            this.firstDay = firstDay;
            this.getState().firstVisibleDayOfWeek = firstDay;
        }
    }

    public int getFirstVisibleDayOfWeek() {
        return this.firstDay;
    }

    public void setLastVisibleDayOfWeek(int lastDay) {
        if (this.lastDay != lastDay && lastDay >= 1 && lastDay <= 7 && this.getFirstVisibleDayOfWeek() <= lastDay) {
            this.lastDay = lastDay;
            this.getState().lastVisibleDayOfWeek = lastDay;
        }
    }

    public int getLastVisibleDayOfWeek() {
        return this.lastDay;
    }

    public void setFirstVisibleHourOfDay(int firstHour) {
        if (this.firstHour != firstHour && firstHour >= 0 && firstHour <= 23 && firstHour <= this.getLastVisibleHourOfDay()) {
            this.firstHour = firstHour;
            this.getState().firstHourOfDay = firstHour;
        }
    }

    public int getFirstVisibleHourOfDay() {
        return this.firstHour;
    }

    public void setLastVisibleHourOfDay(int lastHour) {
        if (this.lastHour != lastHour && lastHour >= 0 && lastHour <= 23 && lastHour >= this.getFirstVisibleHourOfDay()) {
            this.lastHour = lastHour;
            this.getState().lastHourOfDay = lastHour;
        }
    }

    public int getLastVisibleHourOfDay() {
        return this.lastHour;
    }

    public String getWeeklyCaptionFormat() {
        return this.weeklyCaptionFormat;
    }

    public void setWeeklyCaptionFormat(String dateFormatPattern) {
        if (this.weeklyCaptionFormat == null && dateFormatPattern != null || this.weeklyCaptionFormat != null && !this.weeklyCaptionFormat.equals(dateFormatPattern)) {
            this.weeklyCaptionFormat = dateFormatPattern;
            this.markAsDirty();
        }
    }

    public void setEventSortOrder(CalendarState.EventSortOrder order) {
        this.getState().eventSortOrder = order == null ? CalendarState.EventSortOrder.DURATION_DESC : CalendarState.EventSortOrder.values()[order.ordinal()];
    }

    public CalendarState.EventSortOrder getEventSortOrder() {
        CalendarState.EventSortOrder order = this.getState((boolean)false).eventSortOrder;
        if (order == null) {
            return CalendarState.EventSortOrder.DURATION_DESC;
        }
        return order;
    }

    private DateFormat getWeeklyCaptionFormatter() {
        if (this.weeklyCaptionFormat != null) {
            return new SimpleDateFormat(this.weeklyCaptionFormat, this.getLocale());
        }
        return SimpleDateFormat.getDateInstance(3, this.getLocale());
    }

    private static int getDowByLocale(java.util.Calendar calendar) {
        int fow = calendar.get(7);
        if (calendar.getFirstDayOfWeek() == 2) {
            fow = fow == 1 ? 7 : fow - 1;
        }
        return fow;
    }

    protected boolean isClientChangeAllowed() {
        return !this.isReadOnly();
    }

    @Deprecated
    protected boolean isEventClickAllowed() {
        return true;
    }

    protected void fireNavigationEvent(boolean forward) {
        if (forward) {
            this.fireEvent((EventObject)((Object)new CalendarComponentEvents.ForwardEvent(this)));
        } else {
            this.fireEvent((EventObject)((Object)new CalendarComponentEvents.BackwardEvent(this)));
        }
    }

    protected void fireEventMove(int index, Date newFromDatetime) {
        CalendarComponentEvents.MoveEvent event = new CalendarComponentEvents.MoveEvent(this, this.events.get(index), newFromDatetime);
        if (this.calendarEventProvider instanceof CalendarComponentEvents.EventMoveHandler) {
            ((CalendarComponentEvents.EventMoveHandler)((Object)this.calendarEventProvider)).eventMove(event);
        }
        this.fireEvent((EventObject)((Object)event));
    }

    protected void fireWeekClick(int week, int year) {
        this.fireEvent((EventObject)((Object)new CalendarComponentEvents.WeekClick(this, week, year)));
    }

    protected void fireEventClick(Integer index) {
        this.fireEvent((EventObject)((Object)new CalendarComponentEvents.EventClick(this, this.events.get(index))));
    }

    protected void fireDateClick(Date date) {
        this.fireEvent((EventObject)((Object)new CalendarComponentEvents.DateClickEvent(this, date)));
    }

    protected void fireRangeSelect(Date from, Date to, boolean monthlyMode) {
        this.fireEvent((EventObject)((Object)new CalendarComponentEvents.RangeSelectEvent(this, from, to, monthlyMode)));
    }

    protected void fireEventResize(int index, Date startTime, Date endTime) {
        CalendarComponentEvents.EventResize event = new CalendarComponentEvents.EventResize(this, this.events.get(index), startTime, endTime);
        if (this.calendarEventProvider instanceof CalendarComponentEvents.EventResizeHandler) {
            ((CalendarComponentEvents.EventResizeHandler)((Object)this.calendarEventProvider)).eventResize(event);
        }
        this.fireEvent((EventObject)((Object)event));
    }

    protected String[] getDayNamesShort() {
        DateFormatSymbols s = new DateFormatSymbols(this.getLocale());
        return Arrays.copyOfRange(s.getWeekdays(), 1, 8);
    }

    protected String[] getMonthNamesShort() {
        DateFormatSymbols s = new DateFormatSymbols(this.getLocale());
        return Arrays.copyOf(s.getShortMonths(), 12);
    }

    protected Date getFirstDateForWeek(Date date) {
        int firstDayOfWeek = this.currentCalendar.getFirstDayOfWeek();
        this.currentCalendar.setTime(date);
        while (firstDayOfWeek != this.currentCalendar.get(7)) {
            this.currentCalendar.add(5, -1);
        }
        return this.currentCalendar.getTime();
    }

    protected Date getLastDateForWeek(Date date) {
        this.currentCalendar.setTime(date);
        this.currentCalendar.add(5, 1);
        int firstDayOfWeek = this.currentCalendar.getFirstDayOfWeek();
        while (firstDayOfWeek != this.currentCalendar.get(7)) {
            this.currentCalendar.add(5, 1);
        }
        this.currentCalendar.add(5, -1);
        return this.currentCalendar.getTime();
    }

    private static Date getEndOfDay(java.util.Calendar calendar, Date date) {
        java.util.Calendar calendarClone = (java.util.Calendar)calendar.clone();
        calendarClone.setTime(date);
        calendarClone.set(14, calendarClone.getActualMaximum(14));
        calendarClone.set(13, calendarClone.getActualMaximum(13));
        calendarClone.set(12, calendarClone.getActualMaximum(12));
        calendarClone.set(10, calendarClone.getActualMaximum(10));
        calendarClone.set(11, calendarClone.getActualMaximum(11));
        return calendarClone.getTime();
    }

    private static Date getStartOfDay(java.util.Calendar calendar, Date date) {
        java.util.Calendar calendarClone = (java.util.Calendar)calendar.clone();
        calendarClone.setTime(date);
        calendarClone.set(14, 0);
        calendarClone.set(13, 0);
        calendarClone.set(12, 0);
        calendarClone.set(10, 0);
        calendarClone.set(11, 0);
        return calendarClone.getTime();
    }

    protected Date expandStartDate(Date start, boolean expandToFullWeek) {
        start = expandToFullWeek ? this.getFirstDateForWeek(start) : (Date)start.clone();
        start = Calendar.getStartOfDay(this.currentCalendar, start);
        return start;
    }

    protected Date expandEndDate(Date end, boolean expandToFullWeek) {
        end = expandToFullWeek ? this.getLastDateForWeek(end) : (Date)end.clone();
        end = Calendar.getEndOfDay(this.currentCalendar, end);
        return end;
    }

    public void setEventProvider(CalendarEventProvider calendarEventProvider) {
        if (calendarEventProvider == null) {
            throw new IllegalArgumentException("Calendar event provider cannot be null");
        }
        if (this.getEventProvider() instanceof CalendarEventProvider.EventSetChangeNotifier) {
            ((CalendarEventProvider.EventSetChangeNotifier)((Object)this.getEventProvider())).removeEventSetChangeListener(this);
        }
        this.calendarEventProvider = calendarEventProvider;
        if (calendarEventProvider instanceof CalendarEventProvider.EventSetChangeNotifier) {
            ((CalendarEventProvider.EventSetChangeNotifier)((Object)calendarEventProvider)).addEventSetChangeListener(this);
        }
    }

    public CalendarEventProvider getEventProvider() {
        return this.calendarEventProvider;
    }

    @Override
    public void eventSetChange(CalendarEventProvider.EventSetChangeEvent changeEvent) {
        if (this.calendarEventProvider == changeEvent.getProvider()) {
            this.markAsDirty();
        }
    }

    protected void setHandler(String eventId, Class<?> eventType, EventListener listener, Method listenerMethod) {
        if (this.handlers.get(eventId) != null) {
            this.removeListener(eventId, eventType, this.handlers.get(eventId));
            this.handlers.remove(eventId);
        }
        if (listener != null) {
            this.addListener(eventId, eventType, listener, listenerMethod);
            this.handlers.put(eventId, listener);
        }
    }

    @Override
    public void setHandler(CalendarComponentEvents.ForwardHandler listener) {
        this.setHandler("forward", CalendarComponentEvents.ForwardEvent.class, listener, CalendarComponentEvents.ForwardHandler.forwardMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.BackwardHandler listener) {
        this.setHandler("backward", CalendarComponentEvents.BackwardEvent.class, listener, CalendarComponentEvents.BackwardHandler.backwardMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.DateClickHandler listener) {
        this.setHandler("dateClick", CalendarComponentEvents.DateClickEvent.class, listener, CalendarComponentEvents.DateClickHandler.dateClickMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.EventClickHandler listener) {
        this.setHandler("eventClick", CalendarComponentEvents.EventClick.class, listener, CalendarComponentEvents.EventClickHandler.eventClickMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.WeekClickHandler listener) {
        this.setHandler("weekClick", CalendarComponentEvents.WeekClick.class, listener, CalendarComponentEvents.WeekClickHandler.weekClickMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.EventResizeHandler listener) {
        this.setHandler("eventResize", CalendarComponentEvents.EventResize.class, listener, CalendarComponentEvents.EventResizeHandler.eventResizeMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.RangeSelectHandler listener) {
        this.setHandler("rangeSelect", CalendarComponentEvents.RangeSelectEvent.class, listener, CalendarComponentEvents.RangeSelectHandler.rangeSelectMethod);
    }

    @Override
    public void setHandler(CalendarComponentEvents.EventMoveHandler listener) {
        this.setHandler("eventMove", CalendarComponentEvents.MoveEvent.class, listener, CalendarComponentEvents.EventMoveHandler.eventMoveMethod);
    }

    @Override
    public EventListener getHandler(String eventId) {
        return this.handlers.get(eventId);
    }

    public DropHandler getDropHandler() {
        return this.dropHandler;
    }

    public void setDropHandler(DropHandler dropHandler) {
        this.dropHandler = dropHandler;
    }

    public TargetDetails translateDropTargetDetails(Map<String, Object> clientVariables) {
        HashMap<String, Object> serverVariables = new HashMap<String, Object>();
        if (clientVariables.containsKey("dropSlotIndex")) {
            int slotIndex = (Integer)clientVariables.get("dropSlotIndex");
            int dayIndex = (Integer)clientVariables.get("dropDayIndex");
            this.currentCalendar.setTime(Calendar.getStartOfDay(this.currentCalendar, this.startDate));
            this.currentCalendar.add(5, dayIndex);
            this.currentCalendar.add(12, slotIndex * 30);
            serverVariables.put("dropTime", this.currentCalendar.getTime());
        } else {
            int dayIndex = (Integer)clientVariables.get("dropDayIndex");
            this.currentCalendar.setTime(this.expandStartDate(this.startDate, true));
            this.currentCalendar.add(5, dayIndex);
            serverVariables.put("dropDay", this.currentCalendar.getTime());
        }
        serverVariables.put("mouseEvent", clientVariables.get("mouseEvent"));
        CalendarTargetDetails td = new CalendarTargetDetails(serverVariables, this);
        td.setHasDropTime(clientVariables.containsKey("dropSlotIndex"));
        return td;
    }

    public void setContainerDataSource(Container.Indexed container) {
        ContainerEventProvider provider = new ContainerEventProvider(container);
        provider.addEventSetChangeListener(new CalendarEventProvider.EventSetChangeListener(){

            @Override
            public void eventSetChange(CalendarEventProvider.EventSetChangeEvent changeEvent) {
                Calendar.this.markAsDirty();
            }
        });
        provider.addEventChangeListener(new CalendarEvent.EventChangeListener(){

            @Override
            public void eventChange(CalendarEvent.EventChangeEvent changeEvent) {
                Calendar.this.markAsDirty();
            }
        });
        this.setEventProvider(provider);
    }

    public void setContainerDataSource(Container.Indexed container, Object captionProperty, Object descriptionProperty, Object startDateProperty, Object endDateProperty, Object styleNameProperty) {
        ContainerEventProvider provider = new ContainerEventProvider(container);
        provider.setCaptionProperty(captionProperty);
        provider.setDescriptionProperty(descriptionProperty);
        provider.setStartDateProperty(startDateProperty);
        provider.setEndDateProperty(endDateProperty);
        provider.setStyleNameProperty(styleNameProperty);
        provider.addEventSetChangeListener(new CalendarEventProvider.EventSetChangeListener(){

            @Override
            public void eventSetChange(CalendarEventProvider.EventSetChangeEvent changeEvent) {
                Calendar.this.markAsDirty();
            }
        });
        provider.addEventChangeListener(new CalendarEvent.EventChangeListener(){

            @Override
            public void eventChange(CalendarEvent.EventChangeEvent changeEvent) {
                Calendar.this.markAsDirty();
            }
        });
        this.setEventProvider(provider);
    }

    @Override
    public List<CalendarEvent> getEvents(Date startDate, Date endDate) {
        List<CalendarEvent> events = this.getEventProvider().getEvents(startDate, endDate);
        this.cacheMinMaxTimeOfDay(events);
        return events;
    }

    @Override
    public void addEvent(CalendarEvent event) {
        if (!(this.getEventProvider() instanceof CalendarEditableEventProvider)) {
            throw new UnsupportedOperationException("Event provider does not support adding events");
        }
        CalendarEditableEventProvider provider = (CalendarEditableEventProvider)this.getEventProvider();
        provider.addEvent(event);
        this.markAsDirty();
    }

    @Override
    public void removeEvent(CalendarEvent event) {
        if (!(this.getEventProvider() instanceof CalendarEditableEventProvider)) {
            throw new UnsupportedOperationException("Event provider does not support removing events");
        }
        CalendarEditableEventProvider provider = (CalendarEditableEventProvider)this.getEventProvider();
        provider.removeEvent(event);
        this.markAsDirty();
    }

    public void addActionHandler(Action.Handler actionHandler) {
        if (actionHandler != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new LinkedList();
                this.actionMapper = new KeyMapper();
            }
            if (!this.actionHandlers.contains(actionHandler)) {
                this.actionHandlers.add(actionHandler);
                this.markAsDirty();
            }
        }
    }

    public boolean isMonthlyMode() {
        CalendarState state = this.getState(false);
        if (state.days != null) {
            return state.days.size() > 7;
        }
        return true;
    }

    public void removeActionHandler(Action.Handler actionHandler) {
        if (this.actionHandlers != null && this.actionHandlers.contains(actionHandler)) {
            this.actionHandlers.remove(actionHandler);
            if (this.actionHandlers.isEmpty()) {
                this.actionHandlers = null;
                this.actionMapper = null;
            }
            this.markAsDirty();
        }
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
    }

    public void paintContent(PaintTarget target) throws PaintException {
        if (this.dropHandler != null) {
            this.dropHandler.getAcceptCriterion().paint(target);
        }
    }

    public void setEventCaptionAsHtml(boolean eventCaptionAsHtml) {
        this.getState().eventCaptionAsHtml = eventCaptionAsHtml;
    }

    public boolean isEventCaptionAsHtml() {
        return this.getState((boolean)false).eventCaptionAsHtml;
    }

    @Override
    public void readDesign(Element design, DesignContext designContext) {
        super.readDesign(design, designContext);
        Attributes attr = design.attributes();
        if (design.hasAttr("time-format")) {
            this.setTimeFormat(TimeFormat.valueOf("Format" + design.attr("time-format").toUpperCase(Locale.ROOT)));
        }
        if (design.hasAttr("start-date")) {
            this.setStartDate((Date)DesignAttributeHandler.readAttribute((String)"start-date", (Attributes)attr, Date.class));
        }
        if (design.hasAttr("end-date")) {
            this.setEndDate((Date)DesignAttributeHandler.readAttribute((String)"end-date", (Attributes)attr, Date.class));
        }
    }

    @Override
    public void writeDesign(Element design, DesignContext designContext) {
        super.writeDesign(design, designContext);
        if (this.currentTimeFormat != null) {
            design.attr("time-format", this.currentTimeFormat == TimeFormat.Format12H ? "12h" : "24h");
        }
        if (this.startDate != null) {
            design.attr("start-date", this.df_date.format(this.getStartDate()));
        }
        if (this.endDate != null) {
            design.attr("end-date", this.df_date.format(this.getEndDate()));
        }
        if (!this.getTimeZone().equals(TimeZone.getDefault())) {
            design.attr("time-zone", this.getTimeZone().getID());
        }
    }

    protected Collection<String> getCustomAttributes() {
        Collection customAttributes = super.getCustomAttributes();
        customAttributes.add("time-format");
        customAttributes.add("start-date");
        customAttributes.add("end-date");
        return customAttributes;
    }

    public void setFirstDayOfWeek(Integer dayOfWeek) {
        int minimalSupported = 1;
        int maximalSupported = 7;
        if (dayOfWeek != null && (dayOfWeek < minimalSupported || dayOfWeek > maximalSupported)) {
            throw new IllegalArgumentException(String.format("Day of week must be between %s and %s. Actually received: %s", minimalSupported, maximalSupported, dayOfWeek));
        }
        this.customFirstDayOfWeek = dayOfWeek;
        this.markAsDirty();
    }

    private class CalendarServerRpcImpl
    implements CalendarServerRpc {
        private CalendarServerRpcImpl() {
        }

        public void eventMove(int eventIndex, String newDate) {
            if (!Calendar.this.isClientChangeAllowed()) {
                return;
            }
            if (newDate != null) {
                try {
                    Date d = Calendar.this.df_date_time.parse(newDate);
                    if (eventIndex >= 0 && eventIndex < Calendar.this.events.size() && Calendar.this.events.get(eventIndex) != null) {
                        Calendar.this.fireEventMove(eventIndex, d);
                    }
                }
                catch (ParseException e) {
                    Calendar.this.getLogger().log(Level.WARNING, e.getMessage());
                }
            }
        }

        public void rangeSelect(String range) {
            String[] dates;
            if (!Calendar.this.isClientChangeAllowed()) {
                return;
            }
            if (range != null && range.length() > 14 && range.contains("TO")) {
                String[] dates2 = range.split("TO");
                try {
                    Date d1 = Calendar.this.df_date.parse(dates2[0]);
                    Date d2 = Calendar.this.df_date.parse(dates2[1]);
                    Calendar.this.fireRangeSelect(d1, d2, true);
                }
                catch (ParseException d1) {}
            } else if (range != null && range.length() > 12 && range.contains(":") && (dates = range.split(":")).length == 3) {
                try {
                    Date d = Calendar.this.df_date.parse(dates[0]);
                    Calendar.this.currentCalendar.setTime(d);
                    int startMinutes = Integer.parseInt(dates[1]);
                    int endMinutes = Integer.parseInt(dates[2]);
                    Calendar.this.currentCalendar.add(12, startMinutes);
                    Date start = Calendar.this.currentCalendar.getTime();
                    Calendar.this.currentCalendar.add(12, endMinutes - startMinutes);
                    Date end = Calendar.this.currentCalendar.getTime();
                    Calendar.this.fireRangeSelect(start, end, false);
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void forward() {
            Calendar.this.fireEvent((EventObject)((Object)new CalendarComponentEvents.ForwardEvent(Calendar.this)));
        }

        public void backward() {
            Calendar.this.fireEvent((EventObject)((Object)new CalendarComponentEvents.BackwardEvent(Calendar.this)));
        }

        public void dateClick(String date) {
            if (date != null && date.length() > 6) {
                try {
                    Date d = Calendar.this.df_date.parse(date);
                    Calendar.this.fireDateClick(d);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }

        public void weekClick(String event) {
            String[] splitted;
            if (!event.isEmpty() && event.contains("w") && (splitted = event.split("w")).length == 2) {
                try {
                    int yr = Integer.parseInt(splitted[0]);
                    int week = Integer.parseInt(splitted[1]);
                    Calendar.this.fireWeekClick(week, yr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void eventClick(int eventIndex) {
            if (!Calendar.this.isEventClickAllowed()) {
                return;
            }
            if (eventIndex >= 0 && eventIndex < Calendar.this.events.size() && Calendar.this.events.get(eventIndex) != null) {
                Calendar.this.fireEventClick(eventIndex);
            }
        }

        public void eventResize(int eventIndex, String newStartDate, String newEndDate) {
            if (!Calendar.this.isClientChangeAllowed()) {
                return;
            }
            if (newStartDate != null && !"".equals(newStartDate) && newEndDate != null && !"".equals(newEndDate)) {
                try {
                    Date newStartTime = Calendar.this.df_date_time.parse(newStartDate);
                    Date newEndTime = Calendar.this.df_date_time.parse(newEndDate);
                    Calendar.this.fireEventResize(eventIndex, newStartTime, newEndTime);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }

        public void scroll(int scrollPosition) {
            Calendar.this.scrollTop = scrollPosition;
            Calendar.this.markAsDirty();
        }

        public void actionOnEmptyCell(String actionKey, String startDate, String endDate) {
            Action action = (Action)Calendar.this.actionMapper.get(actionKey);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatter.setTimeZone(Calendar.this.getTimeZone());
            try {
                Date start = formatter.parse(startDate);
                for (Action.Handler ah : Calendar.this.actionHandlers) {
                    ah.handleAction(action, (Object)Calendar.this, (Object)start);
                }
            }
            catch (ParseException e) {
                Calendar.this.getLogger().log(Level.WARNING, "Could not parse action date string");
            }
        }

        public void actionOnEvent(String actionKey, String startDate, String endDate, int eventIndex) {
            Action action = (Action)Calendar.this.actionMapper.get(actionKey);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatter.setTimeZone(Calendar.this.getTimeZone());
            for (Action.Handler ah : Calendar.this.actionHandlers) {
                ah.handleAction(action, (Object)Calendar.this, (Object)Calendar.this.events.get(eventIndex));
            }
        }
    }

    @Deprecated
    public static enum TimeFormat {
        Format12H,
        Format24H;

    }
}

