/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer.query;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.sqlcontainer.RowItem;
import com.vaadin.v7.data.util.sqlcontainer.connection.JDBCConnectionPool;
import com.vaadin.v7.data.util.sqlcontainer.query.AbstractTransactionalQuery;
import com.vaadin.v7.data.util.sqlcontainer.query.FreeformQueryDelegate;
import com.vaadin.v7.data.util.sqlcontainer.query.FreeformStatementDelegate;
import com.vaadin.v7.data.util.sqlcontainer.query.OrderBy;
import com.vaadin.v7.data.util.sqlcontainer.query.QueryDelegate;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.StatementHelper;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.filter.QueryBuilder;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Deprecated
public class FreeformQuery
extends AbstractTransactionalQuery
implements QueryDelegate {
    FreeformQueryDelegate delegate = null;
    private String queryString;
    private List<String> primaryKeyColumns;

    private FreeformQuery() {
    }

    @Deprecated
    public FreeformQuery(String queryString, List<String> primaryKeyColumns, JDBCConnectionPool connectionPool) {
        super(connectionPool);
        if (primaryKeyColumns == null) {
            primaryKeyColumns = new ArrayList<String>();
        }
        if (primaryKeyColumns.contains("")) {
            throw new IllegalArgumentException("The primary key columns contain an empty string!");
        }
        if (queryString == null || "".equals(queryString)) {
            throw new IllegalArgumentException("The query string may not be empty or null!");
        }
        if (connectionPool == null) {
            throw new IllegalArgumentException("The connectionPool may not be null!");
        }
        this.queryString = queryString;
        this.primaryKeyColumns = Collections.unmodifiableList(primaryKeyColumns);
    }

    public FreeformQuery(String queryString, JDBCConnectionPool connectionPool, String ... primaryKeyColumns) {
        this(queryString, Arrays.asList(primaryKeyColumns), connectionPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() throws SQLException {
        int count = this.countByDelegate();
        if (count < 0) {
            Statement statement = null;
            ResultSet rs = null;
            Connection conn = this.getConnection();
            try {
                statement = conn.createStatement(1004, 1007);
                rs = statement.executeQuery(this.queryString);
                count = rs.last() ? rs.getRow() : 0;
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn, statement, rs);
                throw throwable;
            }
            this.releaseConnection(conn, statement, rs);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countByDelegate() throws SQLException {
        int count;
        block10: {
            int n;
            block11: {
                count = -1;
                if (this.delegate == null) {
                    return count;
                }
                if (!(this.delegate instanceof FreeformStatementDelegate)) break block11;
                try {
                    StatementHelper sh = ((FreeformStatementDelegate)this.delegate).getCountStatement();
                    PreparedStatement pstmt = null;
                    ResultSet rs = null;
                    Connection c = this.getConnection();
                    try {
                        pstmt = c.prepareStatement(sh.getQueryString());
                        sh.setParameterValuesToStatement(pstmt);
                        rs = pstmt.executeQuery();
                        count = rs.next() ? rs.getInt(1) : 0;
                    }
                    catch (Throwable throwable) {
                        this.releaseConnection(c, pstmt, rs);
                        throw throwable;
                    }
                    this.releaseConnection(c, pstmt, rs);
                    return count;
                }
                catch (UnsupportedOperationException sh) {
                    // empty catch block
                }
            }
            String countQuery = this.delegate.getCountQuery();
            if (countQuery == null) break block10;
            Statement statement = null;
            ResultSet rs = null;
            Connection conn = this.getConnection();
            try {
                statement = conn.createStatement();
                rs = statement.executeQuery(countQuery);
                count = rs.next() ? rs.getInt(1) : 0;
                n = count;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseConnection(conn, statement, rs);
                    throw throwable;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.releaseConnection(conn, statement, rs);
            return n;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResults(int offset, int pagelength) throws SQLException {
        ResultSet rs;
        this.ensureTransaction();
        String query = this.queryString;
        if (this.delegate != null) {
            if (this.delegate instanceof FreeformStatementDelegate) {
                try {
                    StatementHelper sh = ((FreeformStatementDelegate)this.delegate).getQueryStatement(offset, pagelength);
                    PreparedStatement pstmt = this.getConnection().prepareStatement(sh.getQueryString());
                    sh.setParameterValuesToStatement(pstmt);
                    return pstmt.executeQuery();
                }
                catch (UnsupportedOperationException sh) {
                    // empty catch block
                }
            }
            try {
                query = this.delegate.getQueryString(offset, pagelength);
            }
            catch (UnsupportedOperationException sh) {
                // empty catch block
            }
        }
        Statement statement = this.getConnection().createStatement();
        try {
            rs = statement.executeQuery(query);
        }
        catch (SQLException e) {
            try {
                statement.close();
            }
            finally {
                throw e;
            }
        }
        return rs;
    }

    @Override
    public boolean implementationRespectsPagingLimits() {
        if (this.delegate == null) {
            return false;
        }
        if (this.delegate instanceof FreeformStatementDelegate) {
            try {
                StatementHelper sh = ((FreeformStatementDelegate)this.delegate).getCountStatement();
                if (sh != null && sh.getQueryString() != null && !sh.getQueryString().isEmpty()) {
                    return true;
                }
            }
            catch (UnsupportedOperationException sh) {
                // empty catch block
            }
        }
        try {
            String queryString = this.delegate.getQueryString(0, 50);
            return queryString != null && !queryString.isEmpty();
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @Override
    public void setFilters(List<Container.Filter> filters) throws UnsupportedOperationException {
        if (this.delegate != null) {
            this.delegate.setFilters(filters);
        } else if (filters != null) {
            throw new UnsupportedOperationException("FreeFormQueryDelegate not set!");
        }
    }

    @Override
    public void setOrderBy(List<OrderBy> orderBys) throws UnsupportedOperationException {
        if (this.delegate != null) {
            this.delegate.setOrderBy(orderBys);
        } else if (orderBys != null) {
            throw new UnsupportedOperationException("FreeFormQueryDelegate not set!");
        }
    }

    @Override
    public int storeRow(RowItem row) throws SQLException {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("No transaction is active!");
        }
        if (this.primaryKeyColumns.isEmpty()) {
            throw new UnsupportedOperationException("Cannot store items fetched with a read-only freeform query!");
        }
        if (this.delegate != null) {
            return this.delegate.storeRow(this.getConnection(), row);
        }
        throw new UnsupportedOperationException("FreeFormQueryDelegate not set!");
    }

    @Override
    public boolean removeRow(RowItem row) throws SQLException {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("No transaction is active!");
        }
        if (this.primaryKeyColumns.isEmpty()) {
            throw new UnsupportedOperationException("Cannot remove items fetched with a read-only freeform query!");
        }
        if (this.delegate != null) {
            return this.delegate.removeRow(this.getConnection(), row);
        }
        throw new UnsupportedOperationException("FreeFormQueryDelegate not set!");
    }

    @Override
    public synchronized void beginTransaction() throws UnsupportedOperationException, SQLException {
        super.beginTransaction();
    }

    @Override
    public synchronized void commit() throws UnsupportedOperationException, SQLException {
        super.commit();
    }

    @Override
    public synchronized void rollback() throws UnsupportedOperationException, SQLException {
        super.rollback();
    }

    @Override
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public FreeformQueryDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(FreeformQueryDelegate delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsRowWithKey(Object ... keys) throws SQLException {
        String query = null;
        boolean contains = false;
        if (this.delegate != null) {
            if (this.delegate instanceof FreeformStatementDelegate) {
                boolean bl;
                StatementHelper sh2 = ((FreeformStatementDelegate)this.delegate).getContainsRowQueryStatement(keys);
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                Connection c = this.getConnection();
                try {
                    pstmt = c.prepareStatement(sh2.getQueryString());
                    sh2.setParameterValuesToStatement(pstmt);
                    rs = pstmt.executeQuery();
                    bl = contains = rs.next();
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseConnection(c, pstmt, rs);
                        throw throwable;
                    }
                    catch (UnsupportedOperationException sh2) {
                        // empty catch block
                    }
                }
                this.releaseConnection(c, pstmt, rs);
                return bl;
            }
            try {
                query = this.delegate.getContainsRowQueryString(keys);
            }
            catch (UnsupportedOperationException e) {
                query = this.modifyWhereClause(keys);
            }
        } else {
            query = this.modifyWhereClause(keys);
        }
        Statement statement = null;
        ResultSet rs = null;
        Connection conn = this.getConnection();
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(query);
            contains = rs.next();
        }
        finally {
            this.releaseConnection(conn, statement, rs);
        }
        return contains;
    }

    private String modifyWhereClause(Object ... keys) {
        StringBuilder where = new StringBuilder();
        for (int ix = 0; ix < this.primaryKeyColumns.size(); ++ix) {
            where.append(QueryBuilder.quote(this.primaryKeyColumns.get(ix)));
            if (keys[ix] == null) {
                where.append(" IS NULL");
            } else {
                where.append(" = '").append(keys[ix]).append('\'');
            }
            if (ix >= this.primaryKeyColumns.size() - 1) continue;
            where.append(" AND ");
        }
        int index = this.queryString.toLowerCase(Locale.ROOT).indexOf("where ");
        if (index > -1) {
            return this.queryString.substring(0, index) + "WHERE " + where + " AND " + this.queryString.substring(index + 6);
        }
        return this.queryString + " WHERE " + where;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        out.defaultWriteObject();
    }
}

