/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

@Deprecated
public class TextFileProperty
extends AbstractProperty<String> {
    private File file;
    private Charset charset = null;

    public TextFileProperty(File file) {
        this.file = file;
    }

    public TextFileProperty(File file, Charset charset) {
        this.file = file;
        this.charset = charset;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String getValue() {
        if (this.file == null) {
            return null;
        }
        try {
            int len;
            FileInputStream fis = new FileInputStream(this.file);
            InputStreamReader isr = this.charset == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.charset);
            BufferedReader r = new BufferedReader(isr);
            StringBuilder b = new StringBuilder();
            char[] buf = new char[8192];
            while ((len = r.read(buf)) != -1) {
                b.append(buf, 0, len);
            }
            r.close();
            isr.close();
            fis.close();
            return b.toString();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.file == null || super.isReadOnly() || !this.file.canWrite();
    }

    @Override
    public void setValue(String newValue) throws Property.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new Property.ReadOnlyException();
        }
        if (this.file == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            OutputStreamWriter osw = this.charset == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, this.charset);
            BufferedWriter w = new BufferedWriter(osw);
            w.append(newValue.toString());
            w.flush();
            w.close();
            osw.close();
            fos.close();
            this.fireValueChange();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

