/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.Resource;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import com.vaadin.v7.data.Collapsible;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.ContainerHierarchicalWrapper;
import com.vaadin.v7.data.util.HierarchicalContainer;
import com.vaadin.v7.data.util.HierarchicalContainerOrderedWrapper;
import com.vaadin.v7.shared.ui.treetable.TreeTableState;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.Tree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public class TreeTable
extends Table
implements Container.Hierarchical {
    private ContainerStrategy cStrategy;
    private Object focusedRowId = null;
    private Object hierarchyColumnId;
    private Object toggledItemId;
    private boolean animationsEnabled;
    private boolean clearFocusedRowPending;
    private boolean containerSupportsPartialUpdates;

    public TreeTable() {
        super(null, new HierarchicalContainer());
    }

    public TreeTable(String caption) {
        this();
        this.setCaption(caption);
    }

    public TreeTable(String caption, Container dataSource) {
        super(caption, dataSource);
    }

    private ContainerStrategy getContainerStrategy() {
        if (this.cStrategy == null) {
            this.cStrategy = this.getContainerDataSource() instanceof Collapsible ? new CollapsibleStrategy() : new HierarchicalStrategy();
        }
        return this.cStrategy;
    }

    @Override
    protected void paintRowAttributes(PaintTarget target, Object itemId) throws PaintException {
        super.paintRowAttributes(target, itemId);
        target.addAttribute("depth", this.getContainerStrategy().getDepth(itemId));
        if (this.getContainerDataSource().areChildrenAllowed(itemId)) {
            target.addAttribute("ca", true);
            target.addAttribute("open", this.getContainerStrategy().isNodeOpen(itemId));
        }
    }

    @Override
    protected void paintRowIcon(PaintTarget target, Object[][] cells, int indexInRowbuffer) throws PaintException {
        if (this.getRowHeaderMode() == ROW_HEADER_MODE_HIDDEN) {
            Resource itemIcon = this.getItemIcon(cells[3][indexInRowbuffer]);
            if (itemIcon != null) {
                target.addAttribute("icon", itemIcon);
            }
        } else if (cells[2][indexInRowbuffer] != null) {
            target.addAttribute("icon", (Resource)cells[2][indexInRowbuffer]);
        }
    }

    @Override
    protected boolean rowHeadersAreEnabled() {
        if (this.getRowHeaderMode() == Table.RowHeaderMode.ICON_ONLY) {
            return false;
        }
        return super.rowHeadersAreEnabled();
    }

    @Override
    public void changeVariables(Object source, Map<String, Object> variables) {
        super.changeVariables(source, variables);
        if (variables.containsKey("toggleCollapsed")) {
            Object itemId;
            String object = (String)variables.get("toggleCollapsed");
            this.toggledItemId = itemId = this.itemIdMapper.get(object);
            this.toggleChildVisibility(itemId, false);
            if (variables.containsKey("selectCollapsed") && this.isSelectable()) {
                this.select(itemId);
            }
        } else if (variables.containsKey("focusParent")) {
            String key = (String)variables.get("focusParent");
            Object refId = this.itemIdMapper.get(key);
            Object itemId = this.getParent(refId);
            this.focusParent(itemId);
        }
    }

    private void focusParent(Object itemId) {
        boolean inView = false;
        Object inPageId = this.getCurrentPageFirstItemId();
        for (int i = 0; inPageId != null && i < this.getPageLength(); ++i) {
            if (inPageId.equals(itemId)) {
                inView = true;
                break;
            }
            inPageId = this.nextItemId(inPageId);
            ++i;
        }
        if (!inView) {
            this.setCurrentPageFirstItemId(itemId);
        }
        if (this.isSelectable()) {
            if (this.isMultiSelect()) {
                this.setValue(Collections.singleton(itemId));
            } else {
                this.setValue(itemId);
            }
        }
        this.setFocusedRow(itemId);
    }

    private void setFocusedRow(Object itemId) {
        this.focusedRowId = itemId;
        if (this.focusedRowId == null) {
            this.clearFocusedRowPending = true;
        }
        this.markAsDirty();
    }

    @Override
    public void paintContent(PaintTarget target) throws PaintException {
        if (this.focusedRowId != null) {
            target.addAttribute("focusedRow", this.itemIdMapper.key(this.focusedRowId));
            this.focusedRowId = null;
        } else if (this.clearFocusedRowPending) {
            target.addAttribute("clearFocusPending", true);
            this.clearFocusedRowPending = false;
        }
        target.addAttribute("animate", this.animationsEnabled);
        if (this.hierarchyColumnId != null) {
            Object[] visibleColumns2 = this.getVisibleColumns();
            for (int i = 0; i < visibleColumns2.length; ++i) {
                Object object = visibleColumns2[i];
                if (!this.hierarchyColumnId.equals(object)) continue;
                target.addAttribute("hci", i);
                break;
            }
        }
        super.paintContent(target);
        this.toggledItemId = null;
    }

    @Override
    protected boolean isPartialRowUpdate() {
        return this.toggledItemId != null && this.containerSupportsPartialUpdates && !this.isRowCacheInvalidated();
    }

    @Override
    protected int getFirstAddedItemIndex() {
        return this.indexOfId(this.toggledItemId) + 1;
    }

    @Override
    protected int getAddedRowCount() {
        return this.countSubNodesRecursively(this.getContainerDataSource(), this.toggledItemId);
    }

    private int countSubNodesRecursively(Container.Hierarchical hc, Object itemId) {
        Collection<?> children;
        int count = 0;
        if ((this.getContainerStrategy().isNodeOpen(itemId) || itemId == this.toggledItemId) && (children = hc.getChildren(itemId)) != null) {
            count += children != null ? children.size() : 0;
            for (Object id : children) {
                count += this.countSubNodesRecursively(hc, id);
            }
        }
        return count;
    }

    @Override
    protected int getFirstUpdatedItemIndex() {
        return this.indexOfId(this.toggledItemId);
    }

    @Override
    protected int getUpdatedRowCount() {
        return 1;
    }

    @Override
    protected boolean shouldHideAddedRows() {
        return !this.getContainerStrategy().isNodeOpen(this.toggledItemId);
    }

    private void toggleChildVisibility(Object itemId, boolean forceFullRefresh) {
        this.getContainerStrategy().toggleChildVisibility(itemId);
        this.setCurrentPageFirstItemIndex(this.getCurrentPageFirstItemIndex(), false);
        if (this.isCollapsed(itemId)) {
            this.fireCollapseEvent(itemId);
        } else {
            this.fireExpandEvent(itemId);
        }
        if (this.containerSupportsPartialUpdates && !forceFullRefresh) {
            this.markAsDirty();
        } else {
            this.refreshRowCache();
        }
    }

    @Override
    public int size() {
        return this.getContainerStrategy().size();
    }

    @Override
    public Container.Hierarchical getContainerDataSource() {
        return (Container.Hierarchical)super.getContainerDataSource();
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        this.cStrategy = null;
        if (newDataSource instanceof Container.ItemSetChangeNotifier) {
            // empty if block
        }
        this.containerSupportsPartialUpdates = false;
        if (newDataSource != null && !(newDataSource instanceof Container.Hierarchical)) {
            newDataSource = new ContainerHierarchicalWrapper(newDataSource);
        }
        if (newDataSource != null && !(newDataSource instanceof Container.Ordered)) {
            newDataSource = new HierarchicalContainerOrderedWrapper((Container.Hierarchical)newDataSource);
        }
        super.setContainerDataSource(newDataSource);
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.toggledItemId = null;
        this.getContainerStrategy().containerItemSetChange(event);
        super.containerItemSetChange(event);
    }

    @Override
    protected Object getIdByIndex(int index) {
        return this.getContainerStrategy().getIdByIndex(index);
    }

    @Override
    protected int indexOfId(Object itemId) {
        return this.getContainerStrategy().indexOfId(itemId);
    }

    @Override
    public Object nextItemId(Object itemId) {
        return this.getContainerStrategy().nextItemId(itemId);
    }

    @Override
    public Object lastItemId() {
        return this.getContainerStrategy().lastItemId();
    }

    @Override
    public Object prevItemId(Object itemId) {
        return this.getContainerStrategy().prevItemId(itemId);
    }

    @Override
    public boolean isLastId(Object itemId) {
        return this.getContainerStrategy().isLastId(itemId);
    }

    @Override
    public Collection<?> getItemIds() {
        return this.getContainerStrategy().getItemIds();
    }

    @Override
    public boolean areChildrenAllowed(Object itemId) {
        return this.getContainerDataSource().areChildrenAllowed(itemId);
    }

    @Override
    public Collection<?> getChildren(Object itemId) {
        return this.getContainerDataSource().getChildren(itemId);
    }

    @Override
    public Object getParent(Object itemId) {
        return this.getContainerDataSource().getParent(itemId);
    }

    @Override
    public boolean hasChildren(Object itemId) {
        return this.getContainerDataSource().hasChildren(itemId);
    }

    @Override
    public boolean isRoot(Object itemId) {
        return this.getContainerDataSource().isRoot(itemId);
    }

    @Override
    public Collection<?> rootItemIds() {
        return this.getContainerDataSource().rootItemIds();
    }

    @Override
    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        return this.getContainerDataSource().setChildrenAllowed(itemId, areChildrenAllowed);
    }

    @Override
    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        return this.getContainerDataSource().setParent(itemId, newParentId);
    }

    public void setCollapsed(Object itemId, boolean collapsed) {
        if (this.isCollapsed(itemId) != collapsed) {
            if (null == this.toggledItemId && !this.isRowCacheInvalidated() && this.getVisibleItemIds().contains(itemId)) {
                this.toggledItemId = itemId;
                this.toggleChildVisibility(itemId, false);
            } else {
                this.toggledItemId = null;
                this.toggleChildVisibility(itemId, true);
            }
        }
    }

    public boolean isCollapsed(Object itemId) {
        return !this.getContainerStrategy().isNodeOpen(itemId);
    }

    public void setHierarchyColumn(Object hierarchyColumnId) {
        this.hierarchyColumnId = hierarchyColumnId;
    }

    public Object getHierarchyColumnId() {
        return this.hierarchyColumnId;
    }

    public void addExpandListener(Tree.ExpandListener listener) {
        this.addListener(Tree.ExpandEvent.class, listener, Tree.ExpandListener.EXPAND_METHOD);
    }

    @Deprecated
    public void addListener(Tree.ExpandListener listener) {
        this.addExpandListener(listener);
    }

    public void removeExpandListener(Tree.ExpandListener listener) {
        this.removeListener(Tree.ExpandEvent.class, listener, Tree.ExpandListener.EXPAND_METHOD);
    }

    @Deprecated
    public void removeListener(Tree.ExpandListener listener) {
        this.removeExpandListener(listener);
    }

    protected void fireExpandEvent(Object itemId) {
        this.fireEvent((EventObject)((Object)new Tree.ExpandEvent(this, itemId)));
    }

    public void addCollapseListener(Tree.CollapseListener listener) {
        this.addListener(Tree.CollapseEvent.class, listener, Tree.CollapseListener.COLLAPSE_METHOD);
    }

    @Deprecated
    public void addListener(Tree.CollapseListener listener) {
        this.addCollapseListener(listener);
    }

    public void removeCollapseListener(Tree.CollapseListener listener) {
        this.removeListener(Tree.CollapseEvent.class, listener, Tree.CollapseListener.COLLAPSE_METHOD);
    }

    @Deprecated
    public void removeListener(Tree.CollapseListener listener) {
        this.removeCollapseListener(listener);
    }

    protected void fireCollapseEvent(Object itemId) {
        this.fireEvent((EventObject)((Object)new Tree.CollapseEvent(this, itemId)));
    }

    public boolean isAnimationsEnabled() {
        return this.animationsEnabled;
    }

    public void setAnimationsEnabled(boolean animationsEnabled) {
        this.animationsEnabled = animationsEnabled;
        this.markAsDirty();
    }

    private static final Logger getLogger() {
        return Logger.getLogger(TreeTable.class.getName());
    }

    @Override
    protected List<Object> getItemIds(int firstIndex, int rows) {
        ArrayList<Object> itemIds = new ArrayList<Object>();
        for (int i = firstIndex; i < firstIndex + rows; ++i) {
            itemIds.add(this.getIdByIndex(i));
        }
        return itemIds;
    }

    @Override
    protected void readBody(Element design, DesignContext context) {
        Element tbody = design.select("> table > tbody").first();
        if (tbody == null) {
            return;
        }
        HashSet<String> selected = new HashSet<String>();
        Stack<Object> parents = new Stack<Object>();
        int lastDepth = -1;
        for (Element tr : tbody.children()) {
            int depth = (Integer)DesignAttributeHandler.readAttribute((String)"depth", (Attributes)tr.attributes(), (Object)0, Integer.TYPE);
            if (depth < 0 || depth > lastDepth + 1) {
                throw new DesignException("Malformed TreeTable item hierarchy at " + tr + ": last depth was " + lastDepth);
            }
            if (depth <= lastDepth) {
                for (int d = depth; d <= lastDepth; ++d) {
                    parents.pop();
                }
            }
            Object itemId = this.readItem(tr, selected, context);
            this.setParent(itemId, !parents.isEmpty() ? parents.peek() : null);
            parents.push(itemId);
            lastDepth = depth;
        }
    }

    @Override
    protected Object readItem(Element tr, Set<String> selected, DesignContext context) {
        Object itemId = super.readItem(tr, selected, context);
        if (tr.hasAttr("collapsed")) {
            boolean collapsed = (Boolean)DesignAttributeHandler.readAttribute((String)"collapsed", (Attributes)tr.attributes(), Boolean.TYPE);
            this.setCollapsed(itemId, collapsed);
        }
        return itemId;
    }

    @Override
    protected void writeItems(Element design, DesignContext context) {
        if (this.getVisibleColumns().length == 0) {
            return;
        }
        Element tbody = design.child(0).appendElement("tbody");
        this.writeItems(tbody, this.rootItemIds(), 0, context);
    }

    protected void writeItems(Element tbody, Collection<?> itemIds, int depth, DesignContext context) {
        for (Object itemId : itemIds) {
            Element tr = this.writeItem(tbody, itemId, context);
            DesignAttributeHandler.writeAttribute((String)"depth", (Attributes)tr.attributes(), (Object)depth, (Object)0, Integer.TYPE, (DesignContext)context);
            if (this.getChildren(itemId) == null) continue;
            this.writeItems(tbody, this.getChildren(itemId), depth + 1, context);
        }
    }

    @Override
    protected Element writeItem(Element tbody, Object itemId, DesignContext context) {
        Element tr = super.writeItem(tbody, itemId, context);
        DesignAttributeHandler.writeAttribute((String)"collapsed", (Attributes)tr.attributes(), (Object)this.isCollapsed(itemId), (Object)true, Boolean.TYPE, (DesignContext)context);
        return tr;
    }

    protected TreeTableState getState() {
        return (TreeTableState)super.getState();
    }

    private class HierarchicalStrategy
    extends AbstractStrategy {
        private final HashSet<Object> openItems;
        List<Object> preOrder;

        private HierarchicalStrategy() {
            this.openItems = new HashSet();
        }

        @Override
        public boolean isNodeOpen(Object itemId) {
            return this.openItems.contains(itemId);
        }

        @Override
        public int size() {
            return this.getPreOrder().size();
        }

        public Collection<Object> getItemIds() {
            return Collections.unmodifiableCollection(this.getPreOrder());
        }

        @Override
        public boolean isLastId(Object itemId) {
            if (itemId == null) {
                return false;
            }
            return itemId.equals(this.lastItemId());
        }

        @Override
        public Object lastItemId() {
            if (this.getPreOrder().size() > 0) {
                return this.getPreOrder().get(this.getPreOrder().size() - 1);
            }
            return null;
        }

        @Override
        public Object nextItemId(Object itemId) {
            int indexOf = this.getPreOrder().indexOf(itemId);
            if (indexOf == -1) {
                return null;
            }
            if (++indexOf == this.getPreOrder().size()) {
                return null;
            }
            return this.getPreOrder().get(indexOf);
        }

        @Override
        public Object prevItemId(Object itemId) {
            int indexOf = this.getPreOrder().indexOf(itemId);
            if (--indexOf < 0) {
                return null;
            }
            return this.getPreOrder().get(indexOf);
        }

        @Override
        public void toggleChildVisibility(Object itemId) {
            boolean removed = this.openItems.remove(itemId);
            if (!removed) {
                this.openItems.add(itemId);
                TreeTable.getLogger().log(Level.FINEST, "Item {0} is now expanded", itemId);
            } else {
                TreeTable.getLogger().log(Level.FINEST, "Item {0} is now collapsed", itemId);
            }
            this.clearPreorderCache();
        }

        private void clearPreorderCache() {
            this.preOrder = null;
        }

        private List<Object> getPreOrder() {
            if (this.preOrder == null) {
                this.preOrder = new ArrayList<Object>();
                Collection<?> rootItemIds = TreeTable.this.getContainerDataSource().rootItemIds();
                for (Object id : rootItemIds) {
                    this.preOrder.add(id);
                    this.addVisibleChildTree(id);
                }
            }
            return this.preOrder;
        }

        private void addVisibleChildTree(Object id) {
            Collection<?> children;
            if (this.isNodeOpen(id) && (children = TreeTable.this.getContainerDataSource().getChildren(id)) != null) {
                for (Object childId : children) {
                    this.preOrder.add(childId);
                    this.addVisibleChildTree(childId);
                }
            }
        }

        @Override
        public int indexOfId(Object id) {
            return this.getPreOrder().indexOf(id);
        }

        @Override
        public Object getIdByIndex(int index) {
            return this.getPreOrder().get(index);
        }

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
            this.clearPreorderCache();
            super.containerItemSetChange(event);
        }
    }

    private class CollapsibleStrategy
    extends AbstractStrategy {
        private CollapsibleStrategy() {
        }

        private Collapsible c() {
            return (Collapsible)TreeTable.this.getContainerDataSource();
        }

        @Override
        public void toggleChildVisibility(Object itemId) {
            this.c().setCollapsed(itemId, !this.c().isCollapsed(itemId));
        }

        @Override
        public boolean isNodeOpen(Object itemId) {
            return !this.c().isCollapsed(itemId);
        }

        @Override
        public int size() {
            return TreeTable.super.size();
        }

        @Override
        public Object getIdByIndex(int index) {
            return TreeTable.super.getIdByIndex(index);
        }

        @Override
        public int indexOfId(Object id) {
            return TreeTable.super.indexOfId(id);
        }

        @Override
        public boolean isLastId(Object itemId) {
            return TreeTable.super.isLastId(itemId);
        }

        @Override
        public Object lastItemId() {
            return TreeTable.super.lastItemId();
        }

        @Override
        public Object nextItemId(Object itemId) {
            return TreeTable.super.nextItemId(itemId);
        }

        @Override
        public Object prevItemId(Object itemId) {
            return TreeTable.super.prevItemId(itemId);
        }

        @Override
        public Collection<?> getItemIds() {
            return TreeTable.super.getItemIds();
        }
    }

    private abstract class AbstractStrategy
    implements ContainerStrategy {
        private AbstractStrategy() {
        }

        @Override
        public int getDepth(Object itemId) {
            int depth = 0;
            Container.Hierarchical hierarchicalContainer = TreeTable.this.getContainerDataSource();
            while (!hierarchicalContainer.isRoot(itemId)) {
                ++depth;
                itemId = hierarchicalContainer.getParent(itemId);
            }
            return depth;
        }

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        }
    }

    private static interface ContainerStrategy
    extends Serializable {
        public int size();

        public boolean isNodeOpen(Object var1);

        public int getDepth(Object var1);

        public void toggleChildVisibility(Object var1);

        public Object getIdByIndex(int var1);

        public int indexOfId(Object var1);

        public Object nextItemId(Object var1);

        public Object lastItemId();

        public Object prevItemId(Object var1);

        public boolean isLastId(Object var1);

        public Collection<?> getItemIds();

        public void containerItemSetChange(Container.ItemSetChangeEvent var1);
    }
}

