/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.colorpicker;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerGrid;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

@Deprecated
public class ColorPickerHistory
extends CustomComponent
implements ColorSelector,
ColorChangeListener {
    private static final String STYLENAME = "v-colorpicker-history";
    private static final Method COLOR_CHANGE_METHOD;
    private static final int rows = 4;
    private static final int columns = 15;
    private ArrayBlockingQueue<Color> tempHistory = new ArrayBlockingQueue(60);
    private final ColorPickerGrid grid;

    public ColorPickerHistory() {
        this.setPrimaryStyleName(STYLENAME);
        this.grid = new ColorPickerGrid(4, 15);
        this.grid.setWidth("100%");
        this.grid.setPosition(0, 0);
        this.grid.addColorChangeListener(this);
        this.setCompositionRoot((Component)this.grid);
    }

    public void attach() {
        super.attach();
        this.createColorHistoryIfNecessary();
    }

    private void createColorHistoryIfNecessary() {
        ArrayList<Color> tempColors = new ArrayList<Color>(this.tempHistory);
        if (this.getSession().getAttribute("colorPickerHistory") == null) {
            this.getSession().setAttribute("colorPickerHistory", new ArrayBlockingQueue(60));
        }
        for (Color color : tempColors) {
            this.setColor(color);
        }
        this.tempHistory.clear();
    }

    private ArrayBlockingQueue<Color> getColorHistory() {
        Object colorHistory;
        if (this.isAttached() && (colorHistory = this.getSession().getAttribute("colorPickerHistory")) instanceof ArrayBlockingQueue) {
            return (ArrayBlockingQueue)colorHistory;
        }
        return this.tempHistory;
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.grid.setHeight(height);
    }

    @Override
    public void setColor(Color color) {
        ArrayBlockingQueue<Color> colorHistory = this.getColorHistory();
        boolean exists = false;
        Iterator<Object> iter = colorHistory.iterator();
        while (iter.hasNext()) {
            if (!color.equals((Object)iter.next())) continue;
            exists = true;
            break;
        }
        if (!exists && !colorHistory.offer(color)) {
            colorHistory.poll();
            colorHistory.offer(color);
        }
        ArrayList<Color> colorList = new ArrayList<Color>(colorHistory);
        Collections.reverse(colorList);
        Collections.swap(colorList, colorList.indexOf(color), 0);
        Color[][] colors = new Color[4][15];
        iter = colorList.iterator();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 15; ++col) {
                colors[row][col] = iter.hasNext() ? (Color)iter.next() : Color.WHITE;
            }
        }
        this.grid.setColorGrid(colors);
        this.grid.markAsDirty();
    }

    @Override
    public Color getColor() {
        return this.getColorHistory().peek();
    }

    public List<Color> getHistory() {
        ArrayBlockingQueue<Color> colorHistory = this.getColorHistory();
        Color[] array = colorHistory.toArray(new Color[colorHistory.size()]);
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public boolean hasColor(Color c) {
        return this.getColorHistory().contains(c);
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.addListener(ColorChangeEvent.class, listener, COLOR_CHANGE_METHOD);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.removeListener(ColorChangeEvent.class, listener);
    }

    @Override
    public void colorChanged(ColorChangeEvent event) {
        this.fireEvent((EventObject)((Object)new ColorChangeEvent((Component)this, event.getColor())));
    }

    static {
        try {
            COLOR_CHANGE_METHOD = ColorChangeListener.class.getDeclaredMethod("colorChanged", ColorChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ColorPicker");
        }
    }
}

