/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class HierarchicalContainer
extends IndexedContainer
implements Container.Hierarchical {
    private final HashSet<Object> noChildrenAllowed = new HashSet();
    private final HashMap<Object, Object> parent = new HashMap();
    private HashMap<Object, Object> filteredParent = null;
    private final HashMap<Object, LinkedList<Object>> children = new HashMap();
    private HashMap<Object, LinkedList<Object>> filteredChildren = null;
    private final LinkedList<Object> roots = new LinkedList();
    private LinkedList<Object> filteredRoots = null;
    private boolean includeParentsWhenFiltering = true;
    private int contentChangedEventsDisabledCount = 0;
    private boolean contentsChangedEventPending;
    private Set<Object> filterOverride = null;

    @Override
    public boolean areChildrenAllowed(Object itemId) {
        if (this.noChildrenAllowed.contains(itemId)) {
            return false;
        }
        return this.containsId(itemId);
    }

    @Override
    public Collection<?> getChildren(Object itemId) {
        LinkedList<Object> c = this.filteredChildren != null ? this.filteredChildren.get(itemId) : this.children.get(itemId);
        if (c == null) {
            return null;
        }
        return Collections.unmodifiableCollection(c);
    }

    @Override
    public Object getParent(Object itemId) {
        if (this.filteredParent != null) {
            return this.filteredParent.get(itemId);
        }
        return this.parent.get(itemId);
    }

    @Override
    public boolean hasChildren(Object itemId) {
        if (this.filteredChildren != null) {
            return this.filteredChildren.containsKey(itemId);
        }
        return this.children.containsKey(itemId);
    }

    @Override
    public boolean isRoot(Object itemId) {
        if (this.filteredRoots != null ? !this.filteredRoots.contains(itemId) : this.parent.containsKey(itemId)) {
            return false;
        }
        return this.containsId(itemId);
    }

    @Override
    public Collection<?> rootItemIds() {
        if (this.filteredRoots != null) {
            return Collections.unmodifiableCollection(this.filteredRoots);
        }
        return Collections.unmodifiableCollection(this.roots);
    }

    @Override
    public boolean setChildrenAllowed(Object itemId, boolean childrenAllowed) {
        if (!this.containsId(itemId)) {
            return false;
        }
        if (childrenAllowed) {
            this.noChildrenAllowed.remove(itemId);
        } else {
            this.noChildrenAllowed.add(itemId);
        }
        return true;
    }

    @Override
    public boolean setParent(Object itemId, Object newParentId) {
        if (!this.containsId(itemId)) {
            return false;
        }
        Object oldParentId = this.parent.get(itemId);
        if (newParentId == null && oldParentId == null || newParentId != null && newParentId.equals(oldParentId)) {
            return true;
        }
        if (newParentId == null) {
            LinkedList<Object> l = this.children.get(oldParentId);
            if (l != null) {
                l.remove(itemId);
                if (l.isEmpty()) {
                    this.children.remove(oldParentId);
                }
            }
            this.roots.add(itemId);
            this.parent.remove(itemId);
            if (this.hasFilters()) {
                this.doFilterContainer(this.hasFilters());
            }
            this.fireItemSetChange();
            return true;
        }
        if (!this.containsId(newParentId) || this.noChildrenAllowed.contains(newParentId)) {
            return false;
        }
        Object o = newParentId;
        while (o != null && !o.equals(itemId)) {
            o = this.parent.get(o);
        }
        if (o != null) {
            return false;
        }
        this.parent.put(itemId, newParentId);
        LinkedList<Object> pcl = this.children.get(newParentId);
        if (pcl == null) {
            pcl = new LinkedList();
            this.children.put(newParentId, pcl);
        }
        pcl.add(itemId);
        if (oldParentId == null) {
            this.roots.remove(itemId);
        } else {
            LinkedList<Object> l = this.children.get(oldParentId);
            if (l != null) {
                l.remove(itemId);
                if (l.isEmpty()) {
                    this.children.remove(oldParentId);
                }
            }
        }
        if (this.hasFilters()) {
            this.doFilterContainer(this.hasFilters());
        }
        this.fireItemSetChange();
        return true;
    }

    private boolean hasFilters() {
        return this.filteredRoots != null;
    }

    public void moveAfterSibling(Object itemId, Object siblingId) {
        Object parent2 = this.getParent(itemId);
        LinkedList<Object> childrenList = parent2 == null ? this.roots : this.children.get(parent2);
        if (siblingId == null) {
            childrenList.remove(itemId);
            childrenList.addFirst(itemId);
        } else {
            int oldIndex = childrenList.indexOf(itemId);
            int indexOfSibling = childrenList.indexOf(siblingId);
            if (indexOfSibling != -1 && oldIndex != -1) {
                int newIndex = oldIndex > indexOfSibling ? indexOfSibling + 1 : indexOfSibling;
                childrenList.remove(oldIndex);
                childrenList.add(newIndex, itemId);
            } else {
                throw new IllegalArgumentException("Given identifiers no not have the same parent.");
            }
        }
        this.fireItemSetChange();
    }

    @Override
    public Object addItem() {
        this.disableContentsChangeEvents();
        try {
            Object itemId = super.addItem();
            if (itemId == null) {
                Object var2_2 = null;
                return var2_2;
            }
            if (!this.roots.contains(itemId)) {
                this.roots.add(itemId);
                if (this.filteredRoots != null && this.passesFilters(itemId)) {
                    this.filteredRoots.add(itemId);
                }
            }
            Object object = itemId;
            return object;
        }
        finally {
            this.enableAndFireContentsChangeEvents();
        }
    }

    @Override
    protected void fireItemSetChange(Container.ItemSetChangeEvent event) {
        if (this.contentsChangeEventsOn()) {
            super.fireItemSetChange(event);
        } else {
            this.contentsChangedEventPending = true;
        }
    }

    private boolean contentsChangeEventsOn() {
        return this.contentChangedEventsDisabledCount == 0;
    }

    private void disableContentsChangeEvents() {
        ++this.contentChangedEventsDisabledCount;
    }

    private void enableAndFireContentsChangeEvents() {
        if (this.contentChangedEventsDisabledCount <= 0) {
            HierarchicalContainer.getLogger().log(Level.WARNING, "Mismatched calls to disable and enable contents change events in HierarchicalContainer");
            this.contentChangedEventsDisabledCount = 0;
        } else {
            --this.contentChangedEventsDisabledCount;
        }
        if (this.contentChangedEventsDisabledCount == 0) {
            if (this.contentsChangedEventPending) {
                this.fireItemSetChange();
            }
            this.contentsChangedEventPending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item addItem(Object itemId) {
        this.disableContentsChangeEvents();
        try {
            Item item = super.addItem(itemId);
            if (item == null) {
                Item item2 = null;
                return item2;
            }
            this.roots.add(itemId);
            if (this.filteredRoots != null && this.passesFilters(itemId)) {
                this.filteredRoots.add(itemId);
            }
            Item item3 = item;
            return item3;
        }
        finally {
            this.enableAndFireContentsChangeEvents();
        }
    }

    @Override
    public boolean removeAllItems() {
        this.disableContentsChangeEvents();
        try {
            boolean success = super.removeAllItems();
            if (success) {
                this.roots.clear();
                this.parent.clear();
                this.children.clear();
                this.noChildrenAllowed.clear();
                if (this.filteredRoots != null) {
                    this.filteredRoots = null;
                }
                if (this.filteredChildren != null) {
                    this.filteredChildren = null;
                }
                if (this.filteredParent != null) {
                    this.filteredParent = null;
                }
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.enableAndFireContentsChangeEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeItem(Object itemId) {
        this.disableContentsChangeEvents();
        try {
            boolean success = super.removeItem(itemId);
            if (success) {
                LinkedList<Object> linkedList;
                Object parentItemId;
                LinkedList<Object> childNodeIds;
                if (this.roots.remove(itemId) && this.filteredRoots != null) {
                    this.filteredRoots.remove(itemId);
                }
                if ((childNodeIds = this.children.remove(itemId)) != null) {
                    if (this.filteredChildren != null) {
                        this.filteredChildren.remove(itemId);
                    }
                    for (Object e : childNodeIds) {
                        this.setParent(e, null);
                    }
                }
                if ((parentItemId = this.parent.get(itemId)) != null && (linkedList = this.children.get(parentItemId)) != null) {
                    LinkedList<Object> f;
                    linkedList.remove(itemId);
                    if (linkedList.isEmpty()) {
                        this.children.remove(parentItemId);
                    }
                    if (this.filteredChildren != null && (f = this.filteredChildren.get(parentItemId)) != null) {
                        f.remove(itemId);
                        if (f.isEmpty()) {
                            this.filteredChildren.remove(parentItemId);
                        }
                    }
                }
                this.parent.remove(itemId);
                if (this.filteredParent != null) {
                    this.filteredParent.remove(itemId);
                }
                this.noChildrenAllowed.remove(itemId);
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.enableAndFireContentsChangeEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItemRecursively(Object itemId) {
        this.disableContentsChangeEvents();
        try {
            boolean removeItemRecursively;
            boolean bl = removeItemRecursively = HierarchicalContainer.removeItemRecursively(this, itemId);
            return bl;
        }
        finally {
            this.enableAndFireContentsChangeEvents();
        }
    }

    public static boolean removeItemRecursively(Container.Hierarchical container, Object itemId) {
        boolean success = true;
        Collection<?> children2 = container.getChildren(itemId);
        if (children2 != null) {
            Object[] array = children2.toArray();
            for (int i = 0; i < array.length; ++i) {
                boolean removeItemRecursively = HierarchicalContainer.removeItemRecursively(container, array[i]);
                if (removeItemRecursively) continue;
                success = false;
            }
        }
        if (success) {
            success = container.removeItem(itemId);
        }
        return success;
    }

    @Override
    protected void doSort() {
        super.doSort();
        Collections.sort(this.roots, this.getItemSorter());
        for (LinkedList<Object> childList : this.children.values()) {
            Collections.sort(childList, this.getItemSorter());
        }
    }

    public boolean isIncludeParentsWhenFiltering() {
        return this.includeParentsWhenFiltering;
    }

    public void setIncludeParentsWhenFiltering(boolean includeParentsWhenFiltering) {
        this.includeParentsWhenFiltering = includeParentsWhenFiltering;
        if (this.filteredRoots != null) {
            this.doFilterContainer(true);
        }
    }

    @Override
    protected boolean doFilterContainer(boolean hasFilters) {
        if (!hasFilters) {
            this.filteredRoots = null;
            this.filteredChildren = null;
            this.filteredParent = null;
            return super.doFilterContainer(hasFilters);
        }
        this.filteredRoots = new LinkedList();
        this.filteredChildren = new HashMap();
        this.filteredParent = new HashMap();
        if (this.includeParentsWhenFiltering) {
            HashSet<Object> includedItems = new HashSet<Object>();
            for (Object e : this.roots) {
                if (!this.filterIncludingParents(e, includedItems)) continue;
                this.filteredRoots.add(e);
                this.addFilteredChildrenRecursively(e, includedItems);
            }
            this.filterOverride = includedItems;
            super.doFilterContainer(hasFilters);
            this.filterOverride = null;
            return true;
        }
        super.doFilterContainer(hasFilters);
        LinkedHashSet filteredItemIds = new LinkedHashSet(this.getItemIds());
        for (Object e : filteredItemIds) {
            Object itemParent = this.parent.get(e);
            if (itemParent == null || !filteredItemIds.contains(itemParent)) {
                this.filteredRoots.add(e);
                continue;
            }
            this.addFilteredChild(itemParent, e);
        }
        return true;
    }

    private void addFilteredChild(Object parentItemId, Object childItemId) {
        LinkedList<Object> parentToChildrenList = this.filteredChildren.get(parentItemId);
        if (parentToChildrenList == null) {
            parentToChildrenList = new LinkedList();
            this.filteredChildren.put(parentItemId, parentToChildrenList);
        }
        this.filteredParent.put(childItemId, parentItemId);
        parentToChildrenList.add(childItemId);
    }

    private void addFilteredChildrenRecursively(Object parentItemId, HashSet<Object> includedItems) {
        LinkedList<Object> childList = this.children.get(parentItemId);
        if (childList == null) {
            return;
        }
        for (Object e : childList) {
            if (!includedItems.contains(e)) continue;
            this.addFilteredChild(parentItemId, e);
            this.addFilteredChildrenRecursively(e, includedItems);
        }
    }

    private boolean filterIncludingParents(Object itemId, HashSet<Object> includedItems) {
        boolean toBeIncluded = this.passesFilters(itemId);
        LinkedList<Object> childList = this.children.get(itemId);
        if (childList != null) {
            for (Object e : this.children.get(itemId)) {
                toBeIncluded |= this.filterIncludingParents(e, includedItems);
            }
        }
        if (toBeIncluded) {
            includedItems.add(itemId);
        }
        return toBeIncluded;
    }

    @Override
    protected boolean passesFilters(Object itemId) {
        if (this.filterOverride != null) {
            return this.filterOverride.contains(itemId);
        }
        return super.passesFilters(itemId);
    }

    private static final Logger getLogger() {
        return Logger.getLogger(HierarchicalContainer.class.getName());
    }
}

