/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.shared.util.SharedUtil;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.AbstractProperty;
import com.vaadin.v7.data.util.MethodProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class NestedMethodProperty<T>
extends AbstractProperty<T> {
    private String propertyName;
    private transient List<Method> getMethods;
    private transient Method setMethod;
    private Object instance;
    private Class<? extends T> type;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize(this.instance.getClass(), this.propertyName);
    }

    public NestedMethodProperty(Object instance, String propertyName) {
        this.instance = instance;
        this.initialize(instance.getClass(), propertyName);
    }

    NestedMethodProperty(Class<?> instanceClass, String propertyName) {
        this.instance = null;
        this.initialize(instanceClass, propertyName);
    }

    private void initialize(Class<?> beanClass, String propertyName) throws IllegalArgumentException {
        ArrayList<Method> getMethods = new ArrayList<Method>();
        String lastSimplePropertyName = propertyName;
        Class<?> lastClass = beanClass;
        Class<?> propertyClass = beanClass;
        String[] simplePropertyNames = propertyName.split("\\.");
        if (propertyName.endsWith(".") || 0 == simplePropertyNames.length) {
            throw new IllegalArgumentException("Invalid property name '" + propertyName + "'");
        }
        for (int i = 0; i < simplePropertyNames.length; ++i) {
            String simplePropertyName = simplePropertyNames[i].trim();
            if (simplePropertyName.length() > 0) {
                lastSimplePropertyName = simplePropertyName;
                lastClass = propertyClass;
                try {
                    Method getter = MethodProperty.initGetterMethod(simplePropertyName, propertyClass);
                    propertyClass = getter.getReturnType();
                    getMethods.add(getter);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Bean property '" + simplePropertyName + "' not found", e);
                }
            }
            throw new IllegalArgumentException("Empty or invalid bean property identifier in '" + propertyName + "'");
        }
        Method lastGetMethod = (Method)getMethods.get(getMethods.size() - 1);
        Class<?> type = lastGetMethod.getReturnType();
        Method setMethod = null;
        try {
            lastSimplePropertyName = SharedUtil.capitalize((String)lastSimplePropertyName);
            setMethod = lastClass.getMethod("set" + lastSimplePropertyName, type);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.type = ReflectTools.convertPrimitiveType(type);
        this.propertyName = propertyName;
        this.getMethods = getMethods;
        this.setMethod = setMethod;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly() || null == this.setMethod;
    }

    @Override
    public T getValue() {
        try {
            Object object = this.instance;
            for (Method m : this.getMethods) {
                object = m.invoke(object, new Object[0]);
                if (object != null) continue;
                return null;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw new MethodProperty.MethodException((Property)this, e);
        }
    }

    @Override
    public void setValue(T newValue) throws Property.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new Property.ReadOnlyException();
        }
        this.invokeSetMethod(newValue);
        this.fireValueChange();
    }

    protected void invokeSetMethod(T value) {
        try {
            Object object = this.instance;
            for (int i = 0; i < this.getMethods.size() - 1; ++i) {
                object = this.getMethods.get(i).invoke(object, new Object[0]);
            }
            this.setMethod.invoke(object, value);
        }
        catch (InvocationTargetException e) {
            throw new MethodProperty.MethodException((Property)this, e.getTargetException());
        }
        catch (Exception e) {
            throw new MethodProperty.MethodException((Property)this, (Throwable)e);
        }
    }

    protected List<Method> getGetMethods() {
        return Collections.unmodifiableList(this.getMethods);
    }
}

