/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.combobox.GeneratedVaadinComboBox;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@HtmlImport(value="frontend://flow-component-renderer.html")
public class ComboBox<T>
extends GeneratedVaadinComboBox<ComboBox<T>, T>
implements HasSize,
HasValidation,
HasDataProvider<T> {
    private static final String ITEM_LABEL_PROPERTY = "label";
    private static final String KEY_PROPERTY = "key";
    private static final String SELECTED_ITEM_PROPERTY_NAME = "selectedItem";
    private static final String VALUE_PROPERTY_NAME = "value";
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private DataProvider<T, ?> dataProvider = DataProvider.ofItems((Object[])new Object[0]);
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private Element template;
    private transient List<T> itemsFromDataProvider = Collections.emptyList();
    private Registration rendererRegistration;
    private ArrayList<T> temporaryFilteredItems;
    private int customValueListenersCount;
    private Registration dataProviderListenerRegistration;
    private SerializableConsumer<UI> refreshJob;

    public ComboBox() {
        super(null, null, JsonValue.class, ComboBox::presentationToModel, ComboBox::modelToPresentation);
        this.getElement().synchronizeProperty(SELECTED_ITEM_PROPERTY_NAME, "change");
        this.getElement().synchronizeProperty(VALUE_PROPERTY_NAME, "change");
        this.setItemValuePath(KEY_PROPERTY);
        this.setRenderer((Renderer<T>)TemplateRenderer.of((String)"[[item.label]]"));
    }

    public ComboBox(String label) {
        this();
        this.setLabel(label);
    }

    public ComboBox(String label, Collection<T> items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    @SafeVarargs
    public ComboBox(String label, T ... items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    private static <T> T presentationToModel(ComboBox<T> comboBox, JsonValue presentation) {
        return super.getValue((Serializable)presentation);
    }

    private static <T> JsonValue modelToPresentation(ComboBox<T> comboBox, T model) {
        if (model == null) {
            return Json.createNull();
        }
        int updatedIndex = comboBox.itemsFromDataProvider.indexOf(model);
        if (updatedIndex < 0) {
            throw new IllegalArgumentException("The provided value is not part of ComboBox: " + model);
        }
        return super.generateJson(comboBox.itemsFromDataProvider.get(updatedIndex));
    }

    public void setRenderer(Renderer<T> renderer) {
        Rendering rendering;
        Objects.requireNonNull(renderer, "The renderer can not be null");
        this.unregister(this.rendererRegistration);
        if (this.template == null) {
            rendering = renderer.render(this.getElement(), this.keyMapper);
            this.template = rendering.getTemplateElement();
        } else {
            rendering = renderer.render(this.getElement(), this.keyMapper, this.template);
        }
        rendering.getDataGenerator().ifPresent(generator -> {
            this.rendererRegistration = this.dataGenerator.addDataGenerator(generator);
        });
        this.refresh(true);
    }

    private void unregister(Registration registration) {
        if (registration != null) {
            registration.remove();
        }
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "The data provider can not be null");
        this.dataProvider = dataProvider;
        this.refreshDataProvider();
        this.setValue(this.getEmptyValue());
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> this.refreshDataProvider());
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public List<T> getFilteredItems() {
        if (this.temporaryFilteredItems != null) {
            return Collections.unmodifiableList(this.temporaryFilteredItems);
        }
        JsonArray items = super.getFilteredItemsJsonArray();
        ArrayList<T> result = new ArrayList<T>(items.length());
        for (int i = 0; i < items.length(); ++i) {
            result.add(this.getData((JsonObject)items.get(i)));
        }
        return result;
    }

    public void setFilteredItems(T ... filteredItems) {
        this.setFilteredItems((Collection<T>)Arrays.asList(filteredItems));
    }

    public void setFilteredItems(Collection<T> filteredItems) {
        this.temporaryFilteredItems = new ArrayList<T>(filteredItems);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.setFilteredItems(this.generateJson(this.temporaryFilteredItems.stream()));
            this.temporaryFilteredItems = null;
        });
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.refresh();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    @Override
    public void setOpened(boolean opened) {
        super.setOpened(opened);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setAllowCustomValue(boolean allowCustomValue) {
        super.setAllowCustomValue(allowCustomValue);
    }

    public boolean isAllowCustomValue() {
        return this.isAllowCustomValueBoolean();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }

    public String getPattern() {
        return this.getPatternString();
    }

    public T getEmptyValue() {
        return null;
    }

    public void setValue(T value) {
        if (value == null || Objects.equals(value, this.getEmptyValue())) {
            if (this.getValue() != null) {
                this.cleanValueAndSelection();
            }
            return;
        }
        int updatedIndex = this.itemsFromDataProvider.indexOf(value);
        if (updatedIndex < 0) {
            throw new IllegalArgumentException("The provided value is not part of ComboBox: " + value);
        }
        this.getElement().setPropertyJson(SELECTED_ITEM_PROPERTY_NAME, (JsonValue)this.generateJson(this.itemsFromDataProvider.get(updatedIndex)));
    }

    private void cleanValueAndSelection() {
        this.getElement().setProperty(VALUE_PROPERTY_NAME, "");
        this.getElement().setPropertyJson(SELECTED_ITEM_PROPERTY_NAME, (JsonValue)Json.createNull());
    }

    public T getValue() {
        return this.getValue(this.getElement().getPropertyRaw(SELECTED_ITEM_PROPERTY_NAME));
    }

    @Override
    public Registration addCustomValueSetListener(ComponentEventListener<GeneratedVaadinComboBox.CustomValueSetEvent<ComboBox<T>>> listener) {
        this.setAllowCustomValue(true);
        ++this.customValueListenersCount;
        Registration registration = super.addCustomValueSetListener(listener);
        return new CustomValueRegistraton(registration);
    }

    private T getValue(Serializable value) {
        if (value instanceof JsonObject) {
            JsonObject selected = (JsonObject)value;
            assert (selected.hasKey(KEY_PROPERTY));
            return (T)this.keyMapper.get(selected.getString(KEY_PROPERTY));
        }
        return this.getEmptyValue();
    }

    private JsonArray generateJson(Stream<T> data) {
        JsonArray array = Json.createArray();
        data.map(this::generateJson).forEachOrdered(json -> array.set(array.length(), (JsonValue)json));
        return array;
    }

    private JsonObject generateJson(T item) {
        JsonObject json = Json.createObject();
        json.put(KEY_PROPERTY, this.keyMapper.key(item));
        String label = this.getItemLabelGenerator().apply(item);
        if (label == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        json.put(ITEM_LABEL_PROPERTY, label);
        this.dataGenerator.generateData(item, json);
        return json;
    }

    private T getData(JsonObject item) {
        if (item == null) {
            return null;
        }
        assert (item.hasKey(KEY_PROPERTY));
        JsonValue key = item.get(KEY_PROPERTY);
        return (T)this.keyMapper.get(key.asString());
    }

    private void refreshDataProvider() {
        this.itemsFromDataProvider = this.dataProvider.fetch(new Query()).collect(Collectors.toList());
        this.refresh();
    }

    private void refresh() {
        this.refresh(false);
    }

    private void refresh(boolean force) {
        if (force) {
            this.refreshJob = null;
        }
        if (this.refreshJob != null) {
            return;
        }
        this.refreshJob = new RefreshJob();
        this.runBeforeClientResponse(this.refreshJob);
    }

    private void setItemValuePath(String path) {
        this.getElement().setProperty("itemValuePath", path == null ? "" : path);
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.refresh();
    }

    private class RefreshJob
    implements SerializableConsumer<UI> {
        private RefreshJob() {
        }

        public void accept(UI ui) {
            if (ComboBox.this.refreshJob != this) {
                return;
            }
            Object value = ComboBox.this.getValue();
            ComboBox.this.keyMapper.removeAll();
            JsonArray array = ComboBox.this.generateJson(ComboBox.this.itemsFromDataProvider.stream());
            ComboBox.this.setItems(array);
            ComboBox.this.setValue(value);
            ComboBox.this.refreshJob = null;
        }
    }

    private class CustomValueRegistraton
    implements Registration {
        private Registration delegate;

        private CustomValueRegistraton(Registration delegate) {
            this.delegate = delegate;
        }

        public void remove() {
            if (this.delegate != null) {
                this.delegate.remove();
                ComboBox.this.customValueListenersCount--;
                if (ComboBox.this.customValueListenersCount == 0) {
                    ComboBox.this.setAllowCustomValue(false);
                }
                this.delegate = null;
            }
        }
    }
}

