/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.ui.popupview;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event for popup visibility changes.
 *
 * @author Vaadin Ltd
 */
public class VisibilityChangeEvent extends GwtEvent<VisibilityChangeHandler> {

    private static Type<VisibilityChangeHandler> type;

    private boolean visible;

    /**
     * Constructs a visibility change event.
     *
     * @param visible
     *            {@code true} if the popup was made visible
     */
    public VisibilityChangeEvent(final boolean visible) {
        this.visible = visible;
    }

    /**
     * Returns whether the popup is now visible or not.
     *
     * @return {@code true} if the popup is visible, {@code false} otherwise
     */
    public boolean isVisible() {
        return visible;
    }

    @Override
    public Type<VisibilityChangeHandler> getAssociatedType() {
        return getType();
    }

    /**
     * Returns the {@link Type} used to register this event.
     *
     * @return the type
     */
    public static Type<VisibilityChangeHandler> getType() {
        if (type == null) {
            type = new Type<>();
        }
        return type;
    }

    @Override
    protected void dispatch(final VisibilityChangeHandler handler) {
        handler.onVisibilityChange(this);
    }
}
