/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.client.data;

/**
 * FOR INTERNAL USE ONLY. This might be removed or renamed at any time without a
 * warning.
 *
 * Callback interface used by {@link DataSource} to inform its user about
 * updates to hierarchical data.
 *
 * @since 8.17
 * @author Vaadin Ltd
 */
public interface HierarchicalDataChangeHandler extends DataChangeHandler {
    /**
     * FOR INTERNAL USE ONLY. This might be removed or renamed at any time
     * without a warning.
     *
     * Called when an expand or collapse event or several are about to arrive
     * from the server, and when all expand or collapse events for this round
     * trip have been sent from the server.
     *
     * @param pending
     *            {@code true} before the updates, {@code false} when all the
     *            updates are done
     */
    public void setExpandCollapsePending(boolean pending);

}
