/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.grid;

import com.vaadin.client.ServerConnector;
import com.vaadin.client.extensions.AbstractExtensionConnector;
import com.vaadin.client.widget.grid.selection.SelectionModel;
import com.vaadin.shared.ui.Connect;

/**
 * Connector for grids selection model that doesn't allow selecting anything.
 *
 * @author Vaadin Ltd
 *
 * @since 8.0
 */
@Connect(com.vaadin.ui.components.grid.NoSelectionModel.class)
public class NoSelectionModelConnector extends AbstractExtensionConnector {

    @Override
    protected void extend(ServerConnector target) {
        assert target instanceof GridConnector : "NoSelectionModelConnector cannot extend anything else than Grid.";

        ((GridConnector) target).getWidget()
                .setSelectionModel(new SelectionModel.NoSelectionModel<>());
    }

}
