/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.client.connectors.data;

import com.vaadin.data.provider.HierarchicalDataCommunicator;
import com.vaadin.shared.data.HierarchicalDataCommunicatorConstants;
import com.vaadin.shared.ui.Connect;

import elemental.json.JsonObject;

/**
 * A connector for HierarchicalDataCommunicator class.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
@Connect(HierarchicalDataCommunicator.class)
public class HierarchicalDataCommunicatorConnector
        extends DataCommunicatorConnector {

    @Override
    protected void onRowDataUpdate(JsonObject newRowData,
            JsonObject oldRowData) {
        assert newRowData.hasKey(
                HierarchicalDataCommunicatorConstants.ROW_HIERARCHY_DESCRIPTION);
        assert oldRowData.hasKey(
                HierarchicalDataCommunicatorConstants.ROW_HIERARCHY_DESCRIPTION);

        /*
         * Since server side can't know the index of a random item, any
         * refreshItem(..) cannot know the depth. Thus need to copy it from
         * previous item.
         */
        JsonObject hierarchyData = newRowData.getObject(
                HierarchicalDataCommunicatorConstants.ROW_HIERARCHY_DESCRIPTION);
        if (!hierarchyData
                .hasKey(HierarchicalDataCommunicatorConstants.ROW_DEPTH)) {
            hierarchyData.put(HierarchicalDataCommunicatorConstants.ROW_DEPTH,
                    oldRowData.getObject(
                            HierarchicalDataCommunicatorConstants.ROW_HIERARCHY_DESCRIPTION)
                            .getNumber(
                                    HierarchicalDataCommunicatorConstants.ROW_DEPTH));
        }
    }

}
