/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.soyc.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * An {@link OutputDirectory} that writes directly to the file system.
 */
public class FileSystemOutputDirectory implements OutputDirectory {
  private final File outDir;

  public FileSystemOutputDirectory(File outDir) {
    this.outDir = outDir;
  }

  @Override
  public OutputStream getOutputStream(String path) throws IOException {
    File outFile = new File(outDir, path);
    outFile.getParentFile().mkdirs();
    return new FileOutputStream(outFile);
  }
}
