/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox.testbench;

import com.vaadin.flow.component.checkbox.testbench.CheckboxElement;
import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Element(value="vaadin-checkbox-group")
public class CheckboxGroupElement
extends TestBenchElement
implements HasHelper {
    public List<String> getOptions() {
        return this.getCheckboxes().stream().map(CheckboxElement::getLabel).collect(Collectors.toList());
    }

    public List<CheckboxElement> getCheckboxes() {
        return this.$(CheckboxElement.class).all();
    }

    public void selectByText(String label) {
        Optional<CheckboxElement> checkbox = this.getCheckboxByLabel(label);
        if (!checkbox.isPresent()) {
            throw new NoSuchElementException("No checkbox with label '" + label + "' found");
        }
        checkbox.get().setChecked(true);
    }

    public void deselectByText(String label) {
        Optional<CheckboxElement> checkbox = this.getCheckboxByLabel(label);
        if (!checkbox.isPresent()) {
            throw new NoSuchElementException("No checkbox with label '" + label + "' found");
        }
        checkbox.get().setChecked(false);
    }

    public List<String> getSelectedTexts() {
        Stream<CheckboxElement> button = this.getSelectedCheckboxes();
        return button.map(CheckboxElement::getLabel).collect(Collectors.toList());
    }

    private Stream<CheckboxElement> getSelectedCheckboxes() {
        return this.getCheckboxByChecked(true);
    }

    private Optional<CheckboxElement> getCheckboxByLabel(String label) {
        if (label == null) {
            return Optional.empty();
        }
        return this.getCheckboxes().stream().filter(checkbox -> label.equals(checkbox.getLabel())).findFirst();
    }

    private Stream<CheckboxElement> getCheckboxByChecked(boolean value) {
        return this.getCheckboxes().stream().filter(checkbox -> checkbox.isChecked() == value);
    }

    public TestBenchElement getErrorMessageComponent() {
        return this.$("div").withAttribute("slot", "error-message").first();
    }
}

