/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.checkbox.dataview.CheckboxGroupDataView;
import com.vaadin.flow.component.checkbox.dataview.CheckboxGroupListDataView;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.SelectionPreservationHandler;
import com.vaadin.flow.component.shared.SelectionPreservationMode;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-checkbox-group")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.2"), @NpmPackage(value="@vaadin/checkbox-group", version="24.8.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/checkbox-group/src/vaadin-checkbox-group.js")})
public class CheckboxGroup<T>
extends AbstractSinglePropertyField<CheckboxGroup<T>, Set<T>>
implements HasAriaLabel,
HasClientValidation,
HasDataView<T, Void, CheckboxGroupDataView<T>>,
HasItemComponents<T>,
InputField<AbstractField.ComponentValueChangeEvent<CheckboxGroup<T>, Set<T>>, Set<T>>,
HasListDataView<T, CheckboxGroupListDataView<T>>,
HasThemeVariant<CheckboxGroupVariant>,
HasValidationProperties,
HasValidator<Set<T>>,
MultiSelect<CheckboxGroup<T>, T> {
    private static final String VALUE = "value";
    private final KeyMapper<T> keyMapper = new KeyMapper(this::getItemId);
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private ItemHelperGenerator<T> itemHelperGenerator = (ItemHelperGenerator<Object> & Serializable)item -> null;
    private ComponentRenderer<? extends Component, T> itemRenderer;
    private Registration dataProviderListenerRegistration;
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;
    private CheckboxGroupI18n i18n;
    private Validator<Set<T>> defaultValidator = (Validator & Serializable)(value, context) -> {
        boolean fromComponent = context == null;
        boolean isRequired = fromComponent && this.isRequiredIndicatorVisible();
        return ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(CheckboxGroupI18n::getRequiredErrorMessage), (boolean)isRequired, (Object)((Set)this.getValue()), (Object)((Set)this.getEmptyValue()));
    };
    private ValidationController<CheckboxGroup<T>, Set<T>> validationController = new ValidationController((Component)this);
    private SelectionPreservationHandler<T> selectionPreservationHandler;

    public CheckboxGroup() {
        super(VALUE, Collections.emptySet(), JsonArray.class, CheckboxGroup::presentationToModel, CheckboxGroup::modelToPresentation);
        this.getElement().setProperty("manualValidation", true);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.initSelectionPreservationHandler();
    }

    public CheckboxGroup(String label) {
        this();
        this.setLabel(label);
    }

    public CheckboxGroup(String label, Collection<T> items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    @SafeVarargs
    public CheckboxGroup(String label, T ... items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    public CheckboxGroup(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<CheckboxGroup<T>, Set<T>>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public CheckboxGroup(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<CheckboxGroup<T>, Set<T>>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    @SafeVarargs
    public CheckboxGroup(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<CheckboxGroup<T>, Set<T>>> listener, T ... items) {
        this(label, listener);
        this.setItems(items);
    }

    public CheckboxGroupDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public CheckboxGroupDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public CheckboxGroupListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public CheckboxGroupListDataView<T> getListDataView() {
        return new CheckboxGroupListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.rebuild());
    }

    public CheckboxGroupDataView<T> getGenericDataView() {
        return new CheckboxGroupDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    private void initSelectionPreservationHandler() {
        this.selectionPreservationHandler = new SelectionPreservationHandler<T>(SelectionPreservationMode.DISCARD){

            public void onPreserveAll(DataChangeEvent<T> dataChangeEvent) {
            }

            public void onPreserveExisting(DataChangeEvent<T> dataChangeEvent) {
                Map<Object, Object> deselectionCandidateIdsToItems = CheckboxGroup.this.getSelectedItems().stream().collect(Collectors.toMap(item -> CheckboxGroup.this.getItemId(item), item -> item));
                Stream itemsStream = CheckboxGroup.this.getDataProvider().fetch(DataViewUtils.getQuery((Component)CheckboxGroup.this));
                Set<Object> existingItemIds = itemsStream.map(item -> CheckboxGroup.this.getItemId(item)).filter(deselectionCandidateIdsToItems::containsKey).limit(deselectionCandidateIdsToItems.size()).collect(Collectors.toSet());
                existingItemIds.forEach(deselectionCandidateIdsToItems::remove);
                CheckboxGroup.this.deselect(deselectionCandidateIdsToItems.values());
            }

            public void onDiscard(DataChangeEvent<T> dataChangeEvent) {
                CheckboxGroup.this.clear();
            }
        };
    }

    private void handleDataChange(DataChangeEvent<T> dataChangeEvent) {
        if (dataChangeEvent instanceof DataChangeEvent.DataRefreshEvent) {
            DataChangeEvent.DataRefreshEvent dataRefreshEvent = (DataChangeEvent.DataRefreshEvent)dataChangeEvent;
            Object otherItem = dataRefreshEvent.getItem();
            Object otherItemId = this.getItemId(otherItem);
            this.keyMapper.refresh(otherItem);
            this.getCheckboxItems().filter(item -> Objects.equals(this.getItemId(item.item), otherItemId)).findFirst().ifPresent(this::updateCheckbox);
        } else {
            this.keyMapper.removeAll();
            this.selectionPreservationHandler.handleDataChange(dataChangeEvent);
            this.rebuild();
        }
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.keyMapper.removeAll();
        this.clear();
        this.rebuild();
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener(this::handleDataChange);
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        HashSet<T> value = new HashSet<T>((Collection)this.getValue());
        value.addAll(addedItems);
        value.removeAll(removedItems);
        this.setValue(value);
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value, "Cannot set a null value to checkbox group. Use the clear-method to reset the component's value to an empty set.");
        super.setValue(value);
        this.refreshCheckboxes();
    }

    public Set<T> getSelectedItems() {
        return (Set)this.getValue();
    }

    public Registration addSelectionListener(MultiSelectionListener<CheckboxGroup<T>, T> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }

    public DataProvider<T, ?> getDataProvider() {
        return Optional.ofNullable(this.dataProvider).map(AtomicReference::get).orElse(null);
    }

    public void onEnabledStateChanged(boolean enabled) {
        this.setDisabled(!enabled);
        this.getCheckboxItems().forEach(this::updateEnabled);
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.refreshCheckboxes();
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.itemRenderer = null;
        this.refreshCheckboxes();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemHelperGenerator(ItemHelperGenerator<T> itemHelperGenerator) {
        Objects.requireNonNull(itemHelperGenerator, "The item helper generator can not be null");
        this.itemHelperGenerator = itemHelperGenerator;
        this.refreshCheckboxes();
    }

    public ItemHelperGenerator<T> getItemHelperGenerator() {
        return this.itemHelperGenerator;
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public boolean isRequired() {
        return this.isRequiredIndicatorVisible();
    }

    public void setRequired(boolean required) {
        this.setRequiredIndicatorVisible(required);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected boolean valueEquals(Set<T> value1, Set<T> value2) {
        assert (value1 != null && value2 != null);
        if (value1.size() != value2.size()) {
            return false;
        }
        if (this.getDataProvider() == null) {
            return super.valueEquals(value1, value2);
        }
        IdentifierProvider<T> identifierProvider = this.getIdentifierProvider();
        Set ids1 = value1.stream().map(identifierProvider).collect(Collectors.toSet());
        Set ids2 = value2.stream().map(identifierProvider).collect(Collectors.toSet());
        return ids1.equals(ids2);
    }

    protected boolean hasValidValue() {
        Set value = CheckboxGroup.presentationToModel(this, (JsonArray)this.getElement().getPropertyRaw(VALUE));
        Set oldValue = (Set)this.getValue();
        return this.getCheckboxItems().filter(Checkbox::isDisabledBoolean).noneMatch(item -> oldValue.contains(item.getItem()) != value.contains(item.getItem()));
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = Objects.requireNonNull(renderer);
        this.refreshCheckboxItems();
    }

    public void setSelectionPreservationMode(SelectionPreservationMode selectionPreservationMode) {
        this.selectionPreservationHandler.setSelectionPreservationMode(selectionPreservationMode);
    }

    public SelectionPreservationMode getSelectionPreservationMode() {
        return this.selectionPreservationHandler.getSelectionPreservationMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            Component helperComponent = this.getHelperComponent();
            this.getChildren().forEach(xva$0 -> this.remove(new Component[]{xva$0}));
            this.setHelperComponent(helperComponent);
            AtomicInteger itemCounter = new AtomicInteger(0);
            this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).map(item -> this.createCheckBox(item)).forEach(component -> {
                this.add(new Component[]{(Component)component});
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private void refreshCheckboxes() {
        this.getCheckboxItems().forEach(this::updateCheckbox);
    }

    private Stream<CheckBoxItem<T>> getCheckboxItems() {
        return this.getChildren().filter(CheckBoxItem.class::isInstance).map(child -> (CheckBoxItem)((Object)child));
    }

    private Checkbox createCheckBox(T item) {
        CheckBoxItem<T> checkbox = new CheckBoxItem<T>(this.keyMapper.key(item), item);
        this.updateCheckbox(checkbox);
        return checkbox;
    }

    private void refreshCheckboxItems() {
        this.getCheckboxItems().forEach(this::updateCheckbox);
    }

    private void updateCheckbox(CheckBoxItem<T> checkbox) {
        if (this.itemRenderer == null) {
            checkbox.setLabel(this.getItemLabelGenerator().apply(checkbox.getItem()));
        } else {
            checkbox.setLabelComponent(this.getItemRenderer().createComponent(checkbox.item));
        }
        Object helper = this.itemHelperGenerator.apply(checkbox.item);
        if (helper != null) {
            checkbox.setHelperText((String)helper);
        } else if (checkbox.getHelperText() != null) {
            checkbox.setHelperText(null);
        }
        checkbox.setValue(((Set)this.getValue()).stream().anyMatch(selectedItem -> Objects.equals(this.getItemId(selectedItem), this.getItemId(checkbox.getItem()))));
        this.updateEnabled(checkbox);
    }

    private void updateEnabled(CheckBoxItem<T> checkbox) {
        boolean disabled = this.isDisabledBoolean() || !this.getItemEnabledProvider().test(checkbox.getItem());
        checkbox.setDisabled(disabled);
        checkbox.getElement().executeJs("this.disabled = $0", new Serializable[]{Boolean.valueOf(disabled)});
    }

    private static <T> Set<T> presentationToModel(CheckboxGroup<T> group, JsonArray presentation) {
        if (group.keyMapper == null) {
            return Collections.emptySet();
        }
        JsonArray array = presentation;
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < array.length(); ++i) {
            set.add(group.keyMapper.get(array.getString(i)));
        }
        return set;
    }

    private static <T> JsonArray modelToPresentation(CheckboxGroup<T> group, Set<T> model) {
        JsonArray array = Json.createArray();
        if (model.isEmpty()) {
            return array;
        }
        model.stream().map(arg_0 -> group.keyMapper.key(arg_0)).forEach(key -> array.set(array.length(), key));
        return array;
    }

    private Object getItemId(T item) {
        return this.getIdentifierProvider().apply(item);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    private IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider<T, ?> dataProvider = this.getDataProvider();
            if (dataProvider != null) {
                return arg_0 -> dataProvider.getId(arg_0);
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    public Validator<Set<T>> getDefaultValidator() {
        return this.defaultValidator;
    }

    protected void validate() {
        this.validationController.validate((Object)((Set)this.getValue()));
    }

    public CheckboxGroupI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(CheckboxGroupI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<CheckboxGroupI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    @FunctionalInterface
    public static interface ItemHelperGenerator<T>
    extends SerializableFunction<T, String> {
        public String apply(T var1);
    }

    private static class CheckBoxItem<T>
    extends Checkbox
    implements HasItemComponents.ItemComponent<T> {
        private final T item;

        private CheckBoxItem(String id, T item) {
            this.item = item;
            this.getElement().setProperty(CheckboxGroup.VALUE, id);
        }

        public T getItem() {
            return this.item;
        }
    }

    public static class CheckboxGroupI18n
    implements Serializable {
        private String requiredErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public CheckboxGroupI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }
    }
}

