/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import java.io.Serializable;
import java.util.Optional;

@Tag(value="vaadin-checkbox")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.3"), @NpmPackage(value="@vaadin/checkbox", version="24.2.3")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/checkbox/src/vaadin-checkbox.js")})
public class Checkbox
extends AbstractSinglePropertyField<Checkbox, Boolean>
implements ClickNotifier<Checkbox>,
Focusable<Checkbox>,
HasAriaLabel,
InputField<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>, Boolean> {
    private final Label labelElement;
    private static final PropertyChangeListener NO_OP = (PropertyChangeListener & Serializable)event -> {};
    private String ariaLabel;
    private String ariaLabelledBy;

    public Checkbox() {
        super("checked", (Object)false, false);
        this.getElement().addPropertyChangeListener("indeterminate", "indeterminate-changed", NO_OP);
        this.getElement().addPropertyChangeListener("checked", "checked-changed", NO_OP);
        if (this.getElement().getProperty("checked") == null) {
            this.setPresentationValue(false);
        }
        this.setIndeterminate(false);
        this.labelElement = new Label();
        this.labelElement.getElement().setAttribute("slot", "label");
    }

    public Checkbox(String labelText) {
        this();
        this.setLabel(labelText);
    }

    public Checkbox(boolean initialValue) {
        this();
        this.setValue(initialValue);
    }

    public Checkbox(String labelText, boolean initialValue) {
        this(labelText);
        this.setValue(initialValue);
    }

    public Checkbox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public Checkbox(boolean initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(initialValue);
        this.addValueChangeListener(listener);
    }

    public Checkbox(String labelText, boolean initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(labelText, initialValue);
        this.addValueChangeListener(listener);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setLabel(String label) {
        if (this.getElement().equals((Object)this.labelElement.getElement().getParent())) {
            this.getElement().removeChild(new Element[]{this.labelElement.getElement()});
        }
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public void setLabelComponent(Component component) {
        this.setLabel("");
        this.getElement().appendChild(new Element[]{this.labelElement.getElement()});
        this.labelElement.removeAll();
        this.labelElement.add(new Component[]{component});
    }

    public void setAriaLabel(String ariaLabel) {
        this.toggleInputElementAttribute("aria-label", ariaLabel);
        this.ariaLabel = ariaLabel;
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.ariaLabel);
    }

    public void setAriaLabelledBy(String ariaLabelledBy) {
        this.toggleInputElementAttribute("aria-labelledby", ariaLabelledBy);
        this.ariaLabelledBy = ariaLabelledBy;
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.ariaLabelledBy);
    }

    private void toggleInputElementAttribute(String attribute, String value) {
        if (value != null) {
            this.getElement().executeJs("this.inputElement.setAttribute($0, $1)", new Serializable[]{attribute, value});
        } else {
            this.getElement().executeJs("this.inputElement.removeAttribute($0)", new Serializable[]{attribute});
        }
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.getElement().setProperty("indeterminate", indeterminate);
    }

    @Synchronize(property="indeterminate", value={"indeterminate-changed"})
    public boolean isIndeterminate() {
        return this.getElement().getProperty("indeterminate", false);
    }

    void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }
}

