/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.server;

import com.vaadin.cdi.CDIUIProvider;
import com.vaadin.cdi.CDIViewProvider;
import com.vaadin.cdi.internal.CDIUtil;
import com.vaadin.cdi.internal.VaadinSessionDestroyEvent;
import com.vaadin.cdi.internal.VaadinViewChangeCleanupEvent;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;

public class VaadinCDIServletService
extends VaadinServletService {
    private BeanManager beanManager = null;

    public VaadinCDIServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        super(servlet, deploymentConfiguration);
        SessionListenerImpl sessionListener = new SessionListenerImpl();
        this.addSessionInitListener(sessionListener);
        this.addSessionDestroyListener(sessionListener);
    }

    protected BeanManager getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = CDIUtil.lookupBeanManager();
        }
        return this.beanManager;
    }

    private static Logger getLogger() {
        return Logger.getLogger(VaadinCDIServletService.class.getCanonicalName());
    }

    public void handleRequest(VaadinRequest request, VaadinResponse response) throws ServiceException {
        super.handleRequest(request, response);
        VaadinViewChangeCleanupEvent event = CDIViewProvider.getCleanupEvent();
        if (event != null) {
            VaadinCDIServletService.getLogger().fine("Cleaning up after View changing request.");
            this.getBeanManager().fireEvent((Object)event, new Annotation[0]);
            CDIViewProvider.removeCleanupEvent();
        }
    }

    protected final class SessionListenerImpl
    implements SessionInitListener,
    SessionDestroyListener {
        protected SessionListenerImpl() {
        }

        public void sessionInit(SessionInitEvent event) {
            VaadinCDIServletService.getLogger().fine("Session init");
            event.getSession().addUIProvider((UIProvider)new CDIUIProvider());
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            VaadinCDIServletService.getLogger().fine("Firing session destroy event.");
            VaadinSessionDestroyEvent sessionDestroyEvent = new VaadinSessionDestroyEvent(CDIUtil.getSessionId(event.getSession()));
            VaadinCDIServletService.this.getBeanManager().fireEvent((Object)sessionDestroyEvent, new Annotation[0]);
        }
    }
}

