/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.ViewScoped;
import com.vaadin.cdi.internal.AbstractVaadinContext;
import com.vaadin.cdi.internal.Conventions;
import com.vaadin.cdi.internal.UIContextual;
import com.vaadin.cdi.internal.VaadinContextualStorage;
import com.vaadin.cdi.internal.ViewBean;
import com.vaadin.cdi.internal.ViewContextual;
import com.vaadin.navigator.View;
import com.vaadin.ui.UI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public class ViewScopedContext
extends AbstractVaadinContext {
    private List<String> viewMappings;

    public ViewScopedContext(BeanManager beanManager) {
        super(beanManager);
        this.getLogger().fine("Instantiating ViewScoped context");
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    @Override
    protected <T> Contextual<T> wrapBean(Contextual<T> bean) {
        if (!(bean instanceof UIContextual) && bean instanceof Bean && View.class.isAssignableFrom(((Bean)bean).getBeanClass())) {
            String mapping = Conventions.deriveMappingForView(((Bean)bean).getBeanClass());
            return new ViewBean((Bean)bean, mapping);
        }
        return bean;
    }

    protected synchronized ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        Map<Contextual<?>, ContextualStorage> map;
        this.getLogger().fine("Retrieving contextual storage for " + contextual);
        AbstractVaadinContext.SessionData sessionData = contextual instanceof UIContextual ? this.getSessionData(((UIContextual)contextual).getSessionId(), createIfNotExist) : this.getSessionData(createIfNotExist);
        if (sessionData == null) {
            if (createIfNotExist) {
                throw new IllegalStateException("Session data not recoverable for " + contextual);
            }
            return null;
        }
        if (!(contextual instanceof ViewContextual)) {
            UI currentUI = UI.getCurrent();
            if (currentUI == null) {
                throw new IllegalStateException("Unable to resolve " + contextual + ", current UI not set.");
            }
            AbstractVaadinContext.SessionData.UIData uiData = sessionData.getUIData(currentUI.getUIId(), true);
            String viewName = uiData.getProbableInjectionPointView();
            if (viewName == null) {
                this.getLogger().warning("Could not determine active View");
            }
            contextual = contextual instanceof Bean ? new ViewBean((Bean)contextual, viewName) : new ViewContextual(contextual, viewName);
        }
        if ((map = sessionData.getStorageMap()) == null) {
            return null;
        }
        if (map.containsKey(contextual)) {
            return map.get(contextual);
        }
        if (createIfNotExist) {
            VaadinContextualStorage storage = new VaadinContextualStorage(this.getBeanManager(), true);
            map.put(contextual, storage);
            return storage;
        }
        return null;
    }

    synchronized void prepareForViewChange(long sessionId, int uiId, String activeViewName) {
        this.getLogger().fine("Setting next view to " + activeViewName);
        AbstractVaadinContext.SessionData sessionData = this.getSessionData(sessionId, true);
        AbstractVaadinContext.SessionData.UIData uiData = sessionData.getUIData(uiId, true);
        uiData.setOpeningView(activeViewName);
    }

    synchronized void viewChangeCleanup(long sessionId, int uiId) {
        this.getLogger().fine("ViewChangeCleanup for " + sessionId + " " + uiId);
        AbstractVaadinContext.SessionData sessionData = this.getSessionData(sessionId, true);
        AbstractVaadinContext.SessionData.UIData uiData = sessionData.getUIData(uiId, true);
        if (uiData == null) {
            return;
        }
        uiData.validateTransition();
        String activeViewName = uiData.getActiveView();
        Map<Contextual<?>, ContextualStorage> map = sessionData.getStorageMap();
        for (Map.Entry<Contextual<?>, ContextualStorage> entry : new ArrayList(map.entrySet())) {
            ViewContextual contextual = (ViewContextual)entry.getKey();
            if (contextual.uiId != uiId || contextual.viewIdentifier.equals(activeViewName)) continue;
            this.getLogger().fine("dropping " + contextual + " : " + entry.getValue());
            map.remove(contextual);
            this.destroy(contextual);
        }
    }

    synchronized void clearPendingViewChange(long sessionId, int uiId) {
        AbstractVaadinContext.SessionData.UIData uiData;
        AbstractVaadinContext.SessionData sessionData = this.getSessionData(sessionId, false);
        if (sessionData != null && (uiData = sessionData.getUIData(uiId)) != null) {
            uiData.clearPendingViewChange();
        }
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(ViewScopedContext.class.getCanonicalName());
    }
}

