/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.CDIView;
import com.vaadin.cdi.NormalUIScoped;
import com.vaadin.cdi.NormalViewScoped;
import com.vaadin.cdi.UIScoped;
import com.vaadin.cdi.ViewScoped;
import com.vaadin.cdi.internal.ContextWrapper;
import com.vaadin.cdi.internal.InconsistentDeploymentException;
import com.vaadin.cdi.internal.UIScopedContext;
import com.vaadin.cdi.internal.VaadinSessionDestroyEvent;
import com.vaadin.cdi.internal.VaadinUICloseEvent;
import com.vaadin.cdi.internal.VaadinViewChangeCleanupEvent;
import com.vaadin.cdi.internal.VaadinViewChangeEvent;
import com.vaadin.cdi.internal.VaadinViewCreationEvent;
import com.vaadin.cdi.internal.ViewScopedContext;
import com.vaadin.navigator.View;
import com.vaadin.ui.Component;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;

public class VaadinExtension
implements Extension {
    private UIScopedContext uiScopedContext;
    private ViewScopedContext viewScopedContext;
    private List<String> normalScopedComponentWarnings = new LinkedList<String>();

    void processManagedBean(@Observes ProcessManagedBean pmb, BeanManager beanManager) {
        Bean bean = pmb.getBean();
        Class beanClass = bean.getBeanClass();
        Class beanScope = bean.getScope();
        if (Component.class.isAssignableFrom(beanClass) && beanManager.isNormalScope(beanScope)) {
            this.normalScopedComponentWarnings.add("@" + String.format("%-20s", beanScope.getSimpleName()) + " " + beanClass.getCanonicalName());
        }
        if (beanClass.isAnnotationPresent(CDIView.class) && !View.class.isAssignableFrom(beanClass) && !Modifier.isAbstract(beanClass.getModifiers())) {
            String message = "The non-abstract class " + beanClass.getCanonicalName() + " with @CDIView should implement " + View.class.getCanonicalName();
            VaadinExtension.getLogger().warning(message);
            throw new InconsistentDeploymentException(InconsistentDeploymentException.ID.CDIVIEW_WITHOUT_VIEW, message);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.normalScopedComponentWarnings.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("The following Vaadin components are injected into normal scoped contexts:\n");
            for (String proxiedComponent : this.normalScopedComponentWarnings) {
                sb.append("   ");
                sb.append(proxiedComponent);
                sb.append("\n");
            }
            sb.append("This approach uses proxy objects and has not been extensively tested with the framework. Please report any unexpected behavior. Switching to a pseudo-scoped context may also resolve potential issues.");
            VaadinExtension.getLogger().info(sb.toString());
        }
        this.uiScopedContext = new UIScopedContext(beanManager);
        afterBeanDiscovery.addContext((Context)new ContextWrapper((Context)this.uiScopedContext, UIScoped.class));
        afterBeanDiscovery.addContext((Context)new ContextWrapper((Context)this.uiScopedContext, NormalUIScoped.class));
        VaadinExtension.getLogger().info("UIScopedContext registered for Vaadin CDI");
        this.viewScopedContext = new ViewScopedContext(beanManager);
        afterBeanDiscovery.addContext((Context)new ContextWrapper((Context)this.viewScopedContext, ViewScoped.class));
        afterBeanDiscovery.addContext((Context)new ContextWrapper((Context)this.viewScopedContext, NormalViewScoped.class));
        VaadinExtension.getLogger().info("ViewScopedContext registered for Vaadin CDI");
    }

    private static Logger getLogger() {
        return Logger.getLogger(VaadinExtension.class.getCanonicalName());
    }

    private void sessionClose(@Observes VaadinSessionDestroyEvent event) {
        if (this.uiScopedContext != null) {
            this.uiScopedContext.dropSessionData(event);
        }
        if (this.viewScopedContext != null) {
            this.viewScopedContext.dropSessionData(event);
        }
    }

    private void uiClose(@Observes VaadinUICloseEvent event) {
        if (this.uiScopedContext != null) {
            this.uiScopedContext.queueUICloseEvent(event);
        }
        if (this.viewScopedContext != null) {
            this.viewScopedContext.queueUICloseEvent(event);
        }
    }

    private void requestEnd(@Observes VaadinViewChangeCleanupEvent event) {
        if (this.uiScopedContext != null) {
            this.uiScopedContext.uiCloseCleanup();
        }
        if (this.viewScopedContext != null) {
            this.viewScopedContext.uiCloseCleanup();
            this.viewScopedContext.clearPendingViewChange(event.getSessionId(), event.getUiId());
        }
    }

    private void navigationChanged(@Observes VaadinViewChangeEvent event) {
        if (this.viewScopedContext != null) {
            long sessionId = event.getSessionId();
            int uiId = event.getUiId();
            this.viewScopedContext.viewChangeCleanup(sessionId, uiId);
        }
    }

    private void navigationStarting(@Observes VaadinViewCreationEvent event) {
        if (this.viewScopedContext != null) {
            this.viewScopedContext.prepareForViewChange(event.getSessionId(), event.getUIId(), event.getViewMapping());
        }
    }

    public static final class VaadinComponentProxyException
    extends Exception {
        public VaadinComponentProxyException(String message) {
            super(message);
        }
    }
}

