/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.UIScoped;
import com.vaadin.cdi.internal.AbstractVaadinContext;
import com.vaadin.cdi.internal.UIBean;
import com.vaadin.cdi.internal.UIContextual;
import com.vaadin.cdi.internal.VaadinContextualStorage;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public class UIScopedContext
extends AbstractVaadinContext {
    public UIScopedContext(BeanManager beanManager) {
        super(beanManager);
        this.getLogger().fine("Instantiating UIScoped context");
    }

    public Class<? extends Annotation> getScope() {
        return UIScoped.class;
    }

    @Override
    protected <T> Contextual<T> wrapBean(Contextual<T> bean) {
        if (!(bean instanceof UIContextual) && bean instanceof Bean && UI.class.isAssignableFrom(((Bean)bean).getBeanClass())) {
            return new UIBean((Bean)bean);
        }
        return bean;
    }

    protected synchronized ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        Map<Contextual<?>, ContextualStorage> map;
        AbstractVaadinContext.SessionData sessionData = contextual instanceof UIContextual ? this.getSessionData(((UIContextual)contextual).getSessionId(), createIfNotExist) : this.getSessionData(createIfNotExist);
        if (sessionData == null) {
            if (createIfNotExist) {
                throw new IllegalStateException("Session data not recoverable for " + contextual);
            }
            return null;
        }
        if (!(contextual instanceof UIContextual)) {
            contextual = CurrentInstance.get(UIBean.class) != null ? (Contextual)CurrentInstance.get(UIBean.class) : new UIContextual((Contextual)contextual);
        }
        if ((map = sessionData.getStorageMap()) == null) {
            return null;
        }
        if (map.containsKey(contextual)) {
            ContextualStorage storage = map.get(contextual);
            return storage;
        }
        if (createIfNotExist) {
            VaadinContextualStorage storage = new VaadinContextualStorage(this.getBeanManager(), true);
            map.put((Contextual<?>)contextual, storage);
            return storage;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(UIScopedContext.class.getCanonicalName());
    }
}

