/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.internal.CDIUtil;
import com.vaadin.ui.UI;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public class UIContextual
implements Contextual {
    protected Contextual delegate;
    protected int uiId;
    protected long sessionId;

    public UIContextual(Contextual delegate, long sessionId, int uiId) {
        this.delegate = delegate;
        this.uiId = uiId;
        this.sessionId = sessionId;
    }

    public UIContextual(Contextual delegate, long sessionId) {
        this(delegate, sessionId, UI.getCurrent().getUIId());
    }

    public UIContextual(Contextual delegate) {
        this(delegate, CDIUtil.getSessionId());
    }

    public int getUiId() {
        return this.uiId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UIContextual)) {
            return false;
        }
        UIContextual uiContextual = (UIContextual)o;
        if (this.uiId != uiContextual.uiId) {
            return false;
        }
        return this.sessionId == uiContextual.sessionId;
    }

    public int hashCode() {
        int result = (int)this.sessionId;
        result = 31 * result + this.uiId;
        return result;
    }

    public Object create(CreationalContext context) {
        return this.delegate.create(context);
    }

    public void destroy(Object instance, CreationalContext context) {
        this.delegate.destroy(instance, context);
    }
}

