/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.CDIUI;
import com.vaadin.cdi.CDIView;

public class Conventions {
    public static String deriveMappingForUI(Class<?> beanClass) {
        if (beanClass.isAnnotationPresent(CDIUI.class)) {
            CDIUI annotation = beanClass.getAnnotation(CDIUI.class);
            String mapping = annotation.value();
            if (mapping != null && !"USE CONVENTIONS".equals(mapping)) {
                return mapping;
            }
            mapping = beanClass.getSimpleName().replaceFirst("UI$", "");
            return Conventions.upperCamelToLowerHyphen(mapping);
        }
        return null;
    }

    public static String deriveMappingForView(Class<?> beanClass) {
        if (beanClass.isAnnotationPresent(CDIView.class)) {
            CDIView annotation = beanClass.getAnnotation(CDIView.class);
            if (annotation != null && !"USE CONVENTIONS".equals(annotation.value())) {
                return annotation.value();
            }
            String mapping = beanClass.getSimpleName().replaceFirst("View$", "");
            return Conventions.upperCamelToLowerHyphen(mapping);
        }
        return null;
    }

    public static String upperCamelToLowerHyphen(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
                if (Conventions.shouldPrependHyphen(string, i)) {
                    sb.append('-');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean shouldPrependHyphen(String string, int i) {
        if (i == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(i - 1))) {
            return true;
        }
        return i + 1 < string.length() && !Character.isUpperCase(string.charAt(i + 1));
    }
}

