/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.CDIUI;
import com.vaadin.cdi.URLMapping;
import com.vaadin.cdi.internal.AnnotationUtil;
import com.vaadin.cdi.internal.Conventions;
import com.vaadin.cdi.internal.InconsistentDeploymentException;
import com.vaadin.cdi.server.VaadinCDIServlet;
import com.vaadin.server.VaadinServlet;
import com.vaadin.shared.Version;
import com.vaadin.ui.UI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;

@WebListener
public class ContextDeployer
implements ServletContextListener {
    @Inject
    private BeanManager beanManager;
    private Set<String> configuredUIs;
    private String urlMapping = "/*";

    public void contextInitialized(ServletContextEvent sce) {
        this.verifyCompatibleVaadinVersion();
        this.configuredUIs = new HashSet<String>();
        ServletContext context = sce.getServletContext();
        ContextDeployer.getLogger().info("Initializing web context for path " + context.getContextPath());
        try {
            this.discoverUIMappingsFromAnnotations();
            this.discoverURLMappingFromRoot();
        }
        catch (InconsistentDeploymentException e) {
            ContextDeployer.getLogger().severe("Vaadin CDI servlet deployment failed: " + e.toString());
            throw e;
        }
        this.deployVaadinServlet(context);
        ContextDeployer.getLogger().info("Done deploying Vaadin UIs");
    }

    private Class getVaadinServletDefinedInDeploymentDescriptor(ServletContext context) {
        for (ServletRegistration servletRegistration : context.getServletRegistrations().values()) {
            String servletClassName = servletRegistration.getClassName();
            if (null == servletClassName) continue;
            try {
                Class<?> servletClass;
                if (servletClassName.equals("com.ibm.ws.wsoc.WsocServlet") || !VaadinServlet.class.isAssignableFrom(servletClass = context.getClassLoader().loadClass(servletClassName))) continue;
                return servletClass;
            }
            catch (ClassNotFoundException e) {
                throw new InconsistentDeploymentException(InconsistentDeploymentException.ID.CLASS_NOT_FOUND, e);
            }
        }
        return null;
    }

    private void discoverUIMappingsFromAnnotations() {
        HashSet<String> informativeMapping = new HashSet<String>();
        ContextDeployer.getLogger().info("Discovering Vaadin UIs...");
        Set<Bean<?>> uiBeans = AnnotationUtil.getUiBeans(this.beanManager);
        ContextDeployer.getLogger().info(uiBeans.size() + " beans inheriting from UI discovered!");
        for (Bean<?> uiBean : this.dropBeansWithOutVaadinUIAnnotation(uiBeans)) {
            Class<UI> uiBeanClass = uiBean.getBeanClass().asSubclass(UI.class);
            String uiMapping = Conventions.deriveMappingForUI(uiBeanClass);
            if (this.configuredUIs.contains(uiMapping)) {
                if ("".equals(uiMapping)) {
                    throw new InconsistentDeploymentException(InconsistentDeploymentException.ID.MULTIPLE_ROOTS, "Multiple UIs configured with @CDIUI annotation without context path, only one UI can be root");
                }
                throw new InconsistentDeploymentException(InconsistentDeploymentException.ID.PATH_COLLISION, "Multiple UIs configured with @CDIUI(" + uiMapping + ")");
            }
            this.configuredUIs.add(uiMapping);
            informativeMapping.add("/" + uiMapping + " => " + uiBean.getBeanClass().getSimpleName());
        }
        int numberOfRootUIs = this.getNumberOfRootUIs();
        if (numberOfRootUIs == 1) {
            ContextDeployer.getLogger().info("Vaadin UI " + this.getRootClassName() + " is marked as @CDIUI without context path, " + "this UI is accessible from context root of deployment");
        }
        ContextDeployer.getLogger().info("Available Vaadin UIs for CDI deployment " + informativeMapping);
    }

    private int getNumberOfRootUIs() {
        Set<Bean<?>> beans = AnnotationUtil.getRootUiBeans(this.beanManager);
        return beans.size();
    }

    private String getRootClassName() {
        Set<Bean<?>> beans = AnnotationUtil.getRootUiBeans(this.beanManager);
        return beans.iterator().next().getBeanClass().getCanonicalName();
    }

    private void discoverURLMappingFromRoot() {
        Class rootClass;
        URLMapping urlMappingAnnotation;
        Set<Bean<?>> beans = AnnotationUtil.getRootUiBeans(this.beanManager);
        if (beans != null && !beans.isEmpty() && (urlMappingAnnotation = (rootClass = beans.iterator().next().getBeanClass()).getAnnotation(URLMapping.class)) != null) {
            this.urlMapping = urlMappingAnnotation.value();
            ContextDeployer.getLogger().info("Will map VaadinCDIServlet to '" + this.urlMapping + "'");
        }
    }

    Set<Bean<?>> dropBeansWithOutVaadinUIAnnotation(Set<Bean<?>> uiBeans) {
        HashSet result = new HashSet();
        for (Bean<?> bean : uiBeans) {
            Class beanClass = bean.getBeanClass();
            if (beanClass.isAnnotationPresent(CDIUI.class)) {
                result.add(bean);
                continue;
            }
            ContextDeployer.getLogger().warning("UI without CDIUI annotation found: " + beanClass.getName() + ", it is not available in CDI deployment");
        }
        return result;
    }

    private void deployVaadinServlet(ServletContext context) {
        Class vaadinServletClass = this.getVaadinServletDefinedInDeploymentDescriptor(context);
        if (vaadinServletClass != null) {
            ContextDeployer.getLogger().warning("Vaadin related servlet is defined in deployment descriptor, automated deployment of VaadinCDIServlet is now disabled");
            Class<?> enclosingClass = vaadinServletClass.getEnclosingClass();
            if (!VaadinCDIServlet.class.isAssignableFrom(vaadinServletClass) && enclosingClass != null && enclosingClass.isAnnotationPresent(CDIUI.class)) {
                throw new InconsistentDeploymentException(InconsistentDeploymentException.ID.EMBEDDED_SERVLET, "A Vaadin @CDIUI class should not contain a nested servlet class (" + vaadinServletClass.getCanonicalName() + ") other than a VaadinCDIServlet. In most cases, an appropriate servlet is auto-deployed.");
            }
            return;
        }
        if (this.configuredUIs.isEmpty()) {
            ContextDeployer.getLogger().warning("No Vaadin UI classes with @CDIUI annotation found. Skipping automated deployment of VaadinCDIServlet.");
            return;
        }
        this.registerServletToContext(context);
    }

    private void registerServletToContext(ServletContext context) {
        ContextDeployer.getLogger().info("Registering VaadinServlet with CDIUIProvider");
        VaadinCDIServlet vaadinServlet = new VaadinCDIServlet();
        ServletRegistration.Dynamic registration = context.addServlet("VaadinServlet", (Servlet)vaadinServlet);
        registration.setAsyncSupported(true);
        ContextDeployer.getLogger().info("Mapping " + registration.getName() + " to " + this.urlMapping);
        registration.addMapping(new String[]{this.urlMapping});
        registration.addMapping(new String[]{"/VAADIN/*"});
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ContextDeployer.getLogger().info("Vaadin web context destroyed");
    }

    private static Logger getLogger() {
        return Logger.getLogger(ContextDeployer.class.getCanonicalName());
    }

    private void verifyCompatibleVaadinVersion() {
        boolean compatible = false;
        if (Version.getMajorVersion() > 7) {
            compatible = true;
        } else if (Version.getMajorVersion() == 7) {
            if (Version.getMinorVersion() > 3) {
                compatible = true;
            } else if (Version.getMinorVersion() == 3 && Version.getRevision() >= 1) {
                compatible = true;
            }
        }
        if (!compatible) {
            ContextDeployer.getLogger().warning("This Vaadin version is incompatible with the Vaadin CDI plugin. Vaadin CDI requires at least version 7.3.1, your version is " + Version.getFullVersion());
        }
    }
}

