/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.server.VaadinSession;
import java.util.UUID;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIUtil {
    private static final String[] commonBeanManagerLookups = new String[]{"java:comp/BeanManager", "java:comp/env/BeanManager"};

    public static BeanManager lookupBeanManager() {
        BeanManager beanManager = null;
        try {
            InitialContext initialContext = new InitialContext();
            for (String beanManagerLookup : commonBeanManagerLookups) {
                try {
                    beanManager = (BeanManager)initialContext.lookup(beanManagerLookup);
                    CDIUtil.getLogger().fine("BeanManager found by '" + beanManagerLookup + "'");
                    break;
                }
                catch (NamingException e) {
                    CDIUtil.getLogger().fine("BeanManager was not found by '" + beanManagerLookup + "'");
                }
            }
        }
        catch (NamingException e) {
            CDIUtil.getLogger().warning("Could not instantiate InitialContext");
        }
        if (beanManager == null) {
            CDIUtil.getLogger().severe("Could not get BeanManager through JNDI");
        }
        return beanManager;
    }

    public static long getSessionId() {
        return CDIUtil.getSessionId(VaadinSession.getCurrent());
    }

    public static long getSessionId(VaadinSession session) {
        Long id = (Long)session.getAttribute("cdi-session-id");
        if (id == null) {
            id = UUID.randomUUID().getLeastSignificantBits();
            session.setAttribute("cdi-session-id", (Object)id);
        }
        return id;
    }

    private static Logger getLogger() {
        return Logger.getLogger(CDIUtil.class.getCanonicalName());
    }
}

