/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.CDIUI;
import com.vaadin.cdi.CDIView;
import com.vaadin.cdi.internal.Conventions;
import com.vaadin.navigator.View;
import com.vaadin.ui.UI;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;

public class AnnotationUtil {
    public static Set<Bean<?>> getRootUiBeans(BeanManager beanManager) {
        Set<Bean<?>> uiBeans = AnnotationUtil.getUiBeans(beanManager);
        HashSet rootBeans = new HashSet();
        for (Bean<?> bean : uiBeans) {
            String path;
            Class beanClass = bean.getBeanClass();
            CDIUI uiAnnotation = beanClass.getAnnotation(CDIUI.class);
            if (uiAnnotation == null || null == (path = Conventions.deriveMappingForUI(beanClass)) || !path.isEmpty()) continue;
            rootBeans.add(bean);
        }
        return rootBeans;
    }

    public static Set<Bean<?>> getUiBeans(BeanManager beanManager) {
        Set uiBeans = beanManager.getBeans(UI.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        return uiBeans;
    }

    public static List<String> getCDIViewMappings(BeanManager beanManager) {
        Set viewBeans = beanManager.getBeans(View.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        LinkedList<String> mappingList = new LinkedList<String>();
        for (Bean viewBean : viewBeans) {
            String mapping;
            Class beanClass = viewBean.getBeanClass();
            if (beanClass.getAnnotation(CDIView.class) == null || (mapping = Conventions.deriveMappingForView(viewBean.getBeanClass())) == null) continue;
            mappingList.add(mapping);
        }
        Collections.sort(mappingList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return mappingList;
    }
}

