/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.internal;

import com.vaadin.cdi.internal.CDIUtil;
import com.vaadin.cdi.internal.UIContextual;
import com.vaadin.cdi.internal.VaadinSessionDestroyEvent;
import com.vaadin.cdi.internal.VaadinUICloseEvent;
import com.vaadin.server.VaadinSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public abstract class AbstractVaadinContext
extends AbstractContext {
    private TreeMap<Long, VaadinUICloseEvent> uiCloseQueue = new TreeMap();
    private final Object cleanupLock = new Object();
    private static final int CLEANUP_DELAY = 5000;
    private BeanManager beanManager;
    private Map<Long, SessionData> storageMap = new ConcurrentHashMap<Long, SessionData>();

    public AbstractVaadinContext(BeanManager beanManager) {
        super(beanManager);
        this.beanManager = beanManager;
    }

    public boolean isActive() {
        return true;
    }

    public <T> T get(Contextual<T> bean) {
        return (T)super.get(this.wrapBean(bean));
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        return (T)super.get(this.wrapBean(bean), creationalContext);
    }

    protected <T> Contextual<T> wrapBean(Contextual<T> bean) {
        return bean;
    }

    protected synchronized SessionData getSessionData(VaadinSession session, boolean createIfNotExist) {
        if (session == null) {
            return null;
        }
        long sessionId = CDIUtil.getSessionId(session);
        return this.getSessionData(sessionId, createIfNotExist);
    }

    protected synchronized SessionData getSessionData(boolean createIfNotExist) {
        return this.getSessionData(VaadinSession.getCurrent(), createIfNotExist);
    }

    protected synchronized SessionData getSessionData(long sessionId, boolean createIfNotExist) {
        if (this.storageMap.containsKey(sessionId)) {
            return this.storageMap.get(sessionId);
        }
        if (createIfNotExist) {
            SessionData data = new SessionData();
            this.storageMap.put(sessionId, data);
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropSessionData(VaadinSessionDestroyEvent event) {
        long sessionId = event.getSessionId();
        this.getLogger().fine("Dropping session data for session: " + sessionId);
        SessionData sessionData = this.storageMap.remove(sessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                Map map = sessionData.getUiDataMap();
                for (SessionData.UIData uiData : new ArrayList(map.values())) {
                    this.dropUIData(sessionData, uiData.getUiId());
                }
            }
        }
    }

    private synchronized void dropUIData(SessionData sessionData, int uiId) {
        this.getLogger().fine("Dropping UI data for UI: " + uiId);
        for (Map.Entry<Contextual<?>, ContextualStorage> entry : new ArrayList(sessionData.getStorageMap().entrySet())) {
            Contextual<?> key = entry.getKey();
            if (!(key instanceof UIContextual) || ((UIContextual)key).getUiId() != uiId) continue;
            this.destroy(entry.getKey());
        }
        sessionData.uiDataMap.remove(uiId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueUICloseEvent(VaadinUICloseEvent event) {
        Object object = this.cleanupLock;
        synchronized (object) {
            long closeTime = System.currentTimeMillis() + 5000L;
            while (this.uiCloseQueue.get(closeTime) != null) {
                ++closeTime;
            }
            this.uiCloseQueue.put(closeTime, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uiCloseCleanup() {
        ArrayList<Map.Entry<Long, VaadinUICloseEvent>> entries = null;
        Iterator iterator = this.cleanupLock;
        synchronized (iterator) {
            long l = System.currentTimeMillis();
            SortedMap<Long, VaadinUICloseEvent> subMap = this.uiCloseQueue.headMap(l);
            entries = new ArrayList<Map.Entry<Long, VaadinUICloseEvent>>(subMap.entrySet());
            subMap.clear();
        }
        if (entries != null && !entries.isEmpty()) {
            for (Map.Entry entry : entries) {
                VaadinUICloseEvent event = (VaadinUICloseEvent)entry.getValue();
                SessionData sessionData = this.getSessionData(event.getSessionId(), false);
                if (sessionData == null) continue;
                this.dropUIData(sessionData, event.getUiId());
            }
        }
    }

    protected abstract Logger getLogger();

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    protected static class SessionData {
        private Map<Contextual<?>, ContextualStorage> storageMap = new ConcurrentHashMap();
        private Map<Integer, UIData> uiDataMap = new ConcurrentHashMap<Integer, UIData>();

        public UIData getUIData(int uiId) {
            return this.getUIData(uiId, false);
        }

        public UIData getUIData(int uiId, boolean createIfNotExist) {
            if (this.uiDataMap.containsKey(uiId)) {
                return this.uiDataMap.get(uiId);
            }
            if (createIfNotExist) {
                UIData data = new UIData(uiId);
                this.uiDataMap.put(uiId, data);
                return data;
            }
            return null;
        }

        private Map<Integer, UIData> getUiDataMap() {
            return this.uiDataMap;
        }

        public Map<Contextual<?>, ContextualStorage> getStorageMap() {
            return this.storageMap;
        }

        public static class UIData {
            private int uiId;
            private String activeView = null;
            private String openingView = null;

            public UIData(int uiId) {
                this.uiId = uiId;
            }

            private int getUiId() {
                return this.uiId;
            }

            public String getActiveView() {
                return this.activeView;
            }

            public String getOpeningView() {
                return this.openingView;
            }

            public String getProbableInjectionPointView() {
                if (this.openingView != null) {
                    return this.openingView;
                }
                if (this.activeView != null) {
                    return this.activeView;
                }
                throw new IllegalStateException("Can't find proper view for @ViewScoped bean, no views are active for this ui.");
            }

            public void setOpeningView(String openingView) {
                this.openingView = openingView;
            }

            public void validateTransition() {
                if (this.openingView != null) {
                    this.activeView = this.openingView;
                    this.openingView = null;
                }
            }

            public void clearPendingViewChange() {
                this.openingView = null;
            }
        }
    }
}

