/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.access;

import com.vaadin.cdi.access.AccessControl;
import com.vaadin.server.VaadinServletService;
import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

@Default
public class JaasAccessControl
extends AccessControl
implements Serializable {
    @Override
    public boolean isUserSignedIn() {
        Principal principal = JaasAccessControl.getCurrentRequest().getUserPrincipal();
        return principal != null;
    }

    @Override
    public boolean isUserInRole(String role) {
        return JaasAccessControl.getCurrentRequest().isUserInRole(role);
    }

    @Override
    public String getPrincipalName() {
        Principal principal = JaasAccessControl.getCurrentRequest().getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public static void login(String username, String password) throws ServletException {
        JaasAccessControl.getCurrentRequest().login(username, password);
    }

    public static void logout() throws ServletException {
        JaasAccessControl.getCurrentRequest().logout();
    }

    @RequestScoped
    public static HttpServletRequest getCurrentRequest() {
        HttpServletRequest request = VaadinServletService.getCurrentServletRequest();
        JaasAccessControl.getLogger().info("Getting request " + request);
        return request;
    }

    private static Logger getLogger() {
        return Logger.getLogger(JaasAccessControl.class.getCanonicalName());
    }
}

