/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.CDIView;
import com.vaadin.cdi.access.AccessControl;
import com.vaadin.cdi.internal.AnnotationUtil;
import com.vaadin.cdi.internal.CDIUtil;
import com.vaadin.cdi.internal.Conventions;
import com.vaadin.cdi.internal.VaadinViewChangeCleanupEvent;
import com.vaadin.cdi.internal.VaadinViewChangeEvent;
import com.vaadin.cdi.internal.VaadinViewCreationEvent;
import com.vaadin.cdi.internal.ViewBean;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.ui.UI;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.security.DenyAll;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;

public class CDIViewProvider
implements ViewProvider {
    private static final Annotation QUALIFIER_ANY = new AnnotationLiteral<Any>(){};
    @Inject
    private BeanManager beanManager;
    private static ThreadLocal<VaadinViewChangeCleanupEvent> cleanupEvent = new ThreadLocal();
    @Inject
    private AccessControl accessControl;
    private transient CreationalContext<?> currentViewCreationalContext;
    private ViewChangeListener viewChangeListener;

    @PostConstruct
    private void postConstruct() {
        this.viewChangeListener = new ViewChangeListenerImpl(this.beanManager);
    }

    public String getViewName(String viewAndParameters) {
        CDIViewProvider.getLogger().log(Level.FINE, "Attempting to retrieve view name from string \"{0}\"", viewAndParameters);
        String name = this.parseViewName(viewAndParameters);
        ViewBean viewBean = this.getViewBean(name);
        if (viewBean == null) {
            return null;
        }
        if (this.isUserHavingAccessToView(viewBean)) {
            String specifiedViewName;
            if (viewBean.getBeanClass().isAnnotationPresent(CDIView.class) && !(specifiedViewName = Conventions.deriveMappingForView(viewBean.getBeanClass())).isEmpty()) {
                return specifiedViewName;
            }
            return name;
        }
        CDIViewProvider.getLogger().log(Level.INFO, "User {0} did not have access to view \"{1}\"", new Object[]{this.accessControl.getPrincipalName(), viewBean});
        return null;
    }

    protected boolean isUserHavingAccessToView(Bean<?> viewBean) {
        if (viewBean.getBeanClass().isAnnotationPresent(CDIView.class)) {
            if (viewBean.getBeanClass().isAnnotationPresent(DenyAll.class)) {
                return false;
            }
            if (!viewBean.getBeanClass().isAnnotationPresent(RolesAllowed.class)) {
                return true;
            }
            RolesAllowed rolesAnnotation = viewBean.getBeanClass().getAnnotation(RolesAllowed.class);
            boolean hasAccess = this.accessControl.isUserInSomeRole(rolesAnnotation.value());
            CDIViewProvider.getLogger().log(Level.FINE, "Checking if user {0} is having access to {1}: {2}", new Object[]{this.accessControl.getPrincipalName(), viewBean, Boolean.toString(hasAccess)});
            return hasAccess;
        }
        return true;
    }

    private ViewBean getViewBean(String viewName) {
        CDIViewProvider.getLogger().log(Level.FINE, "Looking for view with name \"{0}\"", viewName);
        if (viewName == null) {
            return null;
        }
        HashSet matching = new HashSet();
        Set all = this.beanManager.getBeans(View.class, new Annotation[]{QUALIFIER_ANY});
        if (all.isEmpty()) {
            CDIViewProvider.getLogger().severe("No Views found! Please add at least one class implementing the View interface.");
            return null;
        }
        for (Bean bean : all) {
            Class beanClass = bean.getBeanClass();
            CDIView viewAnnotation = beanClass.getAnnotation(CDIView.class);
            if (viewAnnotation == null) continue;
            String mapping = Conventions.deriveMappingForView(beanClass);
            CDIViewProvider.getLogger().log(Level.FINER, "{0} is annotated, the viewName is \"{1}\"", new Object[]{beanClass.getName(), mapping});
            if (!viewName.equals(mapping)) continue;
            matching.add(bean);
            CDIViewProvider.getLogger().log(Level.FINER, "Bean {0} with viewName \"{1}\" is one alternative", new Object[]{bean, mapping});
        }
        Set<Bean<?>> viewBeansForThisProvider = this.getViewBeansForCurrentUI(matching);
        if (viewBeansForThisProvider.isEmpty()) {
            CDIViewProvider.getLogger().log(Level.WARNING, "No view beans found for current UI");
            return null;
        }
        if (viewBeansForThisProvider.size() > 1) {
            throw new RuntimeException("Multiple views mapped with same name for same UI");
        }
        return new ViewBean(viewBeansForThisProvider.iterator().next(), viewName);
    }

    private Set<Bean<?>> getViewBeansForCurrentUI(Set<Bean<?>> beans) {
        HashSet viewBeans = new HashSet();
        block0: for (Bean<?> bean : beans) {
            CDIView viewAnnotation = bean.getBeanClass().getAnnotation(CDIView.class);
            if (viewAnnotation == null) continue;
            List<Class<? extends UI>> uiClasses = Arrays.asList(viewAnnotation.uis());
            if (uiClasses.contains(UI.class)) {
                viewBeans.add(bean);
                continue;
            }
            Class<?> currentUI = UI.getCurrent().getClass();
            for (Class<? extends UI> uiClass : uiClasses) {
                if (!uiClass.isAssignableFrom(currentUI)) continue;
                viewBeans.add(bean);
                continue block0;
            }
        }
        return viewBeans;
    }

    public View getView(String viewName) {
        CDIViewProvider.getLogger().log(Level.FINE, "Attempting to retrieve view with name \"{0}\"", viewName);
        long sessionId = CDIUtil.getSessionId();
        UI currentUI = UI.getCurrent();
        if (currentUI == null) {
            CDIViewProvider.getLogger().log(Level.WARNING, "No current UI - cannot create view {0}", viewName);
            throw new IllegalStateException("Cannot create View " + viewName + " - current UI is not set");
        }
        ViewBean viewBean = this.getViewBean(viewName);
        if (viewBean != null) {
            if (!this.isUserHavingAccessToView(viewBean)) {
                CDIViewProvider.getLogger().log(Level.INFO, "User {0} did not have access to view {1}", new Object[]{this.accessControl.getPrincipalName(), viewBean});
                return null;
            }
            if (this.currentViewCreationalContext != null) {
                CDIViewProvider.getLogger().log(Level.FINER, "Releasing creational context for current view {0}", this.currentViewCreationalContext);
                this.currentViewCreationalContext.release();
            }
            this.currentViewCreationalContext = this.beanManager.createCreationalContext((Contextual)viewBean);
            CDIViewProvider.getLogger().log(Level.FINER, "Created new creational context for current view {0}", this.currentViewCreationalContext);
            this.beanManager.fireEvent((Object)new VaadinViewCreationEvent(sessionId, currentUI.getUIId(), viewName), new Annotation[0]);
            cleanupEvent.set(new VaadinViewChangeCleanupEvent(sessionId, currentUI.getUIId()));
            View view = (View)this.beanManager.getReference((Bean)viewBean, viewBean.getBeanClass(), this.currentViewCreationalContext);
            CDIViewProvider.getLogger().log(Level.FINE, "Returning view instance {0}", view.toString());
            Navigator navigator = currentUI.getNavigator();
            if (navigator != null) {
                navigator.removeViewChangeListener(this.viewChangeListener);
                navigator.addViewChangeListener(this.viewChangeListener);
            }
            return view;
        }
        throw new RuntimeException("Unable to instantiate view");
    }

    @PreDestroy
    protected void destroy() {
        if (this.currentViewCreationalContext != null) {
            CDIViewProvider.getLogger().log(Level.FINE, "CDIViewProvider is being destroyed, releasing creational context for current view");
            this.currentViewCreationalContext.release();
        }
    }

    private String parseViewName(String viewAndParameters) {
        String viewName = viewAndParameters;
        if (viewName.startsWith("!")) {
            viewName = viewName.substring(1);
        }
        for (String name : AnnotationUtil.getCDIViewMappings(this.beanManager)) {
            if (!viewName.equals(name) && !viewName.startsWith(name + "/")) continue;
            return name;
        }
        return null;
    }

    public static VaadinViewChangeCleanupEvent getCleanupEvent() {
        return cleanupEvent.get();
    }

    public static void removeCleanupEvent() {
        cleanupEvent.remove();
    }

    private static Logger getLogger() {
        return Logger.getLogger(CDIViewProvider.class.getCanonicalName());
    }

    public static final class ViewChangeListenerImpl
    implements ViewChangeListener {
        private BeanManager beanManager;

        public ViewChangeListenerImpl(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            CDIViewProvider.getLogger().fine("Changing view from " + event.getOldView() + " to " + event.getNewView());
            long sessionId = CDIUtil.getSessionId();
            int uiId = event.getNavigator().getUI().getUIId();
            String viewName = event.getViewName();
            this.beanManager.fireEvent((Object)new VaadinViewChangeEvent(sessionId, uiId, viewName), new Annotation[0]);
        }
    }
}

