/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi;

import com.vaadin.cdi.CDIUI;
import com.vaadin.cdi.internal.AnnotationUtil;
import com.vaadin.cdi.internal.CDIUtil;
import com.vaadin.cdi.internal.Conventions;
import com.vaadin.cdi.internal.UIBean;
import com.vaadin.cdi.internal.VaadinUICloseEvent;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.DefaultUIProvider;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;

public class CDIUIProvider
extends DefaultUIProvider
implements Serializable {
    private static final Annotation QUALIFIER_ANY = new AnnotationLiteral<Any>(){};
    private BeanManager beanManager = null;

    public BeanManager getBeanManager() {
        if (this.beanManager == null) {
            CDIUIProvider.getLogger().fine("CDIUIProvider is not injected, using JNDI lookup");
            this.beanManager = CDIUtil.lookupBeanManager();
        }
        return this.beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UI createInstance(UICreateEvent uiCreateEvent) {
        CDIUIProvider.getLogger().fine("Creating new UI instance");
        Class type = uiCreateEvent.getUIClass();
        int uiId = uiCreateEvent.getUiId();
        VaadinRequest request = uiCreateEvent.getRequest();
        Bean<?> bean = this.scanForBeans(type, request);
        UIBean uiBean = new UIBean(bean, uiId);
        try {
            CurrentInstance.set(UIBean.class, (Object)uiBean);
            UI ui = (UI)this.getBeanManager().getReference((Bean)uiBean, (Type)type, this.getBeanManager().createCreationalContext(bean));
            ui.addDetachListener((ClientConnector.DetachListener)new DetachListenerImpl(this.getBeanManager()));
            UI uI = ui;
            return uI;
        }
        finally {
            CurrentInstance.set(UIBean.class, null);
        }
    }

    public Class<? extends UI> getUIClass(UIClassSelectionEvent selectionEvent) {
        VaadinRequest request = selectionEvent.getRequest();
        String uiMapping = this.parseUIMapping(request);
        if (this.isRoot(request)) {
            return this.rootUI();
        }
        Bean<?> uiBean = this.getUIBeanWithMapping(uiMapping);
        if (uiBean != null) {
            return uiBean.getBeanClass().asSubclass(UI.class);
        }
        if (uiMapping.isEmpty()) {
            return super.getUIClass(selectionEvent);
        }
        return null;
    }

    boolean isRoot(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        return pathInfo.equals("/");
    }

    Class<? extends UI> rootUI() {
        Set<Bean<?>> rootBeans = AnnotationUtil.getRootUiBeans(this.getBeanManager());
        if (rootBeans.isEmpty()) {
            return null;
        }
        if (rootBeans.size() > 1) {
            StringBuilder errorMessage = new StringBuilder();
            for (Bean<?> bean : rootBeans) {
                errorMessage.append(bean.getBeanClass().getName());
                errorMessage.append("\n");
            }
            throw new IllegalStateException("Multiple beans are annotated with @CDIUI without context path: " + errorMessage.toString());
        }
        Bean<?> uiBean = rootBeans.iterator().next();
        Class rootUI = uiBean.getBeanClass();
        return rootUI.asSubclass(UI.class);
    }

    private Bean<?> getUIBeanWithMapping(String mapping) {
        Set<Bean<?>> beans = AnnotationUtil.getUiBeans(this.getBeanManager());
        for (Bean<?> bean : beans) {
            String computedMapping;
            Class<UI> beanClass;
            if (!UI.class.isAssignableFrom(bean.getBeanClass()) || !(beanClass = bean.getBeanClass().asSubclass(UI.class)).isAnnotationPresent(CDIUI.class) || !mapping.equals(computedMapping = Conventions.deriveMappingForUI(beanClass))) continue;
            return bean;
        }
        return null;
    }

    private Bean<?> scanForBeans(Class<? extends UI> type, VaadinRequest request) {
        BeanManager beanManager = this.getBeanManager();
        Bean<?> bean = null;
        Set beans = beanManager.getBeans(type, new Annotation[]{QUALIFIER_ANY});
        if (beans.isEmpty()) {
            CDIUIProvider.getLogger().warning("Could not find UI bean for " + type.getCanonicalName());
            return null;
        }
        try {
            bean = beanManager.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            bean = null;
        }
        String uiMapping = "";
        if (bean == null) {
            if (type.isAnnotationPresent(CDIUI.class)) {
                uiMapping = this.parseUIMapping(request);
                bean = this.getUIBeanWithMapping(uiMapping);
            } else {
                throw new IllegalStateException("UI class: " + type.getName() + " with mapping: " + uiMapping + " is not annotated with CDIUI!");
            }
        }
        return bean;
    }

    String parseUIMapping(VaadinRequest request) {
        return this.parseUIMapping(request.getPathInfo());
    }

    String parseUIMapping(String requestPath) {
        if (requestPath != null && requestPath.length() > 1) {
            String path = requestPath;
            if (requestPath.endsWith("/")) {
                path = requestPath.substring(0, requestPath.length() - 1);
            }
            if (!path.contains("!")) {
                int lastIndex = path.lastIndexOf(47);
                return path.substring(lastIndex + 1);
            }
            int lastIndexOfBang = path.lastIndexOf(33);
            String pathWithoutView = path.substring(0, lastIndexOfBang - 1);
            int lastSlashIndex = pathWithoutView.lastIndexOf(47);
            return pathWithoutView.substring(lastSlashIndex + 1);
        }
        return "";
    }

    private static Logger getLogger() {
        return Logger.getLogger(CDIUIProvider.class.getCanonicalName());
    }

    public static final class DetachListenerImpl
    implements ClientConnector.DetachListener {
        private BeanManager beanManager;

        public DetachListenerImpl(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        public void detach(ClientConnector.DetachEvent event) {
            Object source = event.getSource();
            if (source instanceof UI) {
                UI ui = (UI)source;
                this.beanManager.fireEvent((Object)new VaadinUICloseEvent(CDIUtil.getSessionId(ui.getSession()), ui.getUIId()), new Annotation[0]);
            }
        }
    }
}

