/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.button;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.internal.DisableOnClickController;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-button")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.7"), @NpmPackage(value="@vaadin/button", version="24.9.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/button/src/vaadin-button.js")})
public class Button
extends Component
implements ClickNotifier<Button>,
Focusable<Button>,
HasAriaLabel,
HasEnabled,
HasPrefix,
HasSize,
HasStyle,
HasSuffix,
HasText,
HasThemeVariant<ButtonVariant>,
HasTooltip {
    private Component iconComponent;
    private boolean iconAfterText;
    private final DisableOnClickController<Button> disableOnClickController = new DisableOnClickController((Component)this);

    public Button() {
    }

    public Button(String text) {
        this.setText(text);
    }

    public Button(Component icon) {
        this.setIcon(icon);
    }

    public Button(String text, Component icon) {
        this.setIcon(icon);
        this.setText(text);
    }

    public Button(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public Button(Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setIcon(icon);
        this.addClickListener(clickListener);
    }

    public Button(String text, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setIcon(icon);
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public void setText(String text) {
        this.removeAll(this.getNonTextNodes());
        if (text != null && !text.isEmpty()) {
            this.getElement().appendChild(new Element[]{Element.createText((String)text)});
        }
        this.updateThemeAttribute();
    }

    public void setIcon(Component icon) {
        if (icon != null && icon.getElement().isTextNode()) {
            throw new IllegalArgumentException("Text node can't be used as an icon.");
        }
        if (this.iconComponent != null) {
            this.remove(this.iconComponent);
        }
        this.iconComponent = icon;
        if (icon != null) {
            this.add(icon);
            this.updateIconSlot();
        }
        this.updateThemeAttribute();
    }

    public Component getIcon() {
        return this.iconComponent;
    }

    public void setIconAfterText(boolean iconAfterText) {
        this.iconAfterText = iconAfterText;
        if (this.iconComponent != null) {
            this.updateIconSlot();
        }
    }

    public boolean isIconAfterText() {
        return this.iconAfterText;
    }

    public void click() {
        if (this.isEnabled()) {
            this.fireEvent((ComponentEvent)new ClickEvent((Component)this, false, 0, 0, 0, 0, 0, 0, false, false, false, false));
        }
    }

    public void clickInClient() {
        this.getElement().callJsFunction("click", new Serializable[0]);
    }

    private void add(Component ... components) {
        assert (components != null);
        for (Component component : components) {
            assert (component != null);
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setDisableOnClick(boolean disableOnClick) {
        this.disableOnClickController.setDisableOnClick(disableOnClick);
    }

    public boolean isDisableOnClick() {
        return this.disableOnClickController.isDisableOnClick();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.disableOnClickController.onSetEnabled(enabled);
    }

    public ShortcutRegistration addFocusShortcut(Key key, KeyModifier ... keyModifiers) {
        ShortcutRegistration registration = super.addFocusShortcut(key, keyModifiers);
        if (this.isFeatureFlagEnabled(FeatureFlags.ACCESSIBLE_DISABLED_BUTTONS)) {
            registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        }
        return registration;
    }

    public Registration addFocusListener(ComponentEventListener<FocusNotifier.FocusEvent<Button>> listener) {
        return this.getEventBus().addListener(FocusNotifier.FocusEvent.class, listener, registration -> {
            if (this.isFeatureFlagEnabled(FeatureFlags.ACCESSIBLE_DISABLED_BUTTONS)) {
                registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
            }
        });
    }

    public Registration addBlurListener(ComponentEventListener<BlurNotifier.BlurEvent<Button>> listener) {
        return this.getEventBus().addListener(BlurNotifier.BlurEvent.class, listener, registration -> {
            if (this.isFeatureFlagEnabled(FeatureFlags.ACCESSIBLE_DISABLED_BUTTONS)) {
                registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
            }
        });
    }

    private void updateIconSlot() {
        this.iconComponent.getElement().setAttribute("slot", this.iconAfterText ? "suffix" : "prefix");
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    private void removeAll(Element ... exclusion) {
        Set toExclude = Stream.of(exclusion).collect(Collectors.toSet());
        Predicate<Element> filter = toExclude::contains;
        this.getElement().getChildren().filter(filter.negate()).forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
        this.getElement().appendChild(exclusion);
    }

    private Element[] getNonTextNodes() {
        return (Element[])this.getElement().getChildren().filter(element -> !element.isTextNode()).toArray(Element[]::new);
    }

    private void updateThemeAttribute() {
        long childCount = this.getElement().getChildren().filter(el -> el.isTextNode() || !"vaadin-tooltip".equals(el.getTag())).count();
        if (childCount == 1L && this.iconComponent != null) {
            this.getThemeNames().add((Object)"icon");
        } else {
            this.getThemeNames().remove((Object)"icon");
        }
    }

    private boolean isFeatureFlagEnabled(Feature feature) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            return false;
        }
        return FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext()).isEnabled(feature);
    }
}

