/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.applayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.applayout.MenuItemClickEvent;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class AppLayoutMenuItem
extends Tab {
    private Component icon;
    private String title;
    private String route;

    public AppLayoutMenuItem(String title) {
        this((Component)null, title);
    }

    public AppLayoutMenuItem(Component icon) {
        this(icon, (String)null);
    }

    public AppLayoutMenuItem(Component icon, String title) {
        this.addMenuItemClickListener((ComponentEventListener<MenuItemClickEvent>)(ComponentEventListener & Serializable)event -> {
            if (this.getRoute() != null) {
                this.getUI().ifPresent(ui -> ui.navigate(this.route));
            }
        });
        this.updateTitleAndIcon(icon, title);
    }

    public AppLayoutMenuItem(String title, String route) {
        this(null, title, route);
    }

    public AppLayoutMenuItem(Component icon, String title, String route) {
        this(icon, title);
        this.setRoute(route);
    }

    public AppLayoutMenuItem(Component icon, ComponentEventListener<MenuItemClickEvent> listener) {
        this(icon, null, listener);
    }

    public AppLayoutMenuItem(String title, ComponentEventListener<MenuItemClickEvent> listener) {
        this(null, title, listener);
    }

    public AppLayoutMenuItem(Component icon, String title, ComponentEventListener<MenuItemClickEvent> listener) {
        this(icon, title);
        this.addMenuItemClickListener(listener);
    }

    public Component getIcon() {
        return this.icon;
    }

    public void setIcon(Component icon) {
        this.updateTitleAndIcon(icon, this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.updateTitleAndIcon(this.icon, title);
    }

    private void updateTitleAndIcon(Component icon, String title) {
        this.removeAll();
        if (icon != null) {
            icon.getElement().setAttribute("role", "img");
            this.add(new Component[]{icon});
        }
        if (title != null) {
            this.getElement().setAttribute("title", title);
            this.add(new Component[]{new Span(title)});
        } else {
            this.getElement().removeAttribute("title");
        }
        this.icon = icon;
        this.title = title;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getRoute() {
        return this.route;
    }

    public Registration addMenuItemClickListener(ComponentEventListener<MenuItemClickEvent> listener) {
        return this.addListener(MenuItemClickEvent.class, listener);
    }

    void fireMenuItemClickEvent() {
        this.fireEvent(new MenuItemClickEvent(this, false));
    }
}

