package com.vaadin.uitest.model.scenario;

import java.util.List;
import java.util.stream.Collectors;

public class TestScenario {
    private String description;
    private List<TestScenarioStep> steps;

    public TestScenario() {
    }

    public TestScenario(String description, List<TestScenarioStep> steps) {
        this.description = description;
        this.steps = steps;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TestScenarioStep> getSteps() {
        return steps;
    }

    public void setSteps(List<TestScenarioStep> steps) {
        this.steps = steps;
    }

    @Override
    public String toString() {
        return description + "\n"
                + steps.stream().map(TestScenarioStep::toString)
                        .collect(Collectors.joining("\n"));
    }
}
