package com.vaadin.uitest.generator.utils;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class NpmUtils {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(NpmUtils.class);

    private static String PACKAGE = "package.json";

    public static boolean addPackageProperty(String baseDir, String parent,
            String prop, String val) throws IOException {

        ObjectMapper mapper = new ObjectMapper();
        File packageJson = new File(baseDir, PACKAGE);
        String json = FileUtils.readFileToString(packageJson, "UTF-8");
        JsonNode root = mapper.readTree(json);

        JsonNode node = root.get(parent);
        if (node == null) {
            node = mapper.createObjectNode();
            ((ObjectNode) root).set(parent, node);
        }
        JsonNode jsonNode = node.get(prop);
        if (jsonNode != null && jsonNode.asText().equals(val)) {
            return false;
        }
        ((ObjectNode) node).put(prop, val);

        mapper.enable(SerializationFeature.INDENT_OUTPUT);

        String str = mapper.writer(new DefaultPrettyPrinter() {
            @Override
            public DefaultPrettyPrinter createInstance() {
                this._objectFieldValueSeparatorWithSpaces = ": ";
                return this;
            }
        }).writeValueAsString(root);

        FileUtils.writeStringToFile(packageJson, str + '\n', "UTF-8");
        LOGGER.info("Updated {} file by adding the line: {} -> {} -> {}",
                PACKAGE, parent, prop, val);
        return true;

    }
}