package com.vaadin.uitest.model.scenario;

public class TestScenarioStep {
    private TestScenarioStepType type;
    private String step;
    private String description;
    private String jsSnippet;
    private String pwSnippet;
    private String resultHtml;

    public TestScenarioStep() {
    }

    public TestScenarioStep(TestScenarioStepType type, String description) {
        this.type = type;

        String[] split = description
                .split(" *(Or)? *(Checked|Fired) By Executing (JS|PWJ) *");
        this.description = split[0];
        if (split.length > 1) {
            this.jsSnippet = split[1].replaceAll("^`", "").replaceAll("`$", "");
        }
        if (split.length > 2) {
            this.pwSnippet = split[2].replaceAll("^`", "").replaceAll("`$", "");
        }
    }

    public TestScenarioStepType getType() {
        return type;
    }

    public void setType(TestScenarioStepType type) {
        this.type = type;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStep() {
        return step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public String getJsSnippet() {
        return jsSnippet;
    }

    public void setJsSnippet(String jsSnippet) {
        this.jsSnippet = jsSnippet;
    }

    public String getPwSnippet() {
        return pwSnippet;
    }

    public void setPwSnippet(String pwSnippet) {
        this.pwSnippet = pwSnippet;
    }

    public String getResultHtml() {
        return resultHtml;
    }

    public void setResultHtml(String resultHtml) {
        this.resultHtml = resultHtml;
    }

    @Override
    public String toString() {
        return type + " " + description
                + (jsSnippet != null ? "\n    JS-sel: " + jsSnippet : "")
                + (pwSnippet != null ? "\n    PW-sel: " + pwSnippet : "")
                + (resultHtml != null ? "\n    Result: " + resultHtml : "");
    }
}
