package com.vaadin.uitest.model;

import java.io.File;

import org.apache.commons.io.FilenameUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.uitest.model.scenario.TestScenarios;

/**
 * Represents a component that it's a view in the app
 */
public class UiRoute {
    private String projectRoot;
    private String className;
    private String tagName;
    private String route;
    private String routeExpression;
    private String layoutClass;
    private String file;
    private String framework;
    private String source;
    private String testsDir;
    private String testfile;
    private String testClass;
    private String baseUrl;

    private String html;
    private String gherkin;
    private TestScenarios testScenarios;

    public UiRoute() {
    }

    public UiRoute(String className, String tagName, String route) {
        this.className = className;
        this.tagName = tagName;
        this.route = route == null ? null
                : route.replaceFirst("^/*([^/]*)((/:|\\?|#).*$)?", "$1");
        this.routeExpression = route;
    }

    public String getProjectRoot() {
        return projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public String getClassName() {
        return className;
    }

    public String getTagName() {
        return tagName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @JsonIgnore
    public String getSimpleName() {
        return getClassName().replaceFirst("^.*\\.", "");
    }

    public String getLayoutClass() {
        return layoutClass;
    }

    public String getRoute() {
        return route;
    }

    public String getRouteExpression() {
        return routeExpression;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getBaseUrl() {
        return baseUrl == null ? "http://localhost:8080/" : baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setRouteExpression(String routeExpression) {
        this.routeExpression = routeExpression;
    }

    public void setLayoutClass(String layoutClass) {
        this.layoutClass = layoutClass;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getHtml() {
        return html == null ? "" : html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getGherkin() {
        return gherkin;
    }

    public void setGherkin(String gherkin) {
        this.gherkin = gherkin;
    }

    public TestScenarios getTestScenarios() {
        return testScenarios;
    }

    public void setTestScenarios(TestScenarios testScenarios) {
        this.testScenarios = testScenarios;
    }

    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFramework() {
        if (framework == null && file != null) {
            if (file.endsWith(".java")) {
                framework = "flow";
            } else if (file.endsWith(".tsx")) {
                framework = "react";
            } else if (file.endsWith(".ts")) {
                framework = "lit";
            }
        }
        return framework;
    }

    public void computeTestName(File testsDir, TestFramework testFramework) {
        if (testFramework == null) {
            Framework fw = Framework.getByValue(getFramework());
            testFramework = fw.getDefaultTestFramework();
        }
        String name = null;
        if (TestFramework.PLAYWRIGHT_JAVA.equals(testFramework)) {
            name = getClassName().replace(".", "/") + "IT.java";
            testClass = getClassName() + "IT";
        } else if (TestFramework.PLAYWRIGHT_NODE.equals(testFramework)) {
            if (testsDir.toString().endsWith("java")) {
                testsDir = testsDir.getParentFile();
            }
            testsDir = new File(testsDir, "frontend");
            FilenameUtils.getBaseName(getFile());

            name = getFile();
            name = name.replace('\\', '/')
                    .replaceFirst("^(.*?/|)(frontend/)(.*)\\.tsx?$", "$3");
            name += ".spec.ts";
            testClass = getClassName();
        }
        if (name != null) {
            testfile = new File(".").toURI()
                    .relativize(new File(testsDir, name).toURI()).getPath();
        }
        this.testsDir = testsDir.getPath().replace('\\', '/');
    }

    public void setFramework(String framework) {
        this.framework = framework;
        getFramework();
    }

    public String getTestfile() {
        return testfile;
    }

    public void setTestfile(String testfile) {
        this.testfile = testfile;
    }

    public String getTestsDir() {
        return testsDir;
    }

    public String getTestClass() {
        return testClass;
    }

    public void setTestClass(String testClass) {
        this.testClass = testClass;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + gherkin;
    }
}