package com.vaadin.uitest.generator.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MvnUtils {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(MvnUtils.class);

    public static boolean addMavenDependency(String pom, String groupId,
            String artifactId, String version, String scope) throws Exception {
        File pomFile = new File(pom);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(pomFile);

        Node projectNode = getOrCreateNode(doc, doc, "project", null, null);
        Node dependenciesNode = getOrCreateNode(doc, projectNode,
                "dependencies", null, null);

        Node dependencyNode = getOrCreateNode(doc, dependenciesNode,
                "dependency", "groupId", groupId, "artifactId", artifactId);

        boolean save = assureTagValue(doc, dependencyNode, "version", version);
        save = scope != null
                && assureTagValue(doc, dependencyNode, "scope", scope) || save;
        if (save) {
            LOGGER.info("Updated pom.xml file by adding dependency: {}:{}:{}",
                    groupId, artifactId, version);
            saveProject(doc, pomFile);
        }
        return save;
    }

    public static boolean addMavenExecPlugin(String pom) throws Exception {
        File pomFile = new File(pom);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(pomFile);
        Node root = doc.getDocumentElement();
        Node profilesNode = getOrCreateNode(doc, root, "profiles");
        Node profileNode = getOrCreateNode(doc, profilesNode, "profile", "id",
                "it");
        Node buildNode = getOrCreateNode(doc, profileNode, "build");
        Node pluginsNode = getOrCreateNode(doc, buildNode, "plugins");

        if (getNodes(doc, pluginsNode, "plugin", "artifactId",
                "exec-maven-plugin", null, null).size() > 0) {
            return false;
        }
        LOGGER.info(
                "Updating pom.xml file by adding the plugin org.codehaus.mojo:exec-maven-plugin to execute hilla tests");

        Node pluginNode = getOrCreateNode(doc, pluginsNode, "plugin",
                "artifactId", "exec-maven-plugin");
        setOrUpdateElement(doc, pluginNode, "groupId", "org.codehaus.mojo");

        Node executionsNode = getOrCreateNode(doc, pluginNode, "executions");
        Node executionNode = getOrCreateNode(doc, executionsNode, "execution",
                "id", "run hilla tests");

        Node goalsNode = getOrCreateNode(doc, executionNode, "goals");
        setOrUpdateElement(doc, goalsNode, "goal", "exec");

        setOrUpdateElement(doc, executionNode, "phase", "integration-test");

        Node configurationNode = getOrCreateNode(doc, executionNode,
                "configuration");
        setOrUpdateElement(doc, configurationNode, "executable", "npm");

        Node argumentsNode = getOrCreateNode(doc, configurationNode,
                "arguments");
        setOrUpdateElement(doc, argumentsNode, "argument", "test");

        saveProject(doc, pomFile);
        return true;
    }

    public static boolean addMavenFailsafePlugin(String pom) throws Exception {
        File pomFile = new File(pom);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(pomFile);
        Node root = doc.getDocumentElement();
        Node profilesNode = getOrCreateNode(doc, root, "profiles");
        Node profileNode = getOrCreateNode(doc, profilesNode, "profile", "id",
                "it");
        Node buildNode = getOrCreateNode(doc, profileNode, "build");
        Node pluginsNode = getOrCreateNode(doc, buildNode, "plugins");

        if (getNodes(doc, pluginsNode, "plugin", "artifactId",
                "maven-failsafe-plugin", null, null).size() > 0) {
            return false;
        }
        LOGGER.info(
                "Updating pom.xml file by adding the plugin org.apache.maven.plugins:exec-maven-plugin to execute hilla tests");

        Node pluginNode = getOrCreateNode(doc, pluginsNode, "plugin",
                "artifactId", "maven-failsafe-plugin");
        setOrUpdateElement(doc, pluginNode, "groupId",
                "org.apache.maven.plugins");

        Node executionsNode = getOrCreateNode(doc, pluginNode, "executions");
        Node executionNode = getOrCreateNode(doc, executionsNode, "execution");

        Node goalsNode = getOrCreateNode(doc, executionNode, "goals");
        setOrUpdateElement(doc, goalsNode, "goal", "integration-test");
        setOrUpdateElement(doc, goalsNode, "goal", "verify");

        Node configurationNode = getOrCreateNode(doc, executionNode,
                "configuration");
        setOrUpdateElement(doc, configurationNode, "trimStackTrace", "false");
        setOrUpdateElement(doc, configurationNode, "enableAssertions", "true");

        saveProject(doc, pomFile);
        return true;
    }

    private static void saveProject(Document doc, File file)
            throws FileNotFoundException, TransformerException {

        TransformerFactory transformerFactory = TransformerFactory
                .newInstance();
        Transformer transformer = transformerFactory
                .newTransformer(new StreamSource(IOUtils.toInputStream(""
                        + "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n"
                        + "  <xsl:output indent=\"yes\"/>\n"
                        + "  <xsl:strip-space elements=\"*\"/>\n"
                        + "  <xsl:template match=\"@*|node()\">\n"
                        + "    <xsl:copy>\n"
                        + "      <xsl:apply-templates select=\"@*|node()\"/>\n"
                        + "    </xsl:copy>\n" + "  </xsl:template>\n"
                        + "</xsl:stylesheet>\n" + "", "UTF-8")));
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new FileOutputStream(file));
        transformer.transform(source, result);
    }

    private static void setOrUpdateElement(Document doc, Node parent,
            String tagName, String textContent) {
        NodeList nodes = ((Element) parent).getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            nodes.item(0).setTextContent(textContent);
        } else {
            Element elem = doc.createElement(tagName);
            elem.setTextContent(textContent);
            parent.appendChild(elem);
        }
    }

    private static List<Node> getNodes(Document doc, Node node, String name,
            String tag, String value, String tag2, String value2) {
        List<Node> ret = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); i++) {
            Node child = children.item(i);
            if (name.equals(child.getNodeName())) {
                if (tag == null || value == null) {
                    ret.add(child);
                    continue;
                }
                if (child.getNodeType() == Node.ELEMENT_NODE) {
                    Element elm = (Element) child;
                    NodeList list = elm.getElementsByTagName(tag);
                    if (list.getLength() > 0) {
                        String curr = list.item(0).getTextContent().trim();
                        if (curr.equals(value)) {
                            ret.add(child);
                        }
                    }
                }
            }
        }
        if (tag2 != null && value2 != null) {
            ret = ret.stream().filter(n -> hasTagValue(doc, node, tag2, value2))
                    .collect(Collectors.toList());
        }
        return ret;
    }

    private static Node getOrCreateNode(Document doc, Node node, String name) {
        return getOrCreateNode(doc, node, name, null, null, null, null);
    }

    private static Node getOrCreateNode(Document doc, Node node, String name,
            String tag, String value) {
        return getOrCreateNode(doc, node, name, tag, value, null, null);
    }

    private static Node getOrCreateNode(Document doc, Node node, String name,
            String tag, String value, String tag2, String value2) {
        List<Node> nodes = getNodes(doc, node, name, tag, value, tag2, value2);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        Element elem = doc.createElement(name);
        node.appendChild(elem);
        if (tag != null && value != null) {
            Element tagElem = doc.createElement(tag);
            tagElem.setTextContent(value);
            elem.appendChild(tagElem);
        }
        if (tag2 != null && value2 != null) {
            Element tagElem = doc.createElement(tag2);
            tagElem.setTextContent(value2);
            elem.appendChild(tagElem);
        }
        return elem;
    }

    private static boolean hasTagValue(Document doc, Node node, String tag,
            String value) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); i++) {
            Node child = children.item(i);
            if (child.getNodeType() == Node.ELEMENT_NODE) {
                Element elm = (Element) child;
                NodeList list = elm.getElementsByTagName(tag);
                if (list.getLength() > 0) {
                    String curr = list.item(0).getTextContent().trim();
                    if (curr.equals(value)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean assureTagValue(Document doc, Node node, String tag,
            String value) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); i++) {
            Node child = children.item(i);
            if (child.getNodeType() == Node.ELEMENT_NODE) {
                if (child.getNodeName().equals(tag)) {
                    if (!child.getTextContent().trim().equals(value)) {
                        child.setNodeValue(value);
                        return true;
                    }
                    return false;
                }

            }
        }
        Element tagElem = doc.createElement(tag);
        tagElem.setTextContent(value);
        node.appendChild(tagElem);
        return true;
    }
}